/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.jxta.access.AccessService;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.exception.ViolationException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.config.Config;
import net.jxta.impl.loader.RefJxtaLoader;
import net.jxta.impl.peergroup.CompatibilityEquater;
import net.jxta.impl.peergroup.PeerGroupInterface;
import net.jxta.impl.peergroup.RefCountPeerGroupInterface;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class GenericPeerGroup
implements RefPeerGroup {
    private static final Logger LOG = Logger.getLogger((String)GenericPeerGroup.class.getName());
    private static JxtaLoader loader;
    private EndpointService endpoint;
    private ResolverService resolver;
    private DiscoveryService discovery;
    private PipeService pipe;
    private MembershipService membership;
    private RendezVousService rendezvous;
    private PeerInfoService peerinfo;
    private AccessService access;
    private PeerAdvertisement peerAdvertisement = null;
    private PeerGroupAdvertisement peerGroupAdvertisement = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private PlatformConfig configAdvertisement = null;
    protected PeerGroup parentGroup = null;
    private Hashtable services = new Hashtable();
    private volatile boolean stopping = false;
    private boolean published = false;
    private int masterRefCount = 0;
    private boolean stopWhenUnreferenced = false;
    private volatile boolean initComplete = false;
    private ThreadGroup threadGroup = null;

    public static JxtaLoader getJxtaLoader() {
        return loader;
    }

    public static void setJxtaLoader(JxtaLoader newLoader) {
        loader = newLoader;
    }

    public ThreadGroup getHomeThreadGroup() {
        return this.threadGroup;
    }

    private Enumeration discoverSome(int type, String attr, String value, int seconds, Class thisClass) {
        return this.discoverSome(this.discovery, type, attr, value, seconds, thisClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Enumeration discoverSome(DiscoveryService discovery, int type, String attr, String value, int seconds, Class thisClass) {
        Vector<Advertisement> results = new Vector<Advertisement>();
        try {
            int count = 0;
            do {
                Enumeration res = discovery.getLocalAdvertisements(type, attr, value);
                while (res.hasMoreElements()) {
                    Advertisement a = (Advertisement)res.nextElement();
                    if (!thisClass.isInstance(a)) continue;
                    results.add(a);
                }
                if (results.size() > 0) return results.elements();
                if (count % 30 == 0) {
                    discovery.getRemoteAdvertisements(null, type, attr, value, 20);
                }
                Thread.sleep(1000L);
            } while (count++ < seconds);
            return results.elements();
        }
        catch (Exception whatever) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return results.elements();
            LOG.debug((Object)"Failure during discovery : ", (Throwable)whatever);
        }
        return results.elements();
    }

    private Advertisement discoverOne(int type, String attr, String value, int seconds, Class thisClass) {
        Enumeration res = this.discoverSome(type, attr, value, seconds, thisClass);
        if (!res.hasMoreElements()) {
            return null;
        }
        return (Advertisement)res.nextElement();
    }

    private void setShortCut(ID name, Service service) {
        if (endpointClassID.equals(name)) {
            this.endpoint = (EndpointService)service;
            return;
        }
        if (resolverClassID.equals(name)) {
            this.resolver = (ResolverService)service;
            return;
        }
        if (discoveryClassID.equals(name)) {
            this.discovery = (DiscoveryService)service;
            return;
        }
        if (pipeClassID.equals(name)) {
            this.pipe = (PipeService)service;
            return;
        }
        if (membershipClassID.equals(name)) {
            this.membership = (MembershipService)service;
            return;
        }
        if (peerinfoClassID.equals(name)) {
            this.peerinfo = (PeerInfoService)service;
            return;
        }
        if (rendezvousClassID.equals(name)) {
            this.rendezvous = (RendezVousService)service;
            return;
        }
        if (accessClassID.equals(name)) {
            this.access = (AccessService)service;
            return;
        }
    }

    private void clearShortCut(ModuleClassID name) {
        if (endpointClassID.equals(name)) {
            this.endpoint = null;
            return;
        }
        if (resolverClassID.equals(name)) {
            this.resolver = null;
            return;
        }
        if (discoveryClassID.equals(name)) {
            this.discovery = null;
            return;
        }
        if (pipeClassID.equals(name)) {
            this.pipe = null;
            return;
        }
        if (membershipClassID.equals(name)) {
            this.membership = null;
            return;
        }
        if (peerinfoClassID.equals(name)) {
            this.peerinfo = null;
            return;
        }
        if (rendezvousClassID.equals(name)) {
            this.rendezvous = null;
            return;
        }
        if (accessClassID.equals(name)) {
            this.access = null;
            return;
        }
    }

    private synchronized Service addServiceSync(ID name, Service service) {
        if (this.stopping) {
            return null;
        }
        Service p = (Service)this.services.remove(name);
        this.services.put(name, service);
        return p;
    }

    protected void addService(ID name, Service service) {
        Service oldp = this.addServiceSync(name, service);
        this.setShortCut(name, service);
        if (oldp != null && oldp != service) {
            LOG.warn((Object)("Service replaced for " + name));
        }
    }

    public synchronized Service lookupService(ID name) throws ServiceNotFoundException {
        Service p = (Service)this.services.get(name);
        if (p == null) {
            throw new ServiceNotFoundException(name.toString());
        }
        return p.getInterface();
    }

    public Service lookupService(ID name, int roleIndex) throws ServiceNotFoundException {
        if (roleIndex != 0) {
            throw new ServiceNotFoundException("" + name + "[" + roleIndex + "]");
        }
        return this.lookupService(name);
    }

    public Iterator getRoleMap(ID name) {
        return Collections.singletonList(name).iterator();
    }

    protected void checkServices() throws ServiceNotFoundException {
        Service ignored = this.lookupService(endpointClassID);
        ignored = this.lookupService(resolverClassID);
        ignored = this.lookupService(membershipClassID);
        ignored = this.lookupService(accessClassID);
    }

    private synchronized void removeAllServicesSync() {
        Map.Entry s;
        this.stopping = true;
        Iterator allServices = this.services.entrySet().iterator();
        while (allServices.hasNext()) {
            s = null;
            try {
                s = allServices.next();
                ((Service)s.getValue()).stopApp();
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                LOG.error((Object)("Failed stopping service: " + s), e);
            }
        }
        allServices = this.services.entrySet().iterator();
        while (allServices.hasNext()) {
            s = null;
            try {
                s = allServices.next();
                this.clearShortCut((ModuleClassID)s.getKey());
                allServices.remove();
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                LOG.error((Object)("Failed remove service: " + s), e);
            }
        }
    }

    private synchronized void removeServiceSync(ModuleClassID name, Service service) throws ServiceNotFoundException, ViolationException {
        Service p = (Service)this.services.get(name);
        if (p == null) {
            throw new ServiceNotFoundException(name.toString());
        }
        if (p != service) {
            throw new ViolationException("Service registered for key was did not match provided instance :" + name);
        }
        this.services.remove(name);
    }

    protected void removeService(ModuleClassID name, Service service) throws ServiceNotFoundException, ViolationException {
        this.removeServiceSync(name, service);
        this.clearShortCut(name);
    }

    public abstract boolean compatible(Element var1);

    public Module loadModule(ID assigned, Advertisement impl) throws ProtocolNotSupportedException, PeerGroupException {
        return this.loadModule(assigned, impl, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Module loadModule(ID assigned, Advertisement impl, boolean privileged) throws ProtocolNotSupportedException, PeerGroupException {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
        StructuredDocument compat = implAdv.getCompat();
        if (null == compat) {
            throw new IllegalArgumentException("No compatibility statement for : " + assigned);
        }
        if (!this.compatible(compat)) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) throw new ProtocolNotSupportedException("Incompatible Module : " + assigned);
            LOG.warn((Object)("Incompatible Module : " + assigned));
            throw new ProtocolNotSupportedException("Incompatible Module : " + assigned);
        }
        Module newMod = null;
        if (null == implAdv.getCode() || null == implAdv.getUri()) throw new PeerGroupException("Cannot load class for : " + assigned);
        try {
            Class clazz;
            try {
                clazz = loader.findClass(implAdv.getModuleSpecID());
            }
            catch (ClassNotFoundException notLoaded) {
                clazz = loader.defineClass(implAdv);
            }
            if (null == clazz) {
                throw new ClassNotFoundException("Cannot load class (" + implAdv.getCode() + ") : " + assigned);
            }
            newMod = (Module)clazz.newInstance();
            newMod.init(privileged ? this : (PeerGroup)this.getInterface(), assigned, implAdv);
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Loaded" + (privileged ? " privileged" : "") + " module : " + implAdv.getDescription() + " (" + implAdv.getCode() + ")"));
            }
        }
        catch (RuntimeException ex) {
            try {
                newMod.stopApp();
                throw ex;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw ex;
        }
        catch (PeerGroupException ex) {
            try {
                newMod.stopApp();
                throw ex;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw ex;
        }
        catch (Throwable ex) {
            try {
                newMod.stopApp();
                throw new PeerGroupException("Could not load module for : " + assigned + " (" + implAdv.getDescription() + ")", ex);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw new PeerGroupException("Could not load module for : " + assigned + " (" + implAdv.getDescription() + ")", ex);
        }
        try {
            if (this.discovery == null) return newMod;
            this.discovery.publish(impl, 31536000000L, 1209600000L);
            return newMod;
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return newMod;
    }

    public Module loadModule(ID assigned, ModuleSpecID specID, int where) {
        return this.loadModule(assigned, specID, where, false);
    }

    protected Module loadModule(ID assigned, ModuleSpecID specID, int where, boolean privileged) {
        boolean fromHere = where == 0 || where == 2;
        boolean fromParent = where == 1 || where == 2;
        ArrayList all = new ArrayList();
        if (fromHere && null != this.discovery) {
            Enumeration here = this.discoverSome(2, "MSID", specID.toString(), 120, ModuleImplAdvertisement.class);
            all.addAll(Collections.list(here));
        }
        if (fromParent && null != this.getParentGroup() && null != this.parentGroup.getDiscoveryService()) {
            Enumeration parent = this.discoverSome(this.parentGroup.getDiscoveryService(), 2, "MSID", specID.toString(), 120, ModuleImplAdvertisement.class);
            all.addAll(Collections.list(parent));
        }
        Iterator allModuleImpls = all.iterator();
        Throwable recentFailure = null;
        while (allModuleImpls.hasNext()) {
            ModuleImplAdvertisement found = null;
            try {
                Module newMod;
                block12: {
                    found = (ModuleImplAdvertisement)allModuleImpls.next();
                    if (!found.getModuleSpecID().equals(specID)) continue;
                    newMod = this.loadModule(assigned, found, privileged);
                    if (null != this.discovery) {
                        try {
                            this.discovery.publish(found, 31536000000L, 1209600000L);
                        }
                        catch (IOException nopublish) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                            LOG.warn((Object)"Could not publish module impl adv.", (Throwable)nopublish);
                        }
                    }
                }
                return newMod;
            }
            catch (Throwable e) {
                recentFailure = e;
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Not a usable impl adv: ", e);
            }
        }
        if (null != recentFailure) {
            if (recentFailure instanceof Error) {
                throw (Error)recentFailure;
            }
            if (recentFailure instanceof RuntimeException) {
                throw (RuntimeException)recentFailure;
            }
            throw new UndeclaredThrowableException(recentFailure);
        }
        if (LOG.isEnabledFor((Priority)Level.WARN)) {
            LOG.warn((Object)("Could not find a loadable implementation of SpecID: " + specID));
        }
        return null;
    }

    public ConfigParams getConfigAdvertisement() {
        return this.configAdvertisement;
    }

    protected void setConfigAdvertisement(ConfigParams config) {
        this.configAdvertisement = (PlatformConfig)config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PeerGroup homeGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        try {
            this.initFirst(homeGroup, assignedID, impl);
            this.initLast();
        }
        finally {
            this.initComplete = true;
        }
    }

    protected void initFirst(PeerGroup homeGroup, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)impl;
        this.parentGroup = homeGroup;
        try {
            DiscoveryService disco;
            Enumeration found;
            if (null == assignedID) {
                if ("cbid".equals(IDFactory.getDefaultIDFormat())) {
                    throw new IllegalStateException("Cannot generate group id for cbid group");
                }
                assignedID = IDFactory.newPeerGroupID();
            } else if (this.parentGroup != null && (found = (disco = this.parentGroup.getDiscoveryService()).getLocalAdvertisements(1, "GID", assignedID.toString())).hasMoreElements()) {
                this.peerGroupAdvertisement = (PeerGroupAdvertisement)found.nextElement();
            }
            if (!(assignedID instanceof PeerGroupID)) {
                throw new PeerGroupException("assignedID must be a peer group ID");
            }
            this.peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(PeerAdvertisement.getAdvertisementType());
            this.peerAdvertisement.setPeerGroupID((PeerGroupID)assignedID);
            if (this.configAdvertisement != null) {
                PeerID configPID = this.configAdvertisement.getPeerID();
                if (null == configPID || ID.nullID == configPID) {
                    if ("cbid".equals(IDFactory.getDefaultIDFormat())) {
                        XMLElement param = (XMLElement)((Object)this.configAdvertisement.getServiceParam(PeerGroup.membershipClassID));
                        if (null == param) {
                            throw new IllegalArgumentException(PSEConfigAdv.getAdvertisementType() + " could not be located");
                        }
                        Advertisement paramsAdv = null;
                        try {
                            paramsAdv = AdvertisementFactory.newAdvertisement(param);
                        }
                        catch (NoSuchElementException noadv) {
                            // empty catch block
                        }
                        if (!(paramsAdv instanceof PSEConfigAdv)) {
                            throw new IllegalArgumentException("Provided Advertisement was not a " + PSEConfigAdv.getAdvertisementType());
                        }
                        PSEConfigAdv config = (PSEConfigAdv)paramsAdv;
                        X509Certificate clientRoot = config.getCertificate();
                        byte[] pub_der = clientRoot.getPublicKey().getEncoded();
                        this.configAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID, pub_der));
                    } else {
                        this.configAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID));
                    }
                }
                this.peerAdvertisement.setPeerID(this.configAdvertisement.getPeerID());
                this.peerAdvertisement.setName(this.configAdvertisement.getName());
                this.peerAdvertisement.setDesc(this.configAdvertisement.getDesc());
            } else if (null == this.parentGroup) {
                this.peerAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)assignedID));
            } else {
                this.peerAdvertisement.setPeerID(this.parentGroup.getPeerAdvertisement().getPeerID());
                this.peerAdvertisement.setName(this.parentGroup.getPeerAdvertisement().getName());
                this.peerAdvertisement.setDesc(this.parentGroup.getPeerAdvertisement().getDesc());
            }
            if (this.peerGroupAdvertisement == null) {
                this.peerGroupAdvertisement = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
                this.peerGroupAdvertisement.setPeerGroupID((PeerGroupID)assignedID);
                this.peerGroupAdvertisement.setModuleSpecID(this.implAdvertisement.getModuleSpecID());
            } else {
                this.published = true;
            }
            if (this.configAdvertisement == null) {
                PlatformConfig conf = (PlatformConfig)AdvertisementFactory.newAdvertisement(PlatformConfig.getAdvertisementType());
                conf.setPeerID(this.peerAdvertisement.getPeerID());
                conf.setName(this.peerAdvertisement.getName());
                conf.setDesc(this.peerAdvertisement.getDesc());
                this.configAdvertisement = conf;
            }
            Hashtable grpParams = this.peerGroupAdvertisement.getServiceParams();
            Enumeration keys = grpParams.keys();
            while (keys.hasMoreElements()) {
                ID key = (ID)keys.nextElement();
                Element e = (Element)grpParams.get(key);
                if (this.configAdvertisement.getServiceParam(key) != null) continue;
                this.configAdvertisement.putServiceParam(key, e);
            }
            if (!globalRegistry.registerInstance((PeerGroupID)assignedID, this)) {
                throw new PeerGroupException("Group already instantiated");
            }
        }
        catch (Throwable any) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Group init failed", any);
            }
            if (any instanceof Error) {
                throw (Error)any;
            }
            if (any instanceof RuntimeException) {
                throw (RuntimeException)any;
            }
            if (any instanceof PeerGroupException) {
                throw (PeerGroupException)any;
            }
            throw new PeerGroupException("Group init failed", any);
        }
        ThreadGroup parentThreadGroup = null != this.parentGroup ? this.parentGroup.getHomeThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadGroup = new ThreadGroup(parentThreadGroup, "Group " + this.peerGroupAdvertisement.getPeerGroupID());
    }

    protected void initLast() throws PeerGroupException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Group : " + this.getPeerGroupID());
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tModule Spec ID : " + this.implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tPeer Group ID : " + this.getPeerGroupID());
            configInfo.append("\n\t\tGroup Name : " + this.getPeerGroupName());
            configInfo.append("\n\t\tPeer ID in Group : " + this.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null == this.parentGroup) {
                configInfo.append("\n\t\tHome Group : (none)");
            } else {
                configInfo.append("\n\t\tHome Group : \"" + this.parentGroup.getPeerGroupName() + "\" / " + this.parentGroup.getPeerGroupID());
            }
            configInfo.append("\n\t\tServices :");
            Iterator eachService = this.services.entrySet().iterator();
            while (eachService.hasNext()) {
                Map.Entry anEntry = eachService.next();
                ModuleClassID aMCID = (ModuleClassID)anEntry.getKey();
                ModuleImplAdvertisement anImplAdv = (ModuleImplAdvertisement)((Service)anEntry.getValue()).getImplAdvertisement();
                configInfo.append("\n\t\t\t" + aMCID + "\t" + anImplAdv.getDescription());
            }
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
        globalRegistry.unRegisterInstance(this.peerGroupAdvertisement.getPeerGroupID(), this);
        this.removeAllServicesSync();
        if (this.parentGroup != null) {
            this.parentGroup.unref();
            this.parentGroup = null;
        }
    }

    public void unref() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decRefCount() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            --this.masterRefCount;
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                Throwable trace = new Throwable("Stack Trace");
                StackTraceElement[] elements = trace.getStackTrace();
                LOG.info((Object)("[" + this.getPeerGroupID() + "] GROUP REF COUNT DECCREMENTED TO: " + this.masterRefCount + " by\n\t" + elements[2]));
            }
            if (this.masterRefCount != 0) {
                return;
            }
            if (!this.stopWhenUnreferenced) {
                return;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("[" + this.getPeerGroupID() + "] STOPPING UNREFERENCED GROUP"));
        }
        this.stopApp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getInterface() {
        GenericPeerGroup genericPeerGroup = this;
        synchronized (genericPeerGroup) {
            ++this.masterRefCount;
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                Throwable trace = new Throwable("Stack Trace");
                StackTraceElement[] elements = trace.getStackTrace();
                LOG.info((Object)("[" + this.getPeerGroupID() + "] GROUP REF COUNT INCREMENTED TO: " + this.masterRefCount + " by\n\t" + elements[1]));
            }
            if (this.initComplete) {
                this.stopWhenUnreferenced = true;
            }
        }
        return new RefCountPeerGroupInterface(this);
    }

    public PeerGroup getWeakInterface() {
        return new PeerGroupInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return (Advertisement)this.implAdvertisement.clone();
    }

    public void publishGroup(String name, String description) throws IOException {
        if (this.published) {
            return;
        }
        this.peerGroupAdvertisement.setName(name);
        this.peerGroupAdvertisement.setDescription(description);
        if (this.parentGroup == null) {
            return;
        }
        DiscoveryService parentDiscovery = this.parentGroup.getDiscoveryService();
        if (null == parentDiscovery) {
            return;
        }
        parentDiscovery.publish(this.peerGroupAdvertisement, 31536000000L, 1209600000L);
        this.published = true;
    }

    public PeerGroup newGroup(Advertisement pgAdv) throws PeerGroupException {
        PeerGroup theNewGroup;
        PeerGroupAdvertisement adv;
        block5: {
            adv = (PeerGroupAdvertisement)pgAdv;
            PeerGroupID gid = adv.getPeerGroupID();
            if (gid == null || ID.nullID.equals(gid)) {
                throw new IllegalArgumentException("Advertisement did not contain a peer group ID");
            }
            theNewGroup = globalRegistry.lookupInstance(gid);
            if (theNewGroup != null) {
                return theNewGroup;
            }
            try {
                this.discovery.publish(adv, 31536000000L, 1209600000L);
            }
            catch (Exception any) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"Could not publish the group advertisement: ", (Throwable)any);
            }
        }
        theNewGroup = (PeerGroup)this.loadModule(adv.getPeerGroupID(), adv.getModuleSpecID(), 0, false);
        if (theNewGroup == null) {
            throw new PeerGroupException("Could not find group implementation with " + adv.getModuleSpecID());
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    public PeerGroup newGroup(PeerGroupID gid, Advertisement impl, String name, String description) throws PeerGroupException {
        PeerGroup theNewGroup;
        block7: {
            theNewGroup = null;
            if (null != gid) {
                theNewGroup = globalRegistry.lookupInstance(gid);
            }
            if (theNewGroup != null) {
                return theNewGroup;
            }
            try {
                theNewGroup = (PeerGroup)this.loadModule((ID)gid, impl, false);
            }
            catch (Throwable any) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Could not load group implementation", any);
                }
                throw new PeerGroupException("Could not load group implementation", any);
            }
            try {
                theNewGroup.publishGroup(name, description);
            }
            catch (Exception any) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"Could not publish group or implementation:", (Throwable)any);
            }
        }
        return (PeerGroup)theNewGroup.getInterface();
    }

    public PeerGroup newGroup(PeerGroupID gid) throws PeerGroupException {
        PeerGroupAdvertisement adv;
        if (gid == null || ID.nullID.equals(gid)) {
            throw new IllegalArgumentException("Invalid peer group ID");
        }
        PeerGroup result = globalRegistry.lookupInstance(gid);
        if (result != null) {
            return result;
        }
        try {
            adv = (PeerGroupAdvertisement)this.discoverOne(1, "GID", gid.toString(), 120, PeerGroupAdvertisement.class);
        }
        catch (Throwable any) {
            throw new PeerGroupException("Failed finding group advertisement for " + gid, any);
        }
        if (adv == null) {
            throw new PeerGroupException("Could not find group advertisement for group " + gid);
        }
        return this.newGroup(adv);
    }

    public JxtaLoader getLoader() {
        return loader;
    }

    public String getPeerName() {
        return this.peerAdvertisement.getName();
    }

    public String getPeerGroupName() {
        return this.peerGroupAdvertisement.getName();
    }

    public PeerGroupID getPeerGroupID() {
        return this.peerGroupAdvertisement.getPeerGroupID();
    }

    public PeerID getPeerID() {
        return this.peerAdvertisement.getPeerID();
    }

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        return this.peerGroupAdvertisement;
    }

    public boolean isRendezvous() {
        if (this.rendezvous == null && LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Rendezvous service null");
        }
        return this.rendezvous != null && this.rendezvous.isRendezVous();
    }

    public EndpointService getEndpointService() {
        if (this.endpoint == null) {
            return null;
        }
        return (EndpointService)this.endpoint.getInterface();
    }

    public ResolverService getResolverService() {
        if (this.resolver == null) {
            return null;
        }
        return (ResolverService)this.resolver.getInterface();
    }

    public DiscoveryService getDiscoveryService() {
        if (this.discovery == null) {
            return null;
        }
        return (DiscoveryService)this.discovery.getInterface();
    }

    public PeerInfoService getPeerInfoService() {
        if (this.peerinfo == null) {
            return null;
        }
        return (PeerInfoService)this.peerinfo.getInterface();
    }

    public MembershipService getMembershipService() {
        if (this.membership == null) {
            return null;
        }
        return (MembershipService)this.membership.getInterface();
    }

    public PipeService getPipeService() {
        if (this.pipe == null) {
            return null;
        }
        return (PipeService)this.pipe.getInterface();
    }

    public RendezVousService getRendezVousService() {
        if (this.rendezvous == null) {
            return null;
        }
        return (RendezVousService)this.rendezvous.getInterface();
    }

    public AccessService getAccessService() {
        if (this.access == null) {
            return null;
        }
        return (AccessService)this.access.getInterface();
    }

    public abstract ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception;

    public PeerGroup getParentGroup() {
        if (this.parentGroup == null) {
            return null;
        }
        return this.parentGroup.getWeakInterface();
    }

    static {
        try {
            String localPath = "file://" + Config.JXTA_HOME + "Downloaded";
            URL fileURL = new URL(localPath);
            loader = new RefJxtaLoader(new URL[]{fileURL}, new CompatibilityEquater(){

                public boolean compatible(Element test) {
                    return StdPeerGroup.isCompatible(test);
                }
            });
        }
        catch (MalformedURLException bad) {
            LOG.fatal((Object)"Could not initialize JXTA class loader", (Throwable)bad);
        }
    }
}

