/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.meter.MonitorFilter;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RemoteMonitorQuery
implements DocumentSerializable {
    public static final String CUMULATIVE_REPORT_REQUEST = "cumulativeReport";
    public static final String REGISTER_MONITOR_REQUEST = "registerMonitor";
    public static final String REMOVE_MONITOR_REQUEST = "removeMonitor";
    public static final String VALIDATE_FILTER_REQUEST = "validateFilter";
    public static final String VALIDATE_CUMULATIVE_FILTER_REQUEST = "validateCumulativeFilter";
    public static final String GET_MONITORING_CAPABILITIES_REQUEST = "remoteMonitoringCapabilities";
    public static final String PEER_MONITOR_INFO = "peerMonitorInfo";
    public static final String RENEW_LEASE = "renewLease";
    private String requestType;
    private MonitorFilter monitorFilter;
    private boolean includeCumulative;
    private long reportRate = -1L;
    private long lease = -1L;
    private int leaseId;
    static /* synthetic */ Class class$net$jxta$meter$MonitorFilter;

    public RemoteMonitorQuery() {
    }

    private RemoteMonitorQuery(String requestType) {
        this.requestType = requestType;
    }

    public MonitorFilter getMonitorFilter() {
        return this.monitorFilter;
    }

    private String getRequestType() {
        return this.requestType;
    }

    public long getReportRate() {
        return this.reportRate;
    }

    public long getLease() {
        return this.lease;
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public boolean isIncludeCumulative() {
        return this.includeCumulative;
    }

    boolean isCumulativeReportQuery() {
        return this.requestType.equals(CUMULATIVE_REPORT_REQUEST);
    }

    boolean isRegisterMonitorQuery() {
        return this.requestType.equals(REGISTER_MONITOR_REQUEST);
    }

    boolean isRemoveMonitorQuery() {
        return this.requestType.equals(REMOVE_MONITOR_REQUEST);
    }

    boolean isValidateFilterRequest() {
        return this.requestType.equals(VALIDATE_FILTER_REQUEST);
    }

    boolean isValidateCumulativeFilterRequest() {
        return this.requestType.equals(VALIDATE_CUMULATIVE_FILTER_REQUEST);
    }

    boolean isPeerMonitorInfoQuery() {
        return this.requestType.equals(PEER_MONITOR_INFO);
    }

    boolean isLeaseRenewal() {
        return this.requestType.equals(RENEW_LEASE);
    }

    static RemoteMonitorQuery createGetCumulativeReportQuery(MonitorFilter monitorFilter) {
        RemoteMonitorQuery remoteMonitorQuery = new RemoteMonitorQuery(CUMULATIVE_REPORT_REQUEST);
        remoteMonitorQuery.monitorFilter = monitorFilter;
        return remoteMonitorQuery;
    }

    static RemoteMonitorQuery createRegisterMonitorQuery(boolean includeCumulative, MonitorFilter monitorFilter, long reportRate, long lease) {
        RemoteMonitorQuery remoteMonitorQuery = new RemoteMonitorQuery(REGISTER_MONITOR_REQUEST);
        remoteMonitorQuery.monitorFilter = monitorFilter;
        remoteMonitorQuery.reportRate = reportRate;
        remoteMonitorQuery.lease = lease;
        remoteMonitorQuery.includeCumulative = includeCumulative;
        return remoteMonitorQuery;
    }

    static RemoteMonitorQuery createRemoveMonitorListenerQuery(int leaseId) {
        RemoteMonitorQuery remoteMonitorQuery = new RemoteMonitorQuery(REMOVE_MONITOR_REQUEST);
        remoteMonitorQuery.leaseId = leaseId;
        return remoteMonitorQuery;
    }

    static RemoteMonitorQuery createPeerMonitorInfoQuery() {
        RemoteMonitorQuery remoteMonitorQuery = new RemoteMonitorQuery(PEER_MONITOR_INFO);
        return remoteMonitorQuery;
    }

    static RemoteMonitorQuery createLeaseRenewalQuery(int leaseId, long requestedLease) {
        RemoteMonitorQuery remoteMonitorQuery = new RemoteMonitorQuery(RENEW_LEASE);
        remoteMonitorQuery.leaseId = leaseId;
        remoteMonitorQuery.lease = requestedLease;
        return remoteMonitorQuery;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "requestType", this.requestType);
        if (this.monitorFilter != null) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "monitorFilter", this.monitorFilter);
        }
        if (this.lease > 0L) {
            DocumentSerializableUtilities.addLong(element2, "lease", this.lease);
        }
        if (this.leaseId > -1) {
            DocumentSerializableUtilities.addInt(element2, "leaseId", this.leaseId);
        }
        if (this.reportRate > 0L) {
            DocumentSerializableUtilities.addLong(element2, "reportRate", this.reportRate);
        }
        if (this.includeCumulative) {
            DocumentSerializableUtilities.addBoolean(element2, "includeCumulative", this.includeCumulative);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("requestType")) {
                this.requestType = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("monitorFilter")) {
                this.monitorFilter = (MonitorFilter)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, class$net$jxta$meter$MonitorFilter == null ? RemoteMonitorQuery.class$("net.jxta.meter.MonitorFilter") : class$net$jxta$meter$MonitorFilter);
                continue;
            }
            if (tagName.equals("lease")) {
                this.lease = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (tagName.equals("leaseId")) {
                this.leaseId = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("reportRate")) {
                this.reportRate = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (!tagName.equals("includeCumulative")) continue;
            this.includeCumulative = DocumentSerializableUtilities.getBoolean(childElement);
        }
    }
}

