/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import net.jxta.impl.util.BASE64InputStream;
import net.jxta.impl.util.BASE64OutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameTokenizer;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PSEUtils {
    private static final transient Logger LOG = Logger.getLogger((String)PSEUtils.class.getName());
    private static final PSEUtils UTILS = new PSEUtils();
    final transient SecureRandom srng;
    static final String PKCS5_PBSE1_ALGO = "PBEWithMD5AndDES";

    private PSEUtils() {
        block4: {
            this.srng = new SecureRandom();
            try {
                ClassLoader sysloader = ClassLoader.getSystemClassLoader();
                Class<?> loaded = sysloader.loadClass(BouncyCastleProvider.class.getName());
                Provider provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                loaded = sysloader.loadClass(PSEProvider.class.getName());
                provider = (Provider)loaded.newInstance();
                Security.addProvider(provider);
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Loaded Security Providers into system class loader");
                }
            }
            catch (Exception disallowed) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Can't load Security Providers into System Class Loader, using local class loader (this may not work)", (Throwable)disallowed);
                }
                Security.addProvider((Provider)new BouncyCastleProvider());
                Security.addProvider(new PSEProvider());
                if (!LOG.isEnabledFor((Priority)Level.INFO)) break block4;
                LOG.info((Object)"Loaded Security Providers into local class loader");
            }
        }
    }

    public static IssuerInfo genCert(String cn, IssuerInfo issuerinfo) throws SecurityException {
        try {
            String useCN;
            if (null == issuerinfo) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Generating Self Signed Cert ...");
                }
                useCN = !cn.endsWith("-CA") ? cn + "-CA" : cn;
            } else {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Generating Client Cert ...");
                }
                useCN = cn;
            }
            Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
            attrs.put(X509Principal.CN, useCN);
            attrs.put(X509Principal.O, "www.jxta.org");
            byte[] ou = new byte[10];
            PSEUtils.UTILS.srng.nextBytes(ou);
            String ouStr = PSEUtils.toHexDigits(ou);
            attrs.put(X509Principal.OU, ouStr);
            X509Principal subject = new X509Principal(attrs);
            X500Principal samesubject = new X500Principal(subject.getEncoded());
            KeyPairGenerator g = KeyPairGenerator.getInstance("RSA");
            g.initialize(1024, PSEUtils.UTILS.srng);
            KeyPair keypair = g.generateKeyPair();
            return PSEUtils.genCert(samesubject, keypair, issuerinfo);
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"Could not generate certificate", (Throwable)e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
    }

    public static IssuerInfo genCert(X500Principal subject, KeyPair keypair, IssuerInfo issuerinfo) throws SecurityException {
        try {
            X509Principal issuer;
            PrivateKey signer;
            if (null == issuerinfo) {
                signer = keypair.getPrivate();
                issuer = new X509Principal(subject.getEncoded());
            } else {
                signer = issuerinfo.subjectPkey;
                X500Principal issuer_subject = issuerinfo.cert.getSubjectX500Principal();
                issuer = new X509Principal(issuer_subject.getEncoded());
            }
            Date today = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(today);
            cal.add(1, 10);
            Date until = cal.getTime();
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setIssuerDN((X509Name)issuer);
            certGen.setSubjectDN((X509Name)new X509Principal(subject.getEncoded()));
            certGen.setNotBefore(today);
            certGen.setNotAfter(until);
            certGen.setPublicKey(keypair.getPublic());
            certGen.setSignatureAlgorithm("SHA1withRSA");
            certGen.setSerialNumber(BigInteger.valueOf(1L));
            IssuerInfo info = new IssuerInfo();
            info.cert = certGen.generateX509Certificate(signer, PSEUtils.UTILS.srng);
            info.subjectPkey = keypair.getPrivate();
            info.issuer = null == issuerinfo ? info.cert : issuerinfo.cert;
            info.issuerPkey = signer;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                if (null == issuer) {
                    LOG.debug((Object)("Root Cert : \n" + info.cert.toString()));
                } else {
                    LOG.debug((Object)("Client Cert : \n" + info.cert.toString()));
                }
            }
            return info;
        }
        catch (SignatureException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"Could not generate certificate", (Throwable)e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
        catch (InvalidKeyException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"Could not generate certificate", (Throwable)e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
        catch (IOException e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.debug((Object)"Could not generate certificate", (Throwable)e);
            }
            SecurityException failure = new SecurityException("Could not generate certificate");
            failure.initCause(e);
            throw failure;
        }
    }

    public static String getCertSubjectCName(X509Certificate cert) {
        X500Principal subject = cert.getSubjectX500Principal();
        X509NameTokenizer tokens = new X509NameTokenizer(subject.getName());
        while (tokens.hasMoreTokens()) {
            String attribute;
            String aToken = tokens.nextToken();
            if (aToken.length() < 3 || !"CN=".equalsIgnoreCase(attribute = aToken.substring(0, 3))) continue;
            return aToken.substring(3);
        }
        return null;
    }

    public static byte[] computeSignature(String algorithm, PrivateKey key, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initSign(key, PSEUtils.UTILS.srng);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.sign();
    }

    public static boolean verifySignature(String algorithm, Certificate cert, byte[] signature, InputStream stream) throws InvalidKeyException, SignatureException, IOException {
        int read;
        Signature sign;
        try {
            sign = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException badsigner) {
            throw new IOException("Could not initialize signer with algorithm " + algorithm);
        }
        sign.initVerify(cert);
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer)) >= 0) {
            sign.update(buffer, 0, read);
        }
        return sign.verify(signature);
    }

    public static byte[] hash(String algorithm, byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static EncryptedPrivateKeyInfo pkcs5_Encrypt_pbePrivateKey(char[] password, PrivateKey privkey, int iterations) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Encrypting " + privkey + " with '" + new String(password) + "'"));
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        byte[] salt = new byte[8];
        PSEUtils.UTILS.srng.nextBytes(salt);
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, iterations);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(PKCS5_PBSE1_ALGO);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] encryptedPrivKey = pbeCipher.doFinal(privkey.getEncoded());
            AlgorithmParameters algo = AlgorithmParameters.getInstance(PKCS5_PBSE1_ALGO);
            algo.init(pbeParamSpec);
            EncryptedPrivateKeyInfo result = new EncryptedPrivateKeyInfo(algo, encryptedPrivKey);
            return result;
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Encrypt failed", (Throwable)failed);
            }
            return null;
        }
    }

    public static PrivateKey pkcs5_Decrypt_pbePrivateKey(char[] password, String algorithm, EncryptedPrivateKeyInfo encryptedPrivKey) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Decrypting " + encryptedPrivKey + "/" + algorithm + " with '" + new String(password) + "'"));
        }
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        try {
            PKCS8EncodedKeySpec key_spec;
            AlgorithmParameters algo = encryptedPrivKey.getAlgParameters();
            if (null == algo) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Could not get algo parameters from " + encryptedPrivKey));
                }
                throw new IllegalStateException("Could not get algo parameters from " + encryptedPrivKey);
            }
            PBEParameterSpec pbeParamSpec = (PBEParameterSpec)algo.getParameterSpec(PBEParameterSpec.class);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PKCS5_PBSE1_ALGO);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(PKCS5_PBSE1_ALGO);
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
            try {
                key_spec = encryptedPrivKey.getKeySpec(pbeCipher);
            }
            catch (InvalidKeySpecException failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Incorrect key for " + encryptedPrivKey + " : " + failed));
                }
                return null;
            }
            KeyFactory kf = KeyFactory.getInstance(algorithm);
            return kf.generatePrivate(key_spec);
        }
        catch (Exception failed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Decrypt failed", (Throwable)failed);
            }
            return null;
        }
    }

    public static String loadBase64Object(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readBase64Object(rdr, type);
        }
        return null;
    }

    public static byte[] loadObject(BufferedReader rdr, String type) throws IOException {
        if (null != PSEUtils.findObject(rdr, type)) {
            return PSEUtils.readObject(rdr, type);
        }
        return null;
    }

    public static String findObject(BufferedReader br, String type) throws IOException {
        String line;
        String prefix = "-----BEGIN ";
        String suffix = type == null ? "-----" : type + "-----";
        do {
            br.mark(1024);
            line = br.readLine();
            if (null != line) continue;
            return null;
        } while (!line.startsWith(prefix) || !line.endsWith(suffix));
        br.reset();
        return line.substring(prefix.length(), line.length() - 5);
    }

    public static String readBase64Object(BufferedReader br, String type) throws IOException {
        String suffix;
        String line = br.readLine();
        String prefix = "-----BEGIN ";
        String string = suffix = type == null ? "-----" : type + "-----";
        if (!line.startsWith(prefix) || !line.endsWith(suffix)) {
            throw new IOException("Not at begining of object");
        }
        StringBuffer block = new StringBuffer();
        while (null != (line = br.readLine()) && !line.startsWith("-----END ")) {
            block.append(line);
            block.append('\n');
        }
        return block.toString();
    }

    public static byte[] readObject(BufferedReader br, String type) throws IOException {
        String base64 = PSEUtils.readBase64Object(br, type);
        return PSEUtils.base64Decode(new StringReader(base64));
    }

    public static void writeBase64Object(BufferedWriter bw, String type, String object) throws IOException {
        bw.write("-----BEGIN ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.write(object);
        char lastChar = object.charAt(object.length() - 1);
        if ('\n' != lastChar && '\r' != lastChar) {
            bw.newLine();
        }
        bw.write("-----END ");
        bw.write(type);
        bw.write("-----");
        bw.newLine();
        bw.flush();
    }

    public static void writeObject(BufferedWriter out, String type, byte[] object) throws IOException {
        String base64 = PSEUtils.base64Encode(object);
        PSEUtils.writeBase64Object(out, type, base64);
    }

    public static String base64Encode(byte[] in) throws IOException {
        StringWriter base64 = new StringWriter();
        BASE64OutputStream b64os = new BASE64OutputStream(base64, 72);
        b64os.write(in);
        b64os.close();
        String encoded = base64.toString();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Encoded " + in.length + " bytes -> " + encoded.length() + " characters."));
        }
        return encoded;
    }

    public static byte[] base64Decode(Reader in) throws IOException {
        int c;
        BASE64InputStream b64is = new BASE64InputStream(in);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((c = b64is.read()) >= 0) {
            bos.write(c);
        }
        byte[] result = bos.toByteArray();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Decoded " + result.length + " bytes."));
        }
        return result;
    }

    private static String toHexDigits(byte theByte) {
        char[] HEXDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer result = new StringBuffer(2);
        result.append(HEXDIGITS[theByte >>> 4 & 0xF]);
        result.append(HEXDIGITS[theByte & 0xF]);
        return result.toString();
    }

    private static String toHexDigits(byte[] bytes) {
        StringBuffer encoded = new StringBuffer(bytes.length * 2);
        for (int eachByte = 0; eachByte < bytes.length; ++eachByte) {
            encoded.append(PSEUtils.toHexDigits(bytes[eachByte]).toUpperCase());
        }
        return encoded.toString();
    }

    public static class IssuerInfo {
        public X509Certificate cert;
        public PrivateKey subjectPkey;
        public X509Certificate issuer;
        public PrivateKey issuerPkey;
    }

    public static class PSEProvider
    extends Provider {
        public PSEProvider() {
            super("JXTAPSE", 2.3, "JXTA PSE Alias Provider");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.1", "PBEWithMD2AndDES");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.3", PSEUtils.PKCS5_PBSE1_ALGO);
            this.put("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.5.3", PSEUtils.PKCS5_PBSE1_ALGO);
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.10", "PBEWithSHA1AndDES");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.12", "PBKDF2");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.13", "PBES2");
            this.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.113549.1.5.14", "PBMAC1");
            Provider[] providers = Security.getProviders();
            Iterator<Provider> eachProvider = Arrays.asList(providers).iterator();
            ArrayList<String> providerNames = new ArrayList<String>();
            while (eachProvider.hasNext()) {
                Provider aProvider = eachProvider.next();
                providerNames.add(aProvider.getName());
            }
            boolean addedPBE = false;
            String overrideProp = System.getProperty("net.jxta.impl.membership.pse.PSEUtils.PBEParamsClass");
            if (null != overrideProp) {
                this.put("AlgorithmParameters.1.2.840.113549.1.5.3", overrideProp);
                addedPBE = true;
            }
            if (!addedPBE && providerNames.contains("SunJCE")) {
                this.put("AlgorithmParameters.1.2.840.113549.1.5.3", "com.sun.crypto.provider.PBEParameters");
                addedPBE = true;
            }
            if (!addedPBE && providerNames.contains("IBMJCE")) {
                this.put("AlgorithmParameters.1.2.840.113549.1.5.3", "com.ibm.crypto.provider.PBEParameters");
                addedPBE = true;
            }
            if (!addedPBE) {
                this.put("AlgorithmParameters.1.2.840.113549.1.5.3", "com.sun.crypto.provider.PBEParameters");
                LOG.warn((Object)"Could not find supported provider. Trying com.sun.crypto.provider.PBEParameters as last hope.");
            }
            this.put("KeyStore.PSE", "net.jxta.impl.membership.pse.PSEStore");
        }

        public String getProperty(String key) {
            String result = super.getProperty(key);
            return result;
        }

        public String getProperty(String key, String defaultValue) {
            String result = super.getProperty(key, defaultValue);
            return result;
        }
    }
}

