/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.id.UUID.Instantiator;
import net.jxta.impl.id.UUID.PeerGroupID;
import net.jxta.impl.id.UUID.UUID;
import org.apache.log4j.Logger;
import sun.net.www.protocol.urn.Handler;

public class IDFormat {
    private static final transient Logger LOG = Logger.getLogger((String)IDFormat.class.getName());
    public static final int IdByteArraySize = 64;
    public static final int uuidSize = 16;
    public static final int flagsSize = 1;
    public static final int flagsIdTypeOffset = 0;
    public static final byte flagCodatID = 1;
    public static final byte flagPeerGroupID = 2;
    public static final byte flagPeerID = 3;
    public static final byte flagPipeID = 4;
    public static final byte flagModuleClassID = 5;
    public static final byte flagModuleSpecID = 6;
    public static final int flagsOffset = 63;
    public static final PeerGroupID worldPeerGroupID = new PeerGroupID(new UUID(6440537112551973473L, 5366166917318070323L));
    public static final PeerGroupID defaultNetPeerGroupID = new PeerGroupID(new UUID(6440537112551973473L, 5643088537205231667L));
    static final Object[][] wellKnownIDs = new Object[][]{{net.jxta.peergroup.PeerGroupID.worldPeerGroupID, worldPeerGroupID}, {net.jxta.peergroup.PeerGroupID.defaultNetPeerGroupID, defaultNetPeerGroupID}};
    public static final IDFactory.Instantiator INSTANTIATOR = new Instantiator();

    protected IDFormat() {
    }

    static ID translateFromWellKnown(ID input) {
        for (int eachWellKnown = 0; eachWellKnown < wellKnownIDs.length; ++eachWellKnown) {
            ID aWellKnown = (ID)wellKnownIDs[eachWellKnown][0];
            if (!aWellKnown.equals(input)) continue;
            return (ID)wellKnownIDs[eachWellKnown][1];
        }
        return input;
    }

    static ID translateToWellKnown(ID input) {
        for (int eachWellKnown = 0; eachWellKnown < wellKnownIDs.length; ++eachWellKnown) {
            ID aLocalEncoding = (ID)wellKnownIDs[eachWellKnown][1];
            if (!aLocalEncoding.equals(input)) continue;
            return (ID)wellKnownIDs[eachWellKnown][0];
        }
        return input;
    }

    protected static URL getURL(String uniqueValue) {
        URL result = null;
        String encoded = Handler.encodeURN(uniqueValue);
        try {
            result = IDFactory.jxtaURL("urn", "", "jxta:" + encoded);
        }
        catch (MalformedURLException failed) {
            LOG.error((Object)"Failed to construct URL", (Throwable)failed);
            throw new UndeclaredThrowableException(failed, "Failed to construct URL");
        }
        return result;
    }

    protected static URI toURI(String uniqueValue) {
        return URI.create("urn:jxta:" + uniqueValue);
    }
}

