/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.transportMeter;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.exception.JxtaException;
import net.jxta.meter.MonitorResources;
import net.jxta.meter.ServiceMonitorFilter;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.util.JxtaUtilities;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class TransportServiceMonitorFilter
implements ServiceMonitorFilter {
    private ModuleClassID moduleClassID = MonitorResources.transportServiceMonitorClassID;
    private LinkedList includedTransports = new LinkedList();
    private boolean includeAllTransports = true;

    public void init(ModuleClassID moduleClassID) {
        this.moduleClassID = moduleClassID;
    }

    public ModuleClassID getModuleClassID() {
        return this.moduleClassID;
    }

    public void removeAllTransports() {
        this.includedTransports.clear();
        this.includeAllTransports = false;
    }

    public void includeAllTransports(boolean includeAllTransports) {
        this.includeAllTransports = includeAllTransports;
    }

    public void includeTransport(String protocol) {
        this.includedTransports.add(protocol);
    }

    public boolean hasTransport(String protocol) {
        if (this.includeAllTransports) {
            return true;
        }
        Iterator i = this.includedTransports.iterator();
        while (i.hasNext()) {
            String includedTransport = (String)i.next();
            if (!includedTransport.equals(protocol)) continue;
            return true;
        }
        return false;
    }

    public void includeTransport(ModuleSpecID transportModuleClassID, String subProtocol) {
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "moduleClassID", this.moduleClassID.toString());
        DocumentSerializableUtilities.addBoolean(element2, "includeAllTransports", this.includeAllTransports);
        Iterator i = this.includedTransports.iterator();
        while (i.hasNext()) {
            String includedTransport = (String)i.next();
            DocumentSerializableUtilities.addString(element2, "includedTransport", includedTransport);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("moduleClassID")) {
                try {
                    this.moduleClassID = (ModuleClassID)JxtaUtilities.getIdFromString(DocumentSerializableUtilities.getString(childElement));
                }
                catch (JxtaException jex) {
                    throw new DocumentSerializationException("Can't read moduleClassID", jex);
                }
            }
            if (tagName.equals("includedTransport")) {
                String includedTransport = DocumentSerializableUtilities.getString(childElement);
                this.includedTransports.add(includedTransport);
            }
            if (!tagName.equals("includeAllTransports")) continue;
            this.includeAllTransports = DocumentSerializableUtilities.getBoolean(childElement);
        }
    }
}

