/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class JTlsOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getLogger((String)JTlsOutputStream.class.getName());
    private static final int MAXRETRQSIZE = 100;
    private static final long initRTT = 1000L;
    private static final MessageElement RETELT = new StringMessageElement("MARKRetr", "TLSRET", null);
    private static final int RWINDOW = 5;
    private volatile boolean closed = false;
    private volatile boolean closing = false;
    private volatile int sequenceNumber = 0;
    private volatile int maxACK = 0;
    private TlsTransport tp = null;
    private TlsConn conn = null;
    private Retransmitter retransmitter = null;
    private volatile long aveRTT = 1000L;
    private int nACKS = 0;
    private volatile long RTO = 0L;
    private volatile long minRTO = 1000L;
    private volatile long maxRTO = 5000L;
    private volatile long lastACKTime = 0L;
    private volatile long sackRetransTime = 0L;
    List retrQ = new Vector(25, 5);
    private int nIQTests = 0;
    private int aveIQSize = 0;
    private volatile int mrrIQFreeSpace = 0;
    private int rmaxQSize = 0;

    JTlsOutputStream(TlsTransport tp, TlsConn conn) {
        this.conn = conn;
        this.tp = tp;
        this.RTO = this.minRTO;
        this.mrrIQFreeSpace = this.rmaxQSize = 20;
        this.lastACKTime = TimeUtils.timeNow();
        this.sackRetransTime = TimeUtils.timeNow();
        this.retransmitter = new Retransmitter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        super.close();
        this.closed = true;
        Retransmitter temp = this.retransmitter;
        if (null != temp) {
            Retransmitter retransmitter = temp;
            synchronized (retransmitter) {
                temp.notifyAll();
            }
        }
        this.retrQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosing() {
        List list = this.retrQ;
        synchronized (list) {
            this.closing = true;
            this.retrQ.notifyAll();
        }
    }

    public void write(int c) throws IOException {
        byte[] a = new byte[]{(byte)(c & 0xFF)};
        this.write(a, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Message jmsg = new Message();
        if (this.closed) {
            throw new IOException("stream is closed");
        }
        if (b == null) {
            throw new IllegalArgumentException("buffer is null");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        JTlsOutputStream jTlsOutputStream = this;
        synchronized (jTlsOutputStream) {
            ByteArrayMessageElement ciphertext = new ByteArrayMessageElement(Integer.toString(++this.sequenceNumber), JTlsDefs.BLOCKS, data, null);
            jmsg.addMessageElement("jxtatls", ciphertext);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("TLS CT WRITE : seqn#" + this.sequenceNumber + " length=" + len));
            }
            List list = this.retrQ;
            synchronized (list) {
                int maxwait = Math.min((int)this.aveRTT, 200);
                int waitCt = Math.max(maxwait / 60, 1);
                if (this.retrQ.size() > 0) {
                    long inQueue = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ((RetrQElt)this.retrQ.get((int)0)).enqueuedAt);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("write : Retry queue idle for " + inQueue));
                    }
                    if (inQueue > this.tp.RETRMAXAGE) {
                        if (inQueue > 2L * this.tp.RETRMAXAGE) {
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)("Closing stale connection " + this.conn));
                            }
                            try {
                                this.conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                            throw new IOException("stream is closed");
                        }
                        if (this.retrQ.size() >= 100) {
                            waitCt = Integer.MAX_VALUE;
                        }
                    }
                }
                int i = 0;
                while (!(this.closed || this.mrrIQFreeSpace >= this.rmaxQSize / 5 && this.retrQ.size() <= this.rmaxQSize)) {
                    if (i++ == waitCt) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                        LOG.debug((Object)("write() wait for ACK, maxwait timer expired while enqueuing seqn#" + this.sequenceNumber));
                        break;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("write() wait 60ms for ACK while enqueuing seqn#" + this.sequenceNumber + "\n\tremote IQ free space = " + this.mrrIQFreeSpace + "\n\tMIN free space to continue = " + this.rmaxQSize / 5 + "" + "\n\tretQ.size()=" + this.retrQ.size()));
                    }
                    try {
                        this.retrQ.wait(60L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.interrupted();
                    }
                }
                RetrQElt r = new RetrQElt(this.sequenceNumber, (Message)jmsg.clone());
                this.retrQ.add(r);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Retrans Enqueue added seqn#" + this.sequenceNumber + " retQ.size()=" + this.retrQ.size()));
                }
            }
        }
        this.conn.sendToRemoteTls(jmsg);
        --this.mrrIQFreeSpace;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("TLS CT SENT : seqn#" + this.sequenceNumber + " length=" + len));
        }
    }

    private void calcRTT(long enqueuedAt) {
        long dt = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), enqueuedAt);
        if (dt == 0L) {
            ++dt;
        }
        int n = this.nACKS++;
        this.aveRTT = ((long)n * this.aveRTT + dt) / (long)this.nACKS;
        this.RTO = (this.aveRTT << 1) + (this.aveRTT >> 1);
        this.RTO = Math.max(this.RTO, this.minRTO);
        this.RTO = Math.min(this.RTO, this.maxRTO);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("TLS!! RTT = " + dt + "ms aveRTT = " + this.aveRTT + "ms" + " RTO = " + this.RTO + "ms"));
        }
    }

    private int calcAVEIQ(int iq) {
        int n = this.nIQTests++;
        this.aveIQSize = (n * this.aveIQSize + iq) / this.nIQTests;
        return this.aveIQSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackReceived(int seqnum, int[] sackList) {
        this.lastACKTime = TimeUtils.timeNow();
        int numberACKed = 0;
        List list = this.retrQ;
        synchronized (list) {
            this.maxACK = Math.max(this.maxACK, seqnum);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                int y;
                StringBuffer dumpRETRQ = new StringBuffer("ACK RECEIVE : " + Integer.toString(seqnum));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tRETRQ (size=" + this.retrQ.size() + ")");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append(" : ");
                    for (y = 0; y < this.retrQ.size(); ++y) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        RetrQElt r = (RetrQElt)this.retrQ.get(y);
                        dumpRETRQ.append(r.seqnum);
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append('\n');
                }
                dumpRETRQ.append("\tSACKLIST (size=" + sackList.length + ")");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    dumpRETRQ.append(" : ");
                    for (y = 0; y < sackList.length; ++y) {
                        if (0 != y) {
                            dumpRETRQ.append(", ");
                        }
                        dumpRETRQ.append(sackList[y]);
                    }
                }
                LOG.debug((Object)dumpRETRQ);
            }
            Iterator eachRetryQueueEntry = this.retrQ.iterator();
            while (eachRetryQueueEntry.hasNext()) {
                RetrQElt r = (RetrQElt)eachRetryQueueEntry.next();
                if (r.seqnum > seqnum) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                    LOG.debug((Object)("r.seqnum :" + r.seqnum + " > seqnum :" + seqnum));
                    break;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("seqnum :" + seqnum));
                    LOG.debug((Object)("Removing :" + r.seqnum + " from retransmit queue"));
                }
                eachRetryQueueEntry.remove();
                if (0L != r.enqueuedAt) {
                    this.calcRTT(r.enqueuedAt);
                }
                r.msg.clear();
                r.msg = null;
                r = null;
                ++numberACKed;
            }
            if (numberACKed > 0) {
                TlsConn r = this.conn;
                synchronized (r) {
                    this.conn.lastAccessed = TimeUtils.timeNow();
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("TLS!! SEQUENTIALLY ACKD SEQN = " + seqnum + ", (" + numberACKed + " acked)"));
            }
            this.rmaxQSize = Math.max(this.rmaxQSize, sackList.length);
            this.mrrIQFreeSpace = this.rmaxQSize - sackList.length;
            int aveIQ = this.calcAVEIQ(sackList.length);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("remote IQ free space = " + this.mrrIQFreeSpace + " remote avg IQ occupancy = " + aveIQ));
            }
            int retrans = 0;
            if (sackList.length > 0) {
                Iterator eachRetrQElement = this.retrQ.iterator();
                int currentSACK = 0;
                while (eachRetrQElement.hasNext()) {
                    RetrQElt r = (RetrQElt)eachRetrQElement.next();
                    while (sackList[currentSACK] < r.seqnum && ++currentSACK != sackList.length) {
                    }
                    if (currentSACK == sackList.length) break;
                    if (sackList[currentSACK] == r.seqnum) {
                        eachRetrQElement.remove();
                        ++numberACKed;
                        long enqueuetime = r.enqueuedAt;
                        if (enqueuetime != 0L) {
                            this.calcRTT(enqueuetime);
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("TLS!! SACKD SEQN = " + r.seqnum));
                        }
                        r.msg.clear();
                        r.msg = null;
                        r = null;
                        continue;
                    }
                    if (seqnum >= r.seqnum) continue;
                    ++retrans;
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("RETR: Fill hole, SACK, seqn#" + r.seqnum + ", Window =" + retrans));
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("TLS!! SELECTIVE ACKD (" + numberACKed + ") " + retrans + " retrans wanted"));
                }
                if (retrans > 0) {
                    this.retransmit(Math.min(5, retrans), this.lastACKTime);
                    this.sackRetransTime = TimeUtils.timeNow();
                }
            }
            this.retrQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retransmit(int rwin, long triggerTime) {
        RetrQElt r;
        int numberToRetrans;
        ArrayList<RetrQElt> retransMsgs = new ArrayList<RetrQElt>();
        List list = this.retrQ;
        synchronized (list) {
            numberToRetrans = Math.min(this.retrQ.size(), rwin);
            if (numberToRetrans > 0 && LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("RETRANSMITING [rwindow = " + numberToRetrans + "]"));
            }
            for (int j = 0; j < numberToRetrans; ++j) {
                r = (RetrQElt)this.retrQ.get(j);
                if (r.marked == 0 ? TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < 6L * this.aveRTT / 5L : TimeUtils.toRelativeTimeMillis(triggerTime, r.sentAt) < this.aveRTT) continue;
                ++r.marked;
                retransMsgs.add(r);
            }
        }
        int retransmitted = 0;
        Iterator eachRetrans = retransMsgs.iterator();
        while (eachRetrans.hasNext()) {
            r = (RetrQElt)eachRetrans.next();
            eachRetrans.remove();
            try {
                Message sending;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("TLS!! RETRANSMIT seqn#" + r.seqnum));
                }
                if (null == (sending = r.msg)) continue;
                sending = (Message)sending.clone();
                sending.replaceMessageElement("jxtatls", RETELT);
                if (!this.conn.sendToRemoteTls(sending)) break;
                --this.mrrIQFreeSpace;
                ++retransmitted;
            }
            catch (IOException e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break;
                LOG.debug((Object)("FAILED RETRANS seqn#" + r.seqnum), (Throwable)e);
                break;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("RETRANSMITED " + retransmitted + " of " + numberToRetrans));
        }
        return retransmitted;
    }

    private class Retransmitter
    implements Runnable {
        Thread retransmitterThread;
        volatile int nretransmitted = 0;
        int nAtThisRTO = 0;

        public Retransmitter() {
            this.retransmitterThread = new Thread(((JTlsOutputStream)JTlsOutputStream.this).tp.myThreadGroup, this, "JXTA TLS Retransmiter for " + ((JTlsOutputStream)JTlsOutputStream.this).conn.destAddr);
            this.retransmitterThread.setDaemon(true);
            this.retransmitterThread.start();
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("STARTED TLS Retransmit thread, RTO = " + JTlsOutputStream.this.RTO));
            }
        }

        public int getRetransCount() {
            return this.nretransmitted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized void run() {
            try {
                try {
                    int idleCounter = 0;
                    while (!JTlsOutputStream.this.closed) {
                        long conn_idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ((JTlsOutputStream)JTlsOutputStream.this).conn.lastAccessed);
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("RETRANS : " + JTlsOutputStream.this.conn + " idle for " + conn_idle));
                        }
                        if (((JTlsOutputStream)JTlsOutputStream.this).tp.CONNECTION_IDLE_TIMEOUT < conn_idle) {
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)("RETRANS : Shutting down idle connection: " + JTlsOutputStream.this.conn));
                            }
                            try {
                                JTlsOutputStream.this.conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                                JTlsOutputStream.this.setClosing();
                            }
                            catch (IOException ignored) {
                                continue;
                            }
                            Object var14_14 = null;
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"STOPPED TLS Retransmit thread");
                            }
                            this.retransmitterThread = null;
                            JTlsOutputStream.this.retransmitter = null;
                            return;
                        }
                        List ignored = JTlsOutputStream.this.retrQ;
                        // MONITORENTER : ignored
                        try {
                            JTlsOutputStream.this.retrQ.wait(JTlsOutputStream.this.RTO);
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                        if (JTlsOutputStream.this.closed) break;
                        long sinceLastSACKRetr = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), JTlsOutputStream.this.sackRetransTime);
                        if (sinceLastSACKRetr < JTlsOutputStream.this.RTO) {
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                            LOG.debug((Object)("RETRANS : SACK retrans " + sinceLastSACKRetr + "ms ago"));
                            continue;
                        }
                        long sinceLastACK = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), JTlsOutputStream.this.lastACKTime);
                        List list = JTlsOutputStream.this.retrQ;
                        // MONITORENTER : list
                        long oldestInQueueWait = JTlsOutputStream.this.retrQ.size() > 0 ? TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), ((RetrQElt)JTlsOutputStream.this.retrQ.get((int)0)).enqueuedAt) : 0L;
                        // MONITOREXIT : list
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("RETRANS : Last ACK " + sinceLastACK + "ms ago. Age of oldest in Queue " + oldestInQueueWait + "ms"));
                        }
                        if (oldestInQueueWait > ((JTlsOutputStream)JTlsOutputStream.this).tp.RETRMAXAGE * 2L) {
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)("RETRANS : Shutting down stale connection: " + JTlsOutputStream.this.conn));
                            }
                            try {
                                JTlsOutputStream.this.conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                                JTlsOutputStream.this.setClosing();
                            }
                            catch (IOException ignored2) {
                                continue;
                            }
                            Object var14_15 = null;
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)"STOPPED TLS Retransmit thread");
                            }
                            this.retransmitterThread = null;
                            JTlsOutputStream.this.retransmitter = null;
                            return;
                        }
                        long realWait = Math.max(oldestInQueueWait, sinceLastACK);
                        if (realWait >= JTlsOutputStream.this.RTO && oldestInQueueWait >= JTlsOutputStream.this.RTO) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)"RETRANS : RTO RETRANSMISSION [5]");
                            }
                            int retransed = JTlsOutputStream.this.retransmit(5, TimeUtils.timeNow());
                            this.nretransmitted += retransed;
                            this.nAtThisRTO += retransed;
                            if (retransed > 0 && realWait >= 2L * JTlsOutputStream.this.RTO && this.nAtThisRTO >= 10) {
                                JTlsOutputStream.this.RTO = realWait > JTlsOutputStream.this.maxRTO ? JTlsOutputStream.this.maxRTO : 2L * JTlsOutputStream.this.RTO;
                                this.nAtThisRTO = 0;
                            }
                            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                            LOG.debug((Object)("RETRANS : RETRANSMISSION " + retransed + " retrans " + this.nAtThisRTO + " at this RTO (" + JTlsOutputStream.this.RTO + ") " + this.nretransmitted + " total retrans"));
                            continue;
                        }
                        if (++idleCounter == 2) {
                            JTlsOutputStream.this.RTO = JTlsOutputStream.this.minRTO;
                            idleCounter = 0;
                            this.nAtThisRTO = 0;
                        }
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("RETRANS : IDLE : RTO=" + JTlsOutputStream.this.RTO + " WAIT=" + realWait));
                    }
                    Object var14_16 = null;
                }
                catch (Throwable all) {
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                    Object var14_17 = null;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)"STOPPED TLS Retransmit thread");
                    }
                    this.retransmitterThread = null;
                    JTlsOutputStream.this.retransmitter = null;
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"STOPPED TLS Retransmit thread");
                }
                this.retransmitterThread = null;
                JTlsOutputStream.this.retransmitter = null;
                return;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"STOPPED TLS Retransmit thread");
                }
                this.retransmitterThread = null;
                JTlsOutputStream.this.retransmitter = null;
                throw throwable;
            }
        }
    }

    private static class RetrQElt {
        int seqnum;
        long enqueuedAt;
        volatile Message msg;
        int marked;
        long sentAt;

        public RetrQElt(int seqnum, Message msg) {
            this.seqnum = seqnum;
            this.msg = msg;
            this.sentAt = this.enqueuedAt = TimeUtils.timeNow();
            this.marked = 0;
        }
    }
}

