/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class TcpMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)TcpMessenger.class.getName());
    private EndpointAddress srcAddress = null;
    private MessageElement srcAddressElement = null;
    private EndpointAddress logicalDestAddress = null;
    private TcpTransport proto;
    volatile TcpConnection conn;
    boolean incoming = false;

    TcpMessenger(EndpointAddress destaddr, TcpConnection conn, TcpTransport p) throws IOException {
        super(p.group.getPeerGroupID(), destaddr, true);
        if (null == conn) {
            throw new IOException("Could not get connection for address " + this.dstAddress);
        }
        if (!conn.isConnected()) {
            throw new IOException("Connection was closed to " + this.dstAddress);
        }
        this.conn = conn;
        this.srcAddress = p.getPublicAddress();
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", this.srcAddress.toString(), (MessageElement)null);
        this.proto = p;
        this.incoming = true;
        this.logicalDestAddress = new EndpointAddress("jxta", conn.getDestinationPeerID().getUniqueValue().toString(), null, null);
    }

    TcpMessenger(EndpointAddress destaddr, TcpTransport p) throws IOException {
        this(destaddr, new TcpConnection(destaddr, p), p);
        this.incoming = false;
    }

    protected void start() {
        if (this.conn != null) {
            this.conn.start();
        }
    }

    public void closeImpl() {
        TcpConnection toClose = this.conn;
        if (toClose == null) {
            return;
        }
        this.conn = null;
        super.close();
        toClose.close();
    }

    public boolean isClosed() {
        TcpConnection holdIt = this.conn;
        if (holdIt == null) {
            return true;
        }
        if (holdIt.isConnected()) {
            return false;
        }
        super.close();
        this.conn = null;
        return true;
    }

    TransportBindingMeter getTransportBindingMeter() {
        if (this.conn != null) {
            return this.conn.getTransportBindingMeter();
        }
        return null;
    }

    public boolean isIdleImpl() {
        TcpConnection holdIt = this.conn;
        return holdIt == null || TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), holdIt.getLastUsed()) > 900000L;
    }

    public EndpointAddress getLogicalDestinationImpl() {
        EndpointAddress holdIt = this.logicalDestAddress;
        return holdIt == null ? null : (EndpointAddress)holdIt.clone();
    }

    public boolean sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        TcpConnection myConn = this.conn;
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending " + message + " to " + destAddressToUse + " on connection " + this.conn.getDestinationAddress()));
            }
            myConn.sendMessage(message);
        }
        catch (IOException caught) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Message send failed for " + message), (Throwable)caught);
            }
            this.close();
            throw caught;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Message send succeeded for " + message));
        }
        return true;
    }
}

