/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.ConnectException;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.endpoint.servlethttp.HttpClientMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpMessageSender
implements MessageSender {
    private static final Logger LOG = Logger.getLogger((String)HttpMessageSender.class.getName());
    private EndpointService endpointService = null;
    private ServletHttpTransport servletHttpTransport;
    private EndpointAddress publicAddress = null;
    private String peerId = null;
    private Map messengers = new WeakHashMap();

    public HttpMessageSender(EndpointService endpointService, ServletHttpTransport servletHttpTransport, EndpointAddress publicAddress, String peerId) throws PeerGroupException {
        this.endpointService = endpointService;
        this.servletHttpTransport = servletHttpTransport;
        this.publicAddress = publicAddress;
        this.peerId = peerId;
        if (endpointService.addMessageTransport(this) == null) {
            throw new PeerGroupException("Transport registration refused");
        }
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.publicAddress.clone();
    }

    public boolean isConnectionOriented() {
        return true;
    }

    public boolean allowsRouting() {
        return true;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HttpClientMessenger[] all;
        Map map = this.messengers;
        synchronized (map) {
            all = this.messengers.keySet().toArray(new HttpClientMessenger[0]);
            this.messengers.clear();
        }
        int i = all.length;
        while (i-- > 0) {
            all[i].doshutdown();
        }
    }

    public Messenger getMessenger(EndpointAddress destAddr, Object hintIgnored) {
        block7: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getMessenger for dest : " + destAddr.toString()));
            }
            if (!this.getProtocolName().equals(destAddr.getProtocolName())) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("could not make messenger for protocol :" + destAddr.getProtocolName()));
                }
                return null;
            }
            try {
                HttpClientMessenger result = new HttpClientMessenger(this.endpointService, this.servletHttpTransport, this.peerId, destAddr);
                this.messengers.put(result, null);
                return result;
            }
            catch (ConnectException noConnect) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Failed to connect to host for " + destAddr));
                }
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)("could not make messenger for " + destAddr), e);
            }
        }
        return null;
    }

    public boolean isPropagateEnabled() {
        return false;
    }

    public boolean isPropagationSupported() {
        return false;
    }

    public void propagate(Message msg, String serviceName, String serviceParams, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        boolean result = false;
        Messenger messenger = this.getMessenger(addr, null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Using http client sender to ping " + addr));
        }
        return messenger != null;
    }

    public String getProtocolName() {
        return this.servletHttpTransport.protocolName;
    }

    public EndpointService getEndpointService() {
        return this.endpointService;
    }
}

