/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.exception.PeerGroupException;
import net.jxta.impl.endpoint.servlethttp.HttpMessageServlet;
import net.jxta.impl.endpoint.servlethttp.HttpServletMessenger;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.MultiException;

public class HttpMessageReceiver
implements MessageReceiver {
    private static final Logger LOG = Logger.getLogger((String)HttpMessageReceiver.class.getName());
    private static final String MSG_RECEIVER_RELATIVE_URI = "/*";
    private EndpointService endpointService = null;
    private ServletHttpTransport servletHttpTransport = null;
    private List publicAddresses = null;
    private HttpServer server = null;
    private ServletHandler handler = null;
    private SocketListener listener = null;
    private MessengerEventListener messengerEventListener = null;

    public HttpMessageReceiver(EndpointService endpointService, ServletHttpTransport servletHttpTransport, List publicAddresses, InetAddress useInterface, int port, int minThreads, int maxThreads, int maxThreadIdleTime, int maxReqReadTime) throws IOException, PeerGroupException {
        this.endpointService = endpointService;
        this.servletHttpTransport = servletHttpTransport;
        this.publicAddresses = publicAddresses;
        Log.instance().disableLog();
        InetAddrPort addrPort = new InetAddrPort(useInterface, port);
        this.listener = new SocketListener(addrPort);
        this.listener.setMinThreads(minThreads);
        this.listener.setMaxThreads(maxThreads);
        this.listener.setMaxIdleTimeMs(maxThreadIdleTime);
        this.server = new HttpServer();
        this.server.addListener((HttpListener)this.listener);
        HttpContext handlerContext = this.server.getContext("/");
        this.handler = new ServletHandler();
        this.handler.setUsingCookies(false);
        this.handler.initialize(handlerContext);
        handlerContext.setClassLoader((ClassLoader)endpointService.getGroup().getLoader());
        handlerContext.addHandler((HttpHandler)this.handler);
        if (System.getProperty("net.jxta.http.allowdownload") != null) {
            HttpContext context = this.server.addContext("/midlets/*");
            context.setResourceBase("./midlets/");
            ResourceHandler resHandler = new ResourceHandler();
            context.addHandler((HttpHandler)resHandler);
        }
        this.handler.addServlet(MSG_RECEIVER_RELATIVE_URI, HttpMessageServlet.class.getName());
        this.messengerEventListener = endpointService.addMessageTransport(this);
        if (this.messengerEventListener == null) {
            throw new PeerGroupException("Transport registration refused");
        }
    }

    public void startServer() throws IOException {
        if (this.server != null) {
            try {
                this.server.start();
                this.handler.getServletContext().setAttribute("HttpMessageReceiver", (Object)this);
            }
            catch (MultiException e) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Could not start server", (Throwable)e);
                }
                IOException failure = new IOException("Could not start server");
                failure.initCause(e);
                throw failure;
            }
        }
    }

    public void stopServer() {
        block3: {
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (InterruptedException e) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    boolean messengerReadyEvent(HttpServletMessenger newMessenger, EndpointAddress connAddr) {
        return this.messengerEventListener.messengerReady(new MessengerEvent(this, newMessenger, connAddr));
    }

    public Iterator getPublicAddresses() {
        if (this.publicAddresses == null) {
            return null;
        }
        return Collections.unmodifiableList(this.publicAddresses).iterator();
    }

    public String getProtocolName() {
        return this.servletHttpTransport.protocolName;
    }

    public EndpointService getEndpointService() {
        return this.endpointService;
    }

    ServletHttpTransport getServletHttpTransport() {
        return this.servletHttpTransport;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }
}

