/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EndpointRouterMessage {
    private static final Logger LOG = Logger.getLogger((String)EndpointRouterMessage.class.getName());
    public static final String MESSAGE_NS = "jxta";
    public static final String MESSAGE_NAME = "EndpointRouterMsg";
    public static final String Name = "jxta:ERM";
    public static final String SrcTag = "Src";
    public static final String DestTag = "Dest";
    public static final String LastHopTag = "Last";
    public static final String GatewayForwardTag = "Fwd";
    public static final String GatewayReverseTag = "Rvs";
    private String srcAddress = null;
    private String destAddress = null;
    private String lastHop = null;
    private Vector forwardGateways = null;
    private Vector forwardCache = null;
    private Vector reverseGateways = null;
    private Vector reverseCache = null;
    private RouteAdvertisement radv = null;
    private boolean rmExists = false;
    private boolean rmDirty = false;
    private Message message = null;
    private MessageElement rmElem = null;

    public boolean msgExists() {
        return this.rmExists;
    }

    public boolean isDirty() {
        return this.rmDirty;
    }

    public EndpointRouterMessage(Message message, boolean removeMsg) {
        this.message = message;
        try {
            this.rmElem = message.getMessageElement(MESSAGE_NS, MESSAGE_NAME);
            if (this.rmElem == null) {
                return;
            }
            this.rmDirty = true;
            if (removeMsg) {
                return;
            }
            InputStream is = this.rmElem.getStream();
            StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, is);
            Enumeration enumeration = null;
            TextElement e = null;
            enumeration = doc.getChildren();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                try {
                    AccessPointAdvertisement xptAdv;
                    TextElement aXpt;
                    Enumeration eachXpt;
                    e = (TextElement)enumeration.nextElement();
                    if (e.getName().equals(SrcTag)) {
                        this.srcAddress = e.getTextValue();
                        continue;
                    }
                    if (e.getName().equals(DestTag)) {
                        this.destAddress = e.getTextValue();
                        continue;
                    }
                    if (e.getName().equals(LastHopTag)) {
                        this.lastHop = e.getTextValue();
                        continue;
                    }
                    if (e.getName().equals(GatewayForwardTag)) {
                        eachXpt = e.getChildren();
                        while (eachXpt.hasMoreElements()) {
                            if (this.forwardGateways == null) {
                                this.forwardGateways = new Vector();
                            }
                            if (this.forwardCache == null) {
                                this.forwardCache = new Vector();
                            }
                            aXpt = (TextElement)eachXpt.nextElement();
                            xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                            this.forwardGateways.addElement(xptAdv);
                            this.forwardCache.addElement(aXpt);
                        }
                        continue;
                    }
                    if (e.getName().equals(GatewayReverseTag)) {
                        eachXpt = e.getChildren();
                        while (eachXpt.hasMoreElements()) {
                            if (this.reverseGateways == null) {
                                this.reverseGateways = new Vector();
                            }
                            if (this.reverseCache == null) {
                                this.reverseCache = new Vector();
                            }
                            aXpt = (TextElement)eachXpt.nextElement();
                            xptAdv = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(aXpt);
                            this.reverseGateways.addElement(xptAdv);
                            this.reverseCache.addElement(aXpt);
                        }
                        continue;
                    }
                    if (!e.getName().equals(RouteAdvertisement.getAdvertisementType())) continue;
                    this.radv = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(e);
                }
                catch (Exception ee) {}
            }
            this.rmExists = true;
            this.rmDirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateMessage() {
        StructuredTextDocument doc;
        block33: {
            Element xptDoc;
            int i;
            if (!this.rmDirty) {
                return;
            }
            if (!this.rmExists) {
                while (this.rmElem != null) {
                    this.message.removeMessageElement(MESSAGE_NS, this.rmElem);
                    this.rmElem = this.message.getMessageElement(MESSAGE_NS, MESSAGE_NAME);
                }
                if (this.rmElem != null) {
                    this.message.removeMessageElement(MESSAGE_NS, this.rmElem);
                }
                this.rmElem = null;
                this.rmDirty = false;
                return;
            }
            doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, Name);
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
            }
            Element e = null;
            if (this.srcAddress != null) {
                e = doc.createElement(SrcTag, this.srcAddress);
                doc.appendChild(e);
            }
            if (this.destAddress != null) {
                e = doc.createElement(DestTag, this.destAddress);
                doc.appendChild(e);
            }
            if (this.lastHop != null) {
                e = doc.createElement(LastHopTag, this.lastHop);
                doc.appendChild(e);
            }
            AccessPointAdvertisement gateway = null;
            e = doc.createElement(GatewayForwardTag);
            doc.appendChild(e);
            if (this.forwardGateways != null && this.forwardGateways.size() > 0) {
                if (this.forwardCache != null) {
                    for (i = 0; i < this.forwardCache.size(); ++i) {
                        try {
                            xptDoc = (Element)this.forwardCache.elementAt(i);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                            continue;
                        }
                        catch (Exception e1) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Forward cache failed");
                            }
                            this.forwardCache = null;
                            break;
                        }
                    }
                } else {
                    for (i = 0; i < this.forwardGateways.size(); ++i) {
                        try {
                            gateway = (AccessPointAdvertisement)this.forwardGateways.elementAt(i);
                            xptDoc = (StructuredTextDocument)gateway.getDocument(MimeMediaType.XMLUTF8);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                            continue;
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
            }
            gateway = null;
            e = doc.createElement((Object)GatewayReverseTag, gateway);
            doc.appendChild(e);
            if (this.reverseGateways != null && this.reverseGateways.size() > 0) {
                if (this.reverseCache != null) {
                    for (i = 0; i < this.reverseCache.size(); ++i) {
                        try {
                            xptDoc = (Element)this.reverseCache.elementAt(i);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                            continue;
                        }
                        catch (Exception e1) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Reverse cache failed");
                            }
                            this.reverseCache = null;
                            break;
                        }
                    }
                } else {
                    for (i = 0; i < this.reverseGateways.size(); ++i) {
                        try {
                            gateway = (AccessPointAdvertisement)this.reverseGateways.elementAt(i);
                            xptDoc = (StructuredTextDocument)gateway.getDocument(MimeMediaType.XMLUTF8);
                            StructuredDocumentUtils.copyElements(doc, e, xptDoc);
                            continue;
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.radv != null) {
                try {
                    StructuredTextDocument radvDoc = (StructuredTextDocument)this.radv.getDocument(MimeMediaType.XMLUTF8);
                    StructuredDocumentUtils.copyElements(doc, doc, radvDoc);
                }
                catch (Exception e1) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block33;
                    LOG.warn((Object)"Cannot add route advertisement");
                }
            }
        }
        this.rmElem = new TextDocumentMessageElement(MESSAGE_NAME, doc, null);
        this.message.replaceMessageElement(MESSAGE_NS, this.rmElem);
        this.rmDirty = false;
    }

    public void setSrcAddress(EndpointAddress a) {
        this.rmExists = true;
        this.rmDirty = true;
        this.srcAddress = a.toString();
    }

    public EndpointAddress getSrcAddress() {
        return new EndpointAddress(this.srcAddress);
    }

    public void setDestAddress(EndpointAddress a) {
        this.rmExists = true;
        this.rmDirty = true;
        this.destAddress = a.toString();
    }

    public EndpointAddress getDestAddress() {
        return new EndpointAddress(this.destAddress);
    }

    public void setLastHop(String p) {
        this.rmExists = true;
        this.rmDirty = true;
        this.lastHop = p;
    }

    public String getLastHop() {
        return this.lastHop;
    }

    public void setForwardHops(Vector v) {
        this.rmExists = true;
        this.rmDirty = true;
        this.forwardGateways = v;
        this.forwardCache = null;
    }

    public Vector getForwardHops() {
        return this.forwardGateways;
    }

    public void prependReverseHop(AccessPointAdvertisement ap) {
        this.rmExists = true;
        this.rmDirty = true;
        if (this.reverseGateways == null) {
            this.reverseGateways = new Vector();
            this.reverseCache = new Vector();
        }
        this.reverseGateways.add(0, ap);
        if (this.reverseCache == null) {
            return;
        }
        StructuredTextDocument apDoc = (StructuredTextDocument)ap.getDocument(MimeMediaType.XMLUTF8);
        this.reverseCache.add(0, apDoc);
    }

    public void setReverseHops(Vector v) {
        this.rmExists = true;
        this.rmDirty = true;
        this.reverseGateways = v == null ? null : (Vector)v.clone();
        this.reverseCache = null;
    }

    public Vector getReverseHops() {
        if (this.reverseGateways == null) {
            return null;
        }
        return (Vector)this.reverseGateways.clone();
    }

    public RouteAdvertisement getRouteAdv() {
        return this.radv;
    }

    public void setRouteAdv(RouteAdvertisement radv) {
        this.rmExists = true;
        this.rmDirty = true;
        this.radv = radv;
    }

    public String display() {
        int i;
        StringBuffer msgInfo = new StringBuffer("Process Incoming : ");
        msgInfo.append("\n\tsrc=");
        msgInfo.append(this.srcAddress != null ? this.srcAddress : "none");
        msgInfo.append("\n\tdest== ");
        msgInfo.append(this.destAddress != null ? this.destAddress : "none");
        msgInfo.append("\n\tlastHop= ");
        msgInfo.append(this.lastHop != null ? this.lastHop : "none");
        msgInfo.append("\n\tembedded radv= ");
        msgInfo.append(this.radv != null ? this.radv.display() : "none");
        if (this.forwardGateways != null) {
            msgInfo.append("    Forward Hops:");
            for (i = 0; i < this.forwardGateways.size(); ++i) {
                try {
                    msgInfo.append("   [" + i + "] ");
                    msgInfo.append(((AccessPointAdvertisement)this.forwardGateways.elementAt(i)).getPeerID());
                    continue;
                }
                catch (Exception ez1) {
                    break;
                }
            }
        }
        if (this.reverseGateways != null) {
            msgInfo.append("    Reverse Hops:");
            for (i = 0; i < this.reverseGateways.size(); ++i) {
                try {
                    msgInfo.append("   [" + i + "] ");
                    msgInfo.append(((AccessPointAdvertisement)this.forwardGateways.elementAt(i)).getPeerID());
                    continue;
                }
                catch (Exception ez1) {
                    break;
                }
            }
        }
        return msgInfo.toString();
    }

    public void clearAll() {
        if (this.rmExists) {
            this.rmDirty = true;
            this.srcAddress = null;
            this.destAddress = null;
            this.lastHop = null;
            this.forwardGateways = null;
            this.reverseGateways = null;
            this.radv = null;
            this.rmExists = false;
        }
    }
}

