/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.relay;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.endpoint.relay.RelayServer;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RelayTransport
implements EndpointListener,
Service {
    private static final Logger LOG = Logger.getLogger((String)RelayTransport.class.getName());
    protected static final String protocolName = "relay";
    protected static final String RELAY_NS = "relay";
    protected static final String REQUEST_ELEMENT = "request";
    protected static final String RESPONSE_ELEMENT = "response";
    protected static final String PEERID_ELEMENT = "peerid";
    protected static final String LEASE_ELEMENT = "lease";
    protected static final String RELAY_ADV_ELEMENT = "relayAdv";
    protected static final String CONNECT_REQUEST = "connect";
    protected static final String DISCONNECT_REQUEST = "disconnect";
    protected static final String PID_REQUEST = "pid";
    protected static final String CONNECTED_RESPONSE = "connected";
    protected static final String DISCONNECTED_RESPONSE = "disconnected";
    protected static final String PID_RESPONSE = "pid";
    private static final int DEFAULT_MAX_CLIENTS = 150;
    private static final int DEFAULT_MAX_SERVERS = 1;
    private static final long DEFAULT_LEASE = 3600000L;
    private static final long DEFAULT_STALL_TIMEOUT = 15000L;
    private static final long DEFAULT_POLL_INTERVAL = 15000L;
    private static final long DEFAULT_BROADCAST_INTERVAL = 600000L;
    private static final int DEFAULT_CLIENT_QUEUE_SIZE = 20;
    private PeerGroup group = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private String serviceName = null;
    private RelayClient relayClient = null;
    private RelayServer relayServer = null;

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        boolean isServer = false;
        int serverMaxClients = 150;
        long serverLease = 3600000L;
        long messengerPollInterval = 15000L;
        long minBroadcastInterval = 600000L;
        boolean isClient = false;
        int clientMaxServers = 1;
        long clientLease = 3600000L;
        long stallTimeout = 15000L;
        int clientQueueSize = 20;
        ArrayList<EndpointAddress> relayServers = new ArrayList<EndpointAddress>();
        String peerId = group.getPeerID().getUniqueValue().toString();
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        this.serviceName = assignedID.getUniqueValue().toString();
        ConfigParams confAdv = group.getConfigAdvertisement();
        StructuredDocument paramBlock = null;
        if (confAdv != null) {
            paramBlock = confAdv.getServiceParam(assignedID);
        }
        if (paramBlock != null) {
            EndpointAddress addr;
            String server;
            Enumeration param;
            block43: {
                String tempStr;
                block42: {
                    block41: {
                        block40: {
                            String toStr;
                            block39: {
                                String leaseStr;
                                block38: {
                                    block37: {
                                        block36: {
                                            param = paramBlock.getChildren("isServer");
                                            isServer = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue().trim());
                                            param = paramBlock.getChildren("isClient");
                                            isClient = param.hasMoreElements() && "true".equals(((TextElement)param.nextElement()).getTextValue().trim());
                                            param = paramBlock.getChildren("ServerMaximumClients");
                                            if (param.hasMoreElements() && (tempStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                                                tempStr = tempStr.trim();
                                                try {
                                                    serverMaxClients = Integer.parseInt(tempStr);
                                                }
                                                catch (NumberFormatException e) {
                                                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block36;
                                                    LOG.warn((Object)"could not parse max client nb", (Throwable)e);
                                                }
                                            }
                                        }
                                        if ((param = paramBlock.getChildren("ClientMaximumServers")).hasMoreElements() && (tempStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                                            tempStr = tempStr.trim();
                                            try {
                                                clientMaxServers = Integer.parseInt(tempStr);
                                            }
                                            catch (NumberFormatException e) {
                                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block37;
                                                LOG.warn((Object)"could not parse max servers nb", (Throwable)e);
                                            }
                                        }
                                    }
                                    if ((param = paramBlock.getChildren("ServerLeaseInSeconds")).hasMoreElements() && (leaseStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                                        leaseStr = leaseStr.trim();
                                        try {
                                            serverLease = Long.parseLong(leaseStr);
                                            serverLease *= 1000L;
                                        }
                                        catch (NumberFormatException e) {
                                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block38;
                                            LOG.warn((Object)"could not parse lease string", (Throwable)e);
                                        }
                                    }
                                }
                                if ((param = paramBlock.getChildren("ClientLeaseInSeconds")).hasMoreElements() && (leaseStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                                    leaseStr = leaseStr.trim();
                                    try {
                                        clientLease = Long.parseLong(leaseStr);
                                        clientLease *= 1000L;
                                    }
                                    catch (NumberFormatException e) {
                                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block39;
                                        LOG.warn((Object)"could not parse lease string", (Throwable)e);
                                    }
                                }
                            }
                            if ((param = paramBlock.getChildren("StallTimeoutInSeconds")).hasMoreElements() && (toStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                                toStr = toStr.trim();
                                try {
                                    stallTimeout = Long.parseLong(toStr);
                                    if (stallTimeout < 1L) {
                                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                            LOG.warn((Object)"stallTimeout too short; raised to 1 second");
                                        }
                                        stallTimeout = 1L;
                                    }
                                    stallTimeout *= 1000L;
                                }
                                catch (NumberFormatException e) {
                                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block40;
                                    LOG.warn((Object)"could not parse stallTimeout string", (Throwable)e);
                                }
                            }
                        }
                        if ((param = paramBlock.getChildren("ClientQueueSize")).hasMoreElements() && (tempStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                            tempStr = tempStr.trim();
                            try {
                                clientQueueSize = Integer.parseInt(tempStr);
                            }
                            catch (NumberFormatException e) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block41;
                                LOG.warn((Object)"could not parse ClientQueueSize string", (Throwable)e);
                            }
                        }
                    }
                    if ((param = paramBlock.getChildren("BroadcastIntervalInSeconds")).hasMoreElements() && (tempStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                        tempStr = tempStr.trim();
                        try {
                            minBroadcastInterval = Long.parseLong(tempStr);
                            minBroadcastInterval *= 1000L;
                        }
                        catch (NumberFormatException e) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block42;
                            LOG.warn((Object)"could not parse BroadcastIntervalInSeconds string", (Throwable)e);
                        }
                    }
                }
                if ((param = paramBlock.getChildren("PollIntervalInSeconds")).hasMoreElements() && (tempStr = ((TextElement)param.nextElement()).getTextValue()) != null) {
                    tempStr = tempStr.trim();
                    try {
                        messengerPollInterval = Long.parseLong(tempStr);
                        messengerPollInterval *= 1000L;
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block43;
                        LOG.warn((Object)"could not parse PollIntervalInSeconds string", (Throwable)e);
                    }
                }
            }
            param = paramBlock.getChildren("tcpaddr");
            while (param.hasMoreElements()) {
                server = ((TextElement)param.nextElement()).getTextValue();
                if (server == null) continue;
                addr = new EndpointAddress("tcp", server, this.serviceName, peerId);
                relayServers.add(addr);
            }
            param = paramBlock.getChildren("httpaddr");
            while (param.hasMoreElements()) {
                server = ((TextElement)param.nextElement()).getTextValue();
                if (server == null) continue;
                addr = new EndpointAddress("http", server, this.serviceName, peerId);
                relayServers.add(addr);
            }
        }
        if (isServer) {
            this.relayServer = new RelayServer(group, this.serviceName, serverMaxClients, serverLease, stallTimeout, clientQueueSize, minBroadcastInterval);
        }
        if (isClient) {
            this.relayClient = new RelayClient(this, this.serviceName, relayServers.toArray(new EndpointAddress[0]), clientMaxServers, messengerPollInterval, clientLease);
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Relay Message Transport : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tisServer : " + isServer);
            configInfo.append("\n\t\t\tserverMaxClients : " + serverMaxClients);
            configInfo.append("\n\t\t\tserverLease : " + serverLease + "ms");
            configInfo.append("\n\t\t\tstallTimeout : " + stallTimeout + "ms");
            configInfo.append("\n\t\t\tminBroadcastInterval : " + minBroadcastInterval + "ms");
            configInfo.append("\n\t\tisClient : " + isClient);
            configInfo.append("\n\t\t\tclientMaxServers : " + clientMaxServers);
            configInfo.append("\n\t\t\tclientLease : " + clientLease + "ms");
            configInfo.append("\n\t\t\tclientQueueSize : " + clientQueueSize);
            configInfo.append("\n\t\t\tmessengerPollInterval : " + messengerPollInterval + "ms");
            Iterator eachRelay = relayServers.iterator();
            if (eachRelay.hasNext()) {
                configInfo.append("\n\t\t\tRelay Servers : ");
            }
            while (eachRelay.hasNext()) {
                configInfo.append("\n\t\t\t\t" + eachRelay.next());
            }
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] args) {
        EndpointService endpoint = this.group.getEndpointService();
        if (endpoint == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"could not get EndpointService");
            }
            return -1;
        }
        endpoint.addIncomingMessageListener(this, this.serviceName, null);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Message Listener added " + this.serviceName));
        }
        if (this.relayServer != null && !this.relayServer.startServer()) {
            return -1;
        }
        if (this.relayClient != null && !this.relayClient.startClient()) {
            return -1;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Relay Message Transport started");
        }
        return 0;
    }

    public void stopApp() {
        EndpointService endpoint = this.group.getEndpointService();
        if (endpoint == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"could not get EndpointService");
            }
        } else {
            endpoint.removeIncomingMessageListener(this.serviceName, null);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Message Listener removed " + this.serviceName));
            }
        }
        if (this.relayServer != null) {
            this.relayServer.stopServer();
        }
        if (this.relayClient != null) {
            this.relayClient.stopClient();
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Relay Message Transport stopped");
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Started for " + message + "\tsrc=" + srcAddr));
        }
        MessageElement element2 = null;
        element2 = message.getMessageElement("relay", REQUEST_ELEMENT);
        if (element2 != null) {
            if (this.relayServer != null) {
                this.relayServer.handleRequest(message, dstAddr);
            }
        } else {
            element2 = message.getMessageElement("relay", RESPONSE_ELEMENT);
            if (element2 != null && this.relayClient != null) {
                this.relayClient.handleResponse(message, dstAddr);
            }
        }
    }

    protected PeerGroup getGroup() {
        return this.group;
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    static Message createPIDRequestMessage() {
        Message message = new Message();
        RelayTransport.setString(message, REQUEST_ELEMENT, "pid");
        return message;
    }

    static Message createPIDResponseMessage(String pidStr) {
        Message message = new Message();
        RelayTransport.setString(message, RESPONSE_ELEMENT, "pid");
        RelayTransport.setString(message, PEERID_ELEMENT, pidStr);
        return message;
    }

    static Message createConnectMessage(long lease, boolean doReturnAdv, boolean doFlushQueue) {
        Message message = new Message();
        String request = RelayTransport.createConnectString(lease, doReturnAdv, doFlushQueue);
        RelayTransport.setString(message, REQUEST_ELEMENT, request);
        return message;
    }

    static String createConnectString(long lease, boolean doReturnAdv, boolean doFlushQueue) {
        String request = CONNECT_REQUEST;
        request = lease > 0L ? request + "," + Long.toString(lease) : request + ",";
        request = doFlushQueue ? request + ",flush" : request + ",keep";
        request = doReturnAdv ? request + ",true" : request + ",other";
        return request;
    }

    static Message createConnectedMessage(long lease) {
        Message message = new Message();
        RelayTransport.setString(message, RESPONSE_ELEMENT, CONNECTED_RESPONSE);
        if (lease > 0L) {
            RelayTransport.setString(message, LEASE_ELEMENT, Long.toString(lease));
        }
        return message;
    }

    static Message createDisconnectMessage() {
        Message message = new Message();
        RelayTransport.setString(message, REQUEST_ELEMENT, DISCONNECT_REQUEST);
        return message;
    }

    static Message createDisconnectedMessage() {
        Message message = new Message();
        RelayTransport.setString(message, RESPONSE_ELEMENT, DISCONNECTED_RESPONSE);
        return message;
    }

    static void setString(Message message, String tag, String value) {
        StringMessageElement sme = new StringMessageElement(tag, value, null);
        message.addMessageElement("relay", sme);
    }

    static String getString(Message message, String tag) {
        MessageElement element2 = message.getMessageElement("relay", tag);
        if (element2 == null) {
            return null;
        }
        return element2.toString();
    }

    protected static RouteAdvertisement getRouteAdvertisement(PeerAdvertisement peerAdv) {
        RouteAdvertisement route = null;
        if (peerAdv == null) {
            return null;
        }
        StructuredDocument epParam = peerAdv.getServiceParam(PeerGroup.endpointClassID);
        if (epParam == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"peer advertisement does not contain a route advertisement");
            }
        } else {
            Enumeration paramChilds = epParam.getChildren(RouteAdvertisement.getAdvertisementType());
            if (paramChilds.hasMoreElements()) {
                Element param = (Element)paramChilds.nextElement();
                route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
            }
        }
        return route;
    }
}

