/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.PlainTextDocument;
import net.jxta.impl.document.TextElementCommon;

public class PlainTextElement
extends TextElementCommon
implements Attributable {
    protected PlainTextDocument doc;
    protected Element parent;
    protected final String name;
    protected final String val;
    private List children = new Vector();
    private Map attributes = new HashMap();

    protected PlainTextElement(PlainTextDocument doc, String name) {
        this(doc, name, null);
    }

    protected PlainTextElement(PlainTextDocument doc, String name, String val) {
        this.doc = doc;
        this.name = name;
        this.val = val;
    }

    public boolean equals(Object element2) {
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof PlainTextElement)) {
            return false;
        }
        PlainTextElement textElement = (PlainTextElement)element2;
        if (this.doc != textElement.doc) {
            return false;
        }
        if (!this.getName().equals(textElement.getName())) {
            return false;
        }
        String val1 = this.getTextValue();
        String val2 = textElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        if (null == val1 || null == val2) {
            return false;
        }
        return val1.equals(val2);
    }

    public StructuredDocument getRoot() {
        return this.doc;
    }

    public Element getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        return Collections.enumeration(this.children);
    }

    public String getName() {
        return this.name;
    }

    public String getTextValue() {
        return this.val;
    }

    public void appendChild(TextElement element2) {
        if (!PlainTextElement.class.isInstance(element2)) {
            throw new IllegalArgumentException("element type not supported.");
        }
        PlainTextElement textElement = (PlainTextElement)element2;
        if (textElement.doc != this.doc) {
            throw new IllegalArgumentException("Wrong Document");
        }
        textElement.parent = this;
        this.children.add(textElement);
    }

    public Enumeration getChildren(String name) {
        ArrayList<TextElement> result = new ArrayList<TextElement>();
        Iterator eachChild = this.children.iterator();
        while (eachChild.hasNext()) {
            TextElement aChild = (TextElement)eachChild.next();
            if (!name.equals(aChild.getName())) continue;
            result.add(aChild);
        }
        return Collections.enumeration(result);
    }

    protected void printNice(Writer into, int indent, boolean recurse) throws IOException {
        for (int eachTab = 0; eachTab < indent; ++eachTab) {
            into.write("\t");
        }
        into.write(this.name);
        Enumeration attributes = this.getAttributes();
        if (attributes.hasMoreElements()) {
            into.write(" ( ");
            while (attributes.hasMoreElements()) {
                Attribute anAttr = (Attribute)attributes.nextElement();
                into.write(anAttr.getName() + "=\"" + anAttr.getValue() + "\" ");
            }
            into.write(")");
        }
        into.write(" : ");
        if (null != this.val) {
            into.write(this.val + "\n");
        } else {
            into.write("\n");
        }
        if (recurse) {
            Enumeration childrens = this.getChildren();
            while (childrens.hasMoreElements()) {
                ((PlainTextElement)childrens.nextElement()).printNice(into, indent + 1, recurse);
            }
        }
    }

    public String addAttribute(String name, String value) {
        String oldAttrValue = (String)this.attributes.remove(name);
        this.attributes.put(name, value);
        return oldAttrValue;
    }

    public String addAttribute(Attribute newAttrib) {
        return this.addAttribute(newAttrib.getName(), newAttrib.getValue());
    }

    public Enumeration getAttributes() {
        Vector<Attribute> attrs = new Vector<Attribute>();
        Iterator eachAttr = this.attributes.entrySet().iterator();
        while (eachAttr.hasNext()) {
            Map.Entry anAttr = eachAttr.next();
            Attribute attr = new Attribute(this, (String)anAttr.getKey(), (String)anAttr.getValue());
            attrs.addElement(attr);
        }
        return attrs.elements();
    }

    public Attribute getAttribute(String name) {
        String value = (String)this.attributes.get(name);
        if (null == value) {
            return null;
        }
        return new Attribute(this, name, value);
    }
}

