/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLDocument;
import net.jxta.impl.document.XMLElementCommon;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LiteXMLElement
extends XMLElementCommon {
    private static final transient Logger LOG;
    protected static final transient boolean paranoidConsistencyChecking = false;
    protected static final transient boolean verboseLogging = false;
    protected transient LiteXMLDocument doc;
    protected transient Element parent;
    protected transient tagRange loc;
    private transient StringBuffer uninserted = null;
    private transient List children = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LiteXMLElement(LiteXMLDocument doc, tagRange loc) {
        this.doc = doc;
        this.loc = loc;
    }

    public LiteXMLElement(LiteXMLDocument doc, String name, String val) {
        this(doc, new tagRange());
        for (int eachChar = name.length() - 1; eachChar >= 0; --eachChar) {
            if (!Character.isWhitespace(name.charAt(eachChar))) continue;
            throw new IllegalArgumentException("Element names may not contain spaces.");
        }
        if (null == val || 0 == val.length()) {
            this.uninserted = new StringBuffer("<" + name + "/>");
        } else {
            this.uninserted = new StringBuffer(val);
            this.encodeEscaped(this.uninserted);
            this.uninserted.insert(0, "<" + name + ">");
            this.uninserted.append("</" + name + ">");
        }
    }

    public boolean equals(Object element2) {
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof LiteXMLElement)) {
            return false;
        }
        LiteXMLElement liteElement = (LiteXMLElement)element2;
        if (this.doc != liteElement.doc) {
            return false;
        }
        if (!this.getName().equals(liteElement.getName())) {
            return false;
        }
        String val1 = null != this.uninserted ? this.uninserted.toString() : this.getTextValue();
        String val2 = liteElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        if (null == val1 || null == val2) {
            return false;
        }
        return val1.equals(val2);
    }

    public String toString() {
        String value;
        String name = this.getName();
        if (name == null) {
            name = "<<null name>>";
        }
        if ((value = this.getTextValue()) == null) {
            value = "<<null value>>";
        }
        if (value.length() + name.length() >= 60) {
            int len = Math.max(20, 60 - name.length());
            value = value.substring(0, Math.min(len, value.length()));
        }
        return super.toString() + " / " + name + " = " + value;
    }

    public StructuredDocument getRoot() {
        return this.doc;
    }

    public Element getParent() {
        return this.parent;
    }

    public Enumeration getChildren() {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        return Collections.enumeration(this.children);
    }

    public String getName() {
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        return this.doc.docContent.substring(this.loc.startTag.start + 1, current);
    }

    public void appendChild(TextElement element2) {
        if (!(element2 instanceof LiteXMLElement)) {
            throw new IllegalArgumentException("Element type not supported.");
        }
        LiteXMLElement newElement = (LiteXMLElement)element2;
        if (newElement.doc != this.doc) {
            throw new IllegalArgumentException("Wrong document");
        }
        if (null != newElement.parent) {
            throw new IllegalArgumentException("New element is already in document");
        }
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null != newElement.uninserted) {
            if (this.loc.startTag.equals(this.loc.endTag)) {
                char inTagName;
                int current;
                this.doc.docContent.deleteCharAt(this.loc.endTag.end - 1);
                --this.loc.startTag.end;
                for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) && '>' != inTagName; ++current) {
                }
                String tagName = this.doc.docContent.substring(this.loc.startTag.start + 1, current);
                this.doc.docContent.insert(this.loc.startTag.end + 1, "</" + tagName + ">");
                this.doc.adjustLocations(this.loc.startTag.end + 1, tagName.length() + 2);
                this.loc.endTag = new charRange(this.loc.startTag.end + 1, this.loc.startTag.end + 3 + tagName.length());
                this.loc.body = new charRange(this.loc.startTag.end + 1, this.loc.startTag.end);
            }
            this.doc.docContent.insert(this.loc.endTag.start, (Object)newElement.uninserted);
            newElement.loc.startTag.start = this.loc.endTag.start;
            newElement.loc.startTag.end = this.doc.docContent.indexOf(">", newElement.loc.startTag.start);
            if ('/' != newElement.uninserted.charAt(newElement.uninserted.length() - 2)) {
                newElement.loc.body.start = newElement.loc.startTag.end + 1;
                newElement.loc.endTag.end = newElement.loc.startTag.start + newElement.uninserted.length() - 1;
                newElement.loc.endTag.start = this.doc.docContent.lastIndexOf("<", newElement.loc.endTag.end);
                newElement.loc.body.end = newElement.loc.endTag.start - 1;
            } else {
                newElement.loc.body = new charRange(newElement.loc.startTag.start, newElement.loc.startTag.end);
                newElement.loc.endTag = new charRange(newElement.loc.startTag.start, newElement.loc.startTag.end);
            }
            if (0 != this.loc.body.length()) {
                this.doc.adjustLocations(this.loc.endTag.start, newElement.uninserted.length());
            } else {
                --this.loc.body.start;
                this.doc.adjustLocations(this.loc.endTag.start, newElement.uninserted.length());
                ++this.loc.body.start;
            }
            this.loc.body.end += newElement.uninserted.length();
            newElement.uninserted = null;
        }
        newElement.parent = this;
        this.children.add(newElement);
    }

    public Enumeration getChildren(String name) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        ArrayList<TextElement> result = new ArrayList<TextElement>();
        Iterator eachChild = this.children.iterator();
        while (eachChild.hasNext()) {
            TextElement aChild = (TextElement)eachChild.next();
            if (!name.equals(aChild.getName())) continue;
            result.add(aChild);
        }
        return Collections.enumeration(result);
    }

    public String getTextValue() {
        return this.getTextValue(false, true);
    }

    protected String getTextValue(boolean getEncoded, boolean trim) {
        int firstNonWhiteSpace;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        StringBuffer building = new StringBuffer();
        ArrayList<charRange> ranges = new ArrayList<charRange>();
        Enumeration eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = (LiteXMLElement)eachChild.nextElement();
            charRange childsRange = new charRange(aChild.loc.startTag.start, aChild.loc.endTag.end);
            for (int eachRange = 0; eachRange < ranges.size(); ++eachRange) {
                charRange rangeChild = (charRange)ranges.get(eachRange);
                if (1 != rangeChild.compareTo(childsRange)) continue;
                ranges.set(eachRange, childsRange);
                childsRange = rangeChild;
            }
            ranges.add(childsRange);
        }
        int current = this.loc.body.start;
        Iterator eachRange = ranges.iterator();
        while (eachRange.hasNext()) {
            charRange aRange = (charRange)eachRange.next();
            building.append(this.doc.docContent.substring(current, aRange.start));
            current = aRange.end + 1;
        }
        building.append(this.doc.docContent.substring(current, this.loc.endTag.start));
        if (!getEncoded) {
            building = this.decodeEscaped(building);
        }
        int lastNonWhiteSpace = building.length() - 1;
        if (trim) {
            char possibleSpace;
            char possibleSpace2;
            for (firstNonWhiteSpace = 0; firstNonWhiteSpace < building.length() && Character.isWhitespace(possibleSpace2 = building.charAt(firstNonWhiteSpace)); ++firstNonWhiteSpace) {
            }
            if (firstNonWhiteSpace >= building.length()) {
                return null;
            }
            while (lastNonWhiteSpace >= firstNonWhiteSpace && Character.isWhitespace(possibleSpace = building.charAt(lastNonWhiteSpace))) {
                --lastNonWhiteSpace;
            }
        }
        String result = building.substring(firstNonWhiteSpace, lastNonWhiteSpace + 1);
        return result;
    }

    protected void printNice(Writer into, int indent, boolean recurse) throws IOException {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        StringBuffer start = new StringBuffer();
        if (-1 != indent) {
            for (int eachTab = 0; eachTab < indent; ++eachTab) {
                start.append('\t');
            }
        }
        start.append(this.doc.docContent.substring(this.loc.startTag.start, this.loc.startTag.end + 1));
        if (-1 != indent) {
            start.append('\n');
        }
        into.write(start.toString());
        if (!this.loc.startTag.equals(this.loc.endTag)) {
            String itsValue = this.getTextValue(true, -1 != indent);
            if (null != itsValue) {
                if (-1 != indent) {
                    for (int eachTab = 0; eachTab < indent + 1; ++eachTab) {
                        into.write("\t");
                    }
                }
                into.write(itsValue);
                if (-1 != indent) {
                    into.write(10);
                }
            }
            if (recurse) {
                int childIndent = indent;
                Enumeration childrens = this.getChildren();
                Attribute space = this.getAttribute("xml:space");
                childIndent = null != space ? ("preserve".equals(space.getValue()) ? -1 : indent + 1) : (-1 != indent ? indent + 1 : -1);
                while (childrens.hasMoreElements()) {
                    ((LiteXMLElement)childrens.nextElement()).printNice(into, childIndent, recurse);
                }
            }
            StringBuffer end = new StringBuffer();
            if (-1 != indent) {
                for (int eachTab = 0; eachTab < indent; ++eachTab) {
                    end.append('\t');
                }
            }
            end.append(this.doc.docContent.substring(this.loc.endTag.start, this.loc.endTag.end + 1));
            if (-1 != indent) {
                end.append('\n');
            }
            into.write(end.toString());
        }
    }

    protected tagRange getTagRanges(StringBuffer source, String tag, charRange range) {
        int foundTagText;
        int foundTagText2;
        boolean emptyTag;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        tagRange result = new tagRange();
        int start = range.start;
        int end = source.length() - 1;
        boolean foundStartTag = false;
        boolean foundEndTag = false;
        boolean bl = emptyTag = null == tag || "".equals(tag);
        if (-1 == start || start >= end) {
            return result;
        }
        if (-1 != range.end && end > range.end) {
            end = range.end;
        }
        if (null == tag) {
            tag = "";
        }
        int current = start;
        if (emptyTag) {
            foundTagText2 = source.indexOf("<", current);
            if (-1 == foundTagText2) {
                return result;
            }
            for (int afterTagText = ++foundTagText2; afterTagText <= end; ++afterTagText) {
                char inTagName = source.charAt(afterTagText);
                if (!Character.isWhitespace(inTagName) && '/' != inTagName && '>' != inTagName) {
                    continue;
                }
                tag = source.substring(foundTagText2, afterTagText);
                boolean bl2 = emptyTag = null == tag || 0 == tag.length();
                break;
            }
            if (emptyTag) {
                return result;
            }
        }
        while (!foundStartTag && current < end) {
            foundTagText2 = source.indexOf(tag, current + 1);
            int afterTagText = foundTagText2 + tag.length();
            if (-1 == foundTagText2 || afterTagText > end) {
                return result;
            }
            char checkChar = source.charAt(afterTagText);
            if ('<' != source.charAt(foundTagText2 - 1) || !Character.isWhitespace(checkChar) && '/' != checkChar && '>' != checkChar) {
                current = afterTagText;
                continue;
            }
            int foundTagTerminator = source.indexOf(">", afterTagText);
            int foundNextTagStart = source.indexOf("<", afterTagText + 1);
            if (-1 == foundTagTerminator || foundTagTerminator > end || -1 != foundNextTagStart && foundNextTagStart < foundTagTerminator) {
                current = afterTagText;
                continue;
            }
            foundStartTag = true;
            result.startTag.start = foundTagText2 - 1;
            result.startTag.end = foundTagTerminator;
        }
        if (!foundStartTag) {
            return result;
        }
        if ('/' == source.charAt(result.startTag.end - 1)) {
            result.body = new charRange(result.startTag.start, result.startTag.end);
            result.endTag = new charRange(result.startTag.start, result.startTag.end);
            return result;
        }
        current = result.startTag.end + 1;
        tagRange subElement = null;
        if (current >= end) {
            return result;
        }
        String endTag = "</" + tag + ">";
        while (!foundEndTag && current < end && -1 != (foundTagText = source.indexOf(endTag, current)) && foundTagText + endTag.length() - 1 <= end) {
            subElement = this.getTagRanges(source, tag, new charRange(current, foundTagText - 1));
            if (subElement.startTag.isValid()) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Found a sub-tag with our name (" + tag + ") at : (" + subElement.startTag.start + "," + subElement.endTag.end + ") in range (" + current + "," + (foundTagText - 1) + ")"));
                }
                current = foundTagText + endTag.length();
                continue;
            }
            foundEndTag = true;
            result.endTag.start = foundTagText;
            result.endTag.end = foundTagText + endTag.length() - 1;
        }
        result.body.start = result.startTag.end + 1;
        result.body.end = foundEndTag ? result.endTag.start - 1 : end;
        return result;
    }

    protected void addChildTags(charRange scanRange, LiteXMLElement addTo) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added to the document.");
        }
        int current = scanRange.start;
        do {
            tagRange aSubtag;
            if ((aSubtag = this.getTagRanges(this.doc.docContent, null, new charRange(current, scanRange.end))).isValid()) {
                LiteXMLElement newChild = (LiteXMLElement)this.doc.createElement(aSubtag);
                addTo.appendChild(newChild);
                if (!aSubtag.startTag.equals(aSubtag.endTag)) {
                    this.addChildTags(aSubtag.body, newChild);
                }
                current = aSubtag.endTag.end + 1;
                continue;
            }
            current = -1;
        } while (-1 != current && current < scanRange.end);
    }

    protected void adjustLocations(int beginningAt, int by) {
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (this.loc.endTag.end < beginningAt && this.loc.endTag.start < beginningAt) {
            return;
        }
        if (this.loc.startTag.end >= beginningAt || this.loc.startTag.start >= beginningAt && this.loc.startTag.end + 1 == this.loc.startTag.start) {
            this.loc.startTag.end += by;
        }
        if (this.loc.startTag.start >= beginningAt) {
            this.loc.startTag.start += by;
        }
        if (this.loc.body.end >= beginningAt || this.loc.body.start >= beginningAt && this.loc.body.end + 1 == this.loc.body.start) {
            this.loc.body.end += by;
        }
        if (this.loc.body.start >= beginningAt) {
            this.loc.body.start += by;
        }
        if (this.loc.endTag.end >= beginningAt || this.loc.endTag.start >= beginningAt && this.loc.endTag.end + 1 == this.loc.endTag.start) {
            this.loc.endTag.end += by;
        }
        if (this.loc.endTag.start >= beginningAt) {
            this.loc.endTag.start += by;
        }
        Enumeration eachChild = this.getChildren();
        while (eachChild.hasMoreElements()) {
            LiteXMLElement aChild = (LiteXMLElement)eachChild.nextElement();
            aChild.adjustLocations(beginningAt, by);
        }
    }

    protected StringBuffer decodeEscaped(StringBuffer target) {
        int current = 0;
        StringBuffer result = new StringBuffer(target.length());
        while (current < target.length()) {
            int terminusAt;
            if ('\r' == target.charAt(current)) {
                result.append('\n');
                if (++current >= target.length() || '\n' != target.charAt(current)) continue;
                ++current;
                continue;
            }
            if ('&' != target.charAt(current)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            for (terminusAt = current + 1; terminusAt < target.length() && terminusAt - current < 6 && ';' != target.charAt(terminusAt); ++terminusAt) {
            }
            if (terminusAt >= target.length() || ';' != target.charAt(terminusAt)) {
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            char[] sub = new char[terminusAt - current + 1];
            target.getChars(current, terminusAt + 1, sub, 0);
            String escaped = new String(sub);
            if ("&amp;".equals(escaped)) {
                result.append('&');
                current += 4;
            } else if ("&lt;".equals(escaped)) {
                result.append('<');
                current += 3;
            } else if ("&gt;".equals(escaped)) {
                result.append('>');
                current += 3;
            } else {
                if (escaped.startsWith("&#")) {
                    String numericChar = escaped.substring(2, escaped.length() - 1);
                    if (numericChar.length() < 1) {
                        result.append(target.charAt(current));
                        ++current;
                        continue;
                    }
                    if (numericChar.charAt(0) == 'x') {
                        if ((numericChar = numericChar.substring(1)).length() < 1) {
                            result.append(target.charAt(current));
                            ++current;
                            continue;
                        }
                        try {
                            char asChar = (char)Integer.parseInt(numericChar.toLowerCase(), 16);
                            result.append(asChar);
                            current += escaped.length();
                        }
                        catch (NumberFormatException badref) {
                            result.append(target.charAt(current));
                            ++current;
                        }
                        continue;
                    }
                    try {
                        char asChar = (char)Integer.parseInt(numericChar, 10);
                        result.append(asChar);
                        current += escaped.length();
                    }
                    catch (NumberFormatException badref) {
                        result.append(target.charAt(current));
                        ++current;
                    }
                    continue;
                }
                result.append(target.charAt(current));
                ++current;
                continue;
            }
            ++current;
        }
        return result;
    }

    protected void encodeEscaped(StringBuffer target) {
        int current = 0;
        while (current < target.length()) {
            if ('&' == target.charAt(current)) {
                target.insert(current + 1, "amp;");
                current += 5;
                continue;
            }
            if ('<' == target.charAt(current)) {
                target.setCharAt(current, '&');
                target.insert(current + 1, "lt;");
                current += 4;
                continue;
            }
            ++current;
        }
    }

    public Enumeration getAttributes() {
        tagRange nextAttr;
        char inTagName;
        int current;
        ArrayList<Attribute> results = new ArrayList<Attribute>();
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        while (current < this.loc.startTag.end && (nextAttr = this.getAttributeLoc(null, new charRange(current, this.loc.startTag.end))).isValid()) {
            results.add(new Attribute(this, this.doc.docContent.substring(nextAttr.startTag.start, nextAttr.startTag.end + 1), this.doc.docContent.substring(nextAttr.body.start, nextAttr.body.end + 1)));
            current = nextAttr.endTag.end + 1;
        }
        return Collections.enumeration(results);
    }

    protected tagRange getAttributeLoc(String name, charRange inRange) {
        tagRange result = new tagRange();
        int current = inRange.start;
        while (true) {
            char inTagName;
            if (current <= inRange.end && (Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) || '/' == inTagName || '>' == inTagName)) {
                ++current;
                continue;
            }
            int equalsAt = this.doc.docContent.indexOf("=", current);
            if (-1 == equalsAt || equalsAt >= inRange.end) {
                return result;
            }
            result.startTag.start = current;
            result.startTag.end = equalsAt - 1;
            String requiredQuote = this.doc.docContent.substring(equalsAt + 1, equalsAt + 2);
            if ('\'' != requiredQuote.charAt(0) && '\"' != requiredQuote.charAt(0)) {
                return result;
            }
            int nextQuote = this.doc.docContent.indexOf(requiredQuote, equalsAt + 2);
            if (-1 == nextQuote || nextQuote >= inRange.end) {
                return result;
            }
            result.body.start = equalsAt + 2;
            result.body.end = nextQuote - 1;
            result.endTag.start = nextQuote;
            result.endTag.end = nextQuote;
            if (null != name && !name.equals(this.doc.docContent.substring(result.startTag.start, result.startTag.end + 1))) {
                result.startTag.start = -1;
            }
            if ((current = nextQuote + 1) >= inRange.end || result.isValid()) break;
        }
        return result;
    }

    public String addAttribute(String name, String value) {
        char usingQuote;
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        if (null == name) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (null == value) {
            throw new IllegalArgumentException("value must not be null");
        }
        for (int eachChar = name.length() - 1; eachChar >= 0; --eachChar) {
            if (!Character.isWhitespace(name.charAt(eachChar))) continue;
            throw new IllegalArgumentException("Attribute names may not contain spaces.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        String oldValue = null;
        tagRange oldAttr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        char c = usingQuote = -1 != value.indexOf(34) ? (char)'\'' : '\"';
        if ('\'' == usingQuote && -1 != value.indexOf(39)) {
            throw new IllegalArgumentException("Value contains both \" and '");
        }
        StringBuffer newStuff = new StringBuffer(" ");
        newStuff.append(name);
        newStuff.append("=");
        newStuff.append(usingQuote);
        newStuff.append(value);
        newStuff.append(usingQuote);
        if (!oldAttr.isValid()) {
            this.doc.docContent.insert(current, newStuff.toString());
            this.doc.adjustLocations(current, newStuff.length());
        } else {
            oldValue = this.doc.docContent.substring(oldAttr.body.start, oldAttr.body.end + 1);
            this.doc.docContent.delete(oldAttr.body.start, oldAttr.body.end + 1);
            this.doc.docContent.insert(oldAttr.body.start, value);
            int delta = value.length() - (oldAttr.body.end - oldAttr.body.start + 1);
            this.doc.adjustLocations(this.loc.startTag.start + 1, delta);
        }
        return oldValue;
    }

    public String addAttribute(Attribute newAttrib) {
        return this.addAttribute(newAttrib.getName(), newAttrib.getValue());
    }

    public Attribute getAttribute(String name) {
        char inTagName;
        int current;
        if (null != this.uninserted) {
            throw new IllegalStateException("This element has not been added.");
        }
        for (current = this.loc.startTag.start + 1; current <= this.loc.startTag.end && !Character.isWhitespace(inTagName = this.doc.docContent.charAt(current)) && '/' != inTagName && '>' != inTagName; ++current) {
        }
        tagRange attr = this.getAttributeLoc(name, new charRange(current, this.loc.startTag.end));
        if (!attr.isValid()) {
            return null;
        }
        return new Attribute(this, this.doc.docContent.substring(attr.startTag.start, attr.startTag.end + 1), this.doc.docContent.substring(attr.body.start, attr.body.end + 1));
    }

    protected boolean checkConsistency() {
        if (!$assertionsDisabled && !this.loc.isValid()) {
            throw new AssertionError();
        }
        charRange elementRange = new charRange(this.loc.startTag.start, this.loc.endTag.end);
        if (!$assertionsDisabled && !elementRange.contains(this.loc.startTag)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !elementRange.contains(this.loc.body)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !elementRange.contains(this.loc.endTag)) {
            throw new AssertionError();
        }
        Iterator eachChild = this.children.iterator();
        while (eachChild.hasNext()) {
            LiteXMLElement aChild = (LiteXMLElement)eachChild.next();
            if (!$assertionsDisabled && !this.loc.contains(aChild.loc)) {
                throw new AssertionError();
            }
            aChild.checkConsistency();
        }
        return true;
    }

    static {
        $assertionsDisabled = !LiteXMLElement.class.desiredAssertionStatus();
        LOG = Logger.getLogger((String)LiteXMLElement.class.getName());
    }

    protected static class tagRange
    implements Comparable {
        public charRange startTag = null;
        public charRange body = null;
        public charRange endTag = null;

        public tagRange() {
            this.startTag = new charRange();
            this.body = new charRange();
            this.endTag = new charRange();
        }

        public tagRange(charRange startTag, charRange body, charRange endTag) {
            this.startTag = startTag;
            this.body = body;
            this.endTag = endTag;
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof tagRange)) {
                return false;
            }
            tagRange likeMe = (tagRange)aRange;
            return this.startTag.equals(likeMe.startTag) && this.body.equals(likeMe.body) && this.endTag.equals(likeMe.endTag);
        }

        public int compareTo(Object aRange) {
            if (this == aRange) {
                return 0;
            }
            if (!(aRange instanceof tagRange)) {
                throw new ClassCastException("type mismatch error");
            }
            tagRange someRange = (tagRange)aRange;
            int compared = this.startTag.compareTo(someRange.startTag);
            if (0 != compared) {
                return compared;
            }
            return this.endTag.compareTo(someRange.endTag);
        }

        public String toString() {
            return this.startTag + ":" + this.body + ":" + this.endTag;
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.startTag.start && this.body.end >= someRange.endTag.end;
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.body.start <= someRange.start && this.body.end >= someRange.end;
        }

        public boolean isEmptyElement() {
            return this.isValid() && this.startTag.equals(this.body) && this.startTag.equals(this.endTag);
        }

        public boolean isValid() {
            return null != this.startTag && null != this.body && null != this.endTag && this.startTag.isValid() && this.body.isValid() && this.endTag.isValid();
        }
    }

    protected static class charRange
    implements Comparable {
        public int start;
        public int end;

        public charRange() {
            this.start = -1;
            this.end = -1;
        }

        public charRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object aRange) {
            if (this == aRange) {
                return true;
            }
            if (!(aRange instanceof charRange)) {
                return false;
            }
            charRange someRange = (charRange)aRange;
            return this.start == someRange.start && this.end == someRange.end;
        }

        public int compareTo(Object aRange) {
            if (this == aRange) {
                return 0;
            }
            if (!(aRange instanceof charRange)) {
                throw new ClassCastException("type mismatch error");
            }
            charRange someRange = (charRange)aRange;
            if (this.start < someRange.start) {
                return -1;
            }
            if (this.start > someRange.start) {
                return 1;
            }
            if (this.end < someRange.end) {
                return -1;
            }
            if (this.end > someRange.end) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }

        public boolean contains(charRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.start && this.end >= someRange.end;
        }

        public boolean contains(tagRange someRange) {
            return this.isValid() && someRange.isValid() && this.start <= someRange.startTag.start && this.end >= someRange.endTag.end;
        }

        public boolean contains(int someLoc) {
            return this.isValid() && someLoc >= 0 && this.start <= someLoc && this.end >= someLoc;
        }

        public boolean isValid() {
            return this.length() >= 0;
        }

        public int length() {
            if (-1 == this.start || -1 == this.end) {
                return -1;
            }
            return this.end - this.start + 1;
        }
    }
}

