/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import net.jxta.document.Attribute;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.DOMXMLDocument;
import net.jxta.impl.document.XMLElementCommon;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMXMLElement
extends XMLElementCommon {
    protected DOMXMLDocument root;
    protected Node domNode;

    protected DOMXMLElement(DOMXMLDocument root, Node node) {
        this.root = root;
        this.domNode = node;
    }

    public String getName() {
        return this.getAssocNode().getNodeName();
    }

    public String getTextValue() {
        String itsValue = "";
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (3 != eachChild.getNodeType()) continue;
            itsValue = itsValue + eachChild.getNodeValue();
        }
        if ("".equals(itsValue)) {
            return null;
        }
        return itsValue;
    }

    public StructuredDocument getRoot() {
        return this.root;
    }

    public net.jxta.document.Element getParent() {
        Node node = this.getAssocNode();
        if (node.getOwnerDocument().equals(node)) {
            return new DOMXMLElement(this.root, node);
        }
        return new DOMXMLElement(this.root, node.getParentNode());
    }

    public void appendChild(TextElement element2) {
        if (!(element2 instanceof DOMXMLElement)) {
            throw new IllegalArgumentException("element type not supported.");
        }
        this.getAssocNode().appendChild(((DOMXMLElement)element2).getAssocNode());
    }

    public Enumeration getChildren() {
        ArrayList<DOMXMLElement> children = new ArrayList<DOMXMLElement>();
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (1 != eachChild.getNodeType()) continue;
            children.add(new DOMXMLElement(this.root, eachChild));
        }
        return Collections.enumeration(children);
    }

    public Enumeration getChildren(String name) {
        ArrayList<DOMXMLElement> children = new ArrayList<DOMXMLElement>();
        for (Node eachChild = this.getAssocNode().getFirstChild(); eachChild != null; eachChild = eachChild.getNextSibling()) {
            if (1 != eachChild.getNodeType() || !name.equals(eachChild.getNodeName())) continue;
            children.add(new DOMXMLElement(this.root, eachChild));
        }
        return Collections.enumeration(children);
    }

    public boolean equals(Object element2) {
        Node it;
        if (this == element2) {
            return true;
        }
        if (!(element2 instanceof DOMXMLElement)) {
            return false;
        }
        DOMXMLElement xmlElement = (DOMXMLElement)element2;
        Node me = this.getAssocNode();
        if (me == (it = xmlElement.getAssocNode())) {
            return true;
        }
        if (me.getOwnerDocument() != it.getOwnerDocument()) {
            return false;
        }
        if (!this.getName().equals(xmlElement.getName())) {
            return false;
        }
        String val1 = this.getTextValue();
        String val2 = xmlElement.getTextValue();
        if (null == val1 && null == val2) {
            return true;
        }
        if (null == val1 || null == val2) {
            return false;
        }
        return val1.equals(val2);
    }

    protected Node getAssocNode() {
        return this.domNode;
    }

    public String addAttribute(String name, String value) {
        String oldAttrValue = ((Element)this.getAssocNode()).getAttribute(name);
        ((Element)this.getAssocNode()).setAttribute(name, value);
        return 0 == oldAttrValue.length() ? null : oldAttrValue;
    }

    public String addAttribute(Attribute newAttrib) {
        String oldAttrValue = ((Element)this.getAssocNode()).getAttribute(newAttrib.getName());
        ((Element)this.getAssocNode()).setAttribute(newAttrib.getName(), newAttrib.getValue());
        return 0 == oldAttrValue.length() ? null : oldAttrValue;
    }

    public Enumeration getAttributes() {
        NamedNodeMap nmap = ((Element)this.getAssocNode()).getAttributes();
        if (nmap == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node domAttr = nmap.item(i);
            Attribute attr = new Attribute(this, domAttr.getNodeName(), domAttr.getNodeValue());
            attrs.add(attr);
        }
        return Collections.enumeration(attrs);
    }

    public Attribute getAttribute(String name) {
        NamedNodeMap nmap = ((Element)this.getAssocNode()).getAttributes();
        if (nmap == null) {
            return null;
        }
        for (int i = 0; i < nmap.getLength(); ++i) {
            Node domAttr = nmap.item(i);
            if (!name.equals(domAttr.getNodeName())) continue;
            Attribute attr = new Attribute(this, domAttr.getNodeName(), domAttr.getNodeValue());
            return attr;
        }
        return null;
    }
}

