/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.discovery.DiscoveryServiceInterface;
import net.jxta.impl.peergroup.StdPeerGroup;
import net.jxta.impl.protocol.DiscoveryConfigAdv;
import net.jxta.impl.protocol.DiscoveryQuery;
import net.jxta.impl.protocol.DiscoveryResponse;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryServiceImpl
implements DiscoveryService,
QueryHandler,
RendezvousListener,
SrdiHandler,
Srdi.SrdiInterface {
    private static final Logger LOG = Logger.getLogger((String)DiscoveryServiceImpl.class.getName());
    private static int qid = 0;
    protected Cm cm;
    protected static final String[] dirname = new String[]{"Peers", "Groups", "Adv"};
    private final int MAX_RESPONSES = 50;
    private PeerGroup group = null;
    private String handlerName = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private ResolverService resolver;
    private RendezVousService rendezvous;
    private MembershipService membership = null;
    private String localPeerId = null;
    private boolean started = false;
    private Set listeners = new HashSet();
    private Hashtable listenerTable = new Hashtable();
    private Object checkPeerAdvLock = new String("Check/Update PeerAdvertisement Lock");
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private boolean isRdv = false;
    private boolean alwaysUseReplicaPeer = false;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private SrdiIndex srdiIndex = null;
    private Srdi srdi = null;
    private Thread srdiThread = null;
    private boolean localonly = false;
    private long initialDelay = 60000L;
    private long runInterval = 30000L;
    private static final String srdiIndexerFileName = "discoverySrdi";
    private DiscoveryService discoveryInterface = null;

    public synchronized Service getInterface() {
        if (this.discoveryInterface == null) {
            this.discoveryInterface = new DiscoveryServiceInterface(this);
        }
        return this.discoveryInterface;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold) {
        return this.getRemoteAdvertisements(peer, type, attribute, value, threshold, null);
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold, DiscoveryListener listener) {
        int myQueryID = DiscoveryServiceImpl.nextQid();
        if (this.localonly) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"localonly, no network operations performed");
            }
            return myQueryID;
        }
        if (this.resolver == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"resolver has not started yet, query discarded.");
            }
            return myQueryID;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer query = new StringBuffer("Sending query#" + myQueryID + " for " + threshold + " " + dirname[type] + " advs");
            if (attribute != null) {
                query.append("\n\tattr = " + attribute);
                if (value != null) {
                    query.append("\tvalue = " + value);
                }
            }
            LOG.debug((Object)query);
        }
        long t0 = System.currentTimeMillis();
        DiscoveryQuery dquery = new DiscoveryQuery();
        dquery.setDiscoveryType(type);
        dquery.setAttr(attribute);
        dquery.setValue(value);
        dquery.setThreshold(threshold);
        if (listener != null) {
            this.listenerTable.put(new Integer(myQueryID), listener);
        }
        ResolverQuery query = new ResolverQuery(this.handlerName, this.credentialDoc, this.localPeerId, ((Object)dquery).toString(), myQueryID);
        if (peer == null && this.srdiIndex != null) {
            PeerID destPeer;
            Vector res = this.srdiIndex.query(dirname[type], attribute, value, threshold);
            if (res.size() > 0) {
                this.srdi.forwardQuery(res, query, threshold);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Srdi forward a query #" + myQueryID + " in " + (System.currentTimeMillis() - t0) + "ms."));
                }
                return myQueryID;
            }
            if (this.group.isRendezvous() && attribute != null && value != null && (destPeer = this.srdi.getReplicaPeer(dirname[type] + attribute + value)) != null && !destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, (ResolverQueryMsg)query);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Srdi forward query #" + myQueryID + " to " + destPeer + " in " + (System.currentTimeMillis() - t0) + "ms."));
                }
                return myQueryID;
            }
        }
        this.resolver.sendQuery(peer, query);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            if (peer == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sent a query #" + myQueryID + " in " + (System.currentTimeMillis() - t0) + "ms."));
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sent a query #" + myQueryID + " to " + peer + " in " + (System.currentTimeMillis() - t0) + "ms."));
            }
        }
        return myQueryID;
    }

    public Enumeration getLocalAdvertisements(int type, String attribute, String value) throws IOException {
        if (type > 2 || type < 0) {
            throw new IllegalArgumentException("Unknown Advertisement type");
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer query = new StringBuffer("Searching for " + dirname[type] + " advs");
            if (attribute != null) {
                query.append("\n\tattr = " + attribute);
            }
            if (value != null) {
                query.append("\tvalue = " + value);
            }
            LOG.debug((Object)query);
        }
        return this.search(type, attribute, value, Integer.MAX_VALUE, false, null).elements();
    }

    public void init(PeerGroup pg, ID assignedID, Advertisement impl) throws PeerGroupException {
        block14: {
            this.group = pg;
            this.handlerName = assignedID.toString();
            this.implAdvertisement = (ModuleImplAdvertisement)impl;
            this.localPeerId = this.group.getPeerID().toString();
            try {
                ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
                String offStr = jxtaRsrcs.getString("impl.discovery.localonly");
                if (offStr != null) {
                    this.localonly = offStr.equalsIgnoreCase("true");
                    if (LOG.isEnabledFor((Priority)Level.WARN) && this.localonly) {
                        LOG.warn((Object)"configuration via properties is being phased out. Consider using parameters in the group advertisement or PlatformConfig advertisement instead.");
                    }
                }
            }
            catch (MissingResourceException re) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block14;
                LOG.debug((Object)"localonly not defined, initializing to false");
            }
        }
        ConfigParams confAdv = pg.getConfigAdvertisement();
        if (confAdv != null) {
            Advertisement adv = null;
            try {
                XMLDocument configDoc = (XMLDocument)confAdv.getServiceParam(assignedID);
                if (null != configDoc) {
                    adv = AdvertisementFactory.newAdvertisement(configDoc);
                }
            }
            catch (NoSuchElementException failed) {
                // empty catch block
            }
            if (adv instanceof DiscoveryConfigAdv) {
                DiscoveryConfigAdv discoConfigAdv = (DiscoveryConfigAdv)adv;
                this.alwaysUseReplicaPeer = discoConfigAdv.getForwardAlwaysReplica();
                this.localonly |= discoConfigAdv.getLocalOnly();
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    if (this.localonly) {
                        LOG.debug((Object)"localonly set to true via service parameters");
                    }
                    if (this.alwaysUseReplicaPeer) {
                        LOG.debug((Object)"alwaysUseReplicaPeer set to true via service parameters");
                    }
                }
            }
        }
        this.cm = ((StdPeerGroup)this.group).getCacheManager();
        this.cm.setTrackDeltas(!this.localonly);
        this.checkUpdatePeerAdv();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Discovery Service : " + assignedID);
            if (this.implAdvertisement != null) {
                configInfo.append("\n\tImplementation :");
                configInfo.append("\n\t\tModule Spec ID: " + this.implAdvertisement.getModuleSpecID());
                configInfo.append("\n\t\tImpl Description : " + this.implAdvertisement.getDescription());
                configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
                configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            }
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + this.group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + this.group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + this.group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tLocal Only : " + this.localonly);
            configInfo.append("\n\t\tAlways Use ReplicaPeer : " + this.alwaysUseReplicaPeer);
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] arg) {
        block13: {
            this.resolver = this.group.getResolverService();
            if (null == this.resolver) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Stalled until there is a resolver service");
                }
                return 2;
            }
            this.membership = this.group.getMembershipService();
            if (null == this.membership) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Stalled until there is a membership service");
                }
                return 2;
            }
            this.rendezvous = this.group.getRendezVousService();
            if (null == this.rendezvous) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Stalled until there is a rendezvous service");
                }
                return 2;
            }
            if (!this.localonly) {
                this.resolver.registerHandler(this.handlerName, this);
            }
            try {
                this.credential = this.membership.getDefaultCredential();
                if (null != this.credential) {
                    this.credentialDoc = this.credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
        if (this.rendezvous.isRendezVous()) {
            this.beRendezvous();
        } else {
            this.beEdge();
        }
        this.rendezvous.addListener(this);
        this.started = true;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Discovery service started");
        }
        return 0;
    }

    public void stopApp() {
        boolean failed = false;
        this.rendezvous.removeListener(this);
        if (this.resolver.unregisterHandler(this.handlerName) == null) {
            failed = true;
        }
        if (this.rendezvous.isRendezVous() && this.resolver.unregisterSrdiHandler(this.handlerName) == null) {
            failed = true;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG) && failed) {
            LOG.debug((Object)"failed to unregister discovery from resolver.");
        }
        if (this.srdiThread != null) {
            this.srdi.stop();
            this.srdi = null;
        }
        this.resolver = null;
        this.group = null;
        this.membership = null;
        this.srdiIndex = null;
        this.srdiThread = null;
        this.rendezvous = null;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Discovery service stopped");
        }
    }

    public void flushAdvertisements(String id, int type) throws IOException {
        if (type <= 2 && id != null) {
            ID advID = IDFactory.fromURL(IDFactory.jxtaURL(id));
            String advName = advID.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("flushing adv " + advName + " of type " + dirname[type]));
            }
            this.cm.remove(dirname[type], advName);
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("flushing advertisements of type " + dirname[type]));
            }
            this.cm.remove(dirname[type], null);
        }
    }

    public void flushAdvertisement(Advertisement adv) throws IOException {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Flushing adv " + advName + " of type " + dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                IOException failure = new IOException("Failure removing Advertisement");
                failure.initCause(everything);
                throw failure;
            }
            advName = Cm.createTmpName(doc);
        }
        if (advName != null) {
            this.cm.remove(dirname[type], advName);
        }
    }

    public void publish(Advertisement adv, int type) throws IOException {
        this.publish(adv, type, 31536000000L, 0x6DDD00L);
    }

    public void publish(Advertisement adv) throws IOException {
        this.publish(adv, 31536000000L, 0x6DDD00L);
    }

    public void publish(Advertisement adv, long lifetime, long expiration) throws IOException {
        int type = -1;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        this.publish(adv, type, lifetime, expiration);
    }

    public void publish(Advertisement adv, int type, long lifetime, long expiration) throws IOException {
        ID advID = null;
        String advName = null;
        switch (type) {
            case 0: {
                if (adv instanceof PeerAdvertisement) break;
                throw new IOException("Not a peer advertisement");
            }
            case 1: {
                if (adv instanceof PeerGroupAdvertisement) break;
                throw new IOException("Not a peergroup advertisement");
            }
            case 2: {
                break;
            }
            default: {
                throw new IOException("Unknown advertisement type");
            }
        }
        advID = adv.getID();
        if (null == advID || advID.equals(ID.nullID)) {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to generated document from advertisement", (Throwable)everything);
                }
                IOException failure = new IOException("Failed to generate document from advertisement");
                failure.initCause(everything);
                throw failure;
            }
            advName = Cm.createTmpName(doc);
        } else {
            advName = advID.getUniqueValue().toString();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Publishing a " + adv.getAdvType() + " as " + dirname[type] + " / " + advName + "\n\texpiration : " + expiration + "\tlifetime :" + lifetime));
        }
        this.cm.save(dirname[type], advName, adv, lifetime, expiration);
    }

    public void remotePublish(Advertisement adv, int type) {
        this.remotePublish(null, adv, type, 0x6DDD00L);
    }

    public void remotePublish(Advertisement adv) {
        this.remotePublish(null, adv, 0x6DDD00L);
    }

    public void remotePublish(Advertisement adv, int type, long timeout) {
        this.remotePublish(null, adv, type, timeout);
    }

    public void remotePublish(Advertisement adv, long timeout) {
        this.remotePublish(null, adv, timeout);
    }

    public void remotePublish(String peerid, Advertisement adv, int type) {
        this.remotePublish(peerid, adv, type, 0x6DDD00L);
    }

    public void remotePublish(String peerid, Advertisement adv) {
        this.remotePublish(peerid, adv, 0x6DDD00L);
    }

    public void remotePublish(String peerid, Advertisement adv, long timeout) {
        if (this.localonly) {
            return;
        }
        int type = -1;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        this.remotePublish(peerid, adv, type, timeout);
    }

    public void processResponse(ResolverResponseMsg response) {
        DiscoveryResponse res;
        long t0 = System.currentTimeMillis();
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(response.getResponse()));
            res = new DiscoveryResponse(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed to Read Deiscovery Response", (Throwable)e);
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Processing responses for query #" + response.getQueryId()));
        }
        Enumeration en = res.getAdvertisements();
        Enumeration exps = res.getExpirations();
        if (en != null) {
            while (en.hasMoreElements()) {
                Advertisement adv = (Advertisement)en.nextElement();
                long exp = (Long)exps.nextElement();
                if (exp <= 0L || adv == null) continue;
                try {
                    this.publish(adv, exp, exp);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Error publishing Advertisement", (Throwable)e);
                }
            }
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Received empty responses");
        }
        DiscoveryEvent newevent = new DiscoveryEvent(this.getInterface(), res, response.getQueryId());
        DiscoveryListener dl = (DiscoveryListener)this.listenerTable.get(new Integer(response.getQueryId()));
        if (dl != null) {
            try {
                dl.discoveryEvent(new DiscoveryEvent(this.getInterface(), res, response.getQueryId()));
            }
            catch (Throwable all) {
                LOG.fatal((Object)("Uncaught Throwable in listener :" + Thread.currentThread().getName()), all);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("processed a response for query #" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
        }
        t0 = System.currentTimeMillis();
        DiscoveryListener[] allListeners = this.listeners.toArray(new DiscoveryListener[0]);
        for (int eachListener = 0; eachListener < allListeners.length; ++eachListener) {
            try {
                allListeners[eachListener].discoveryEvent(newevent);
                continue;
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Uncaught Throwable in listener (" + allListeners[eachListener].getClass().getName() + ") :" + Thread.currentThread().getName()), all);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Called all listenters to query #" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
        }
    }

    public int processQuery(ResolverQueryMsg query) {
        PeerID destPeer;
        Vector res;
        DiscoveryQuery dq;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Processing query #" + query.getQueryId()));
        }
        Vector results = null;
        Vector<Long> expirations = new Vector<Long>();
        long t0 = System.currentTimeMillis();
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(query.getQuery()));
            dq = new DiscoveryQuery(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Malformed query : ", (Throwable)e);
            }
            return 0;
        }
        if (dq.getThreshold() < 0 || dq.getDiscoveryType() < 0 || dq.getDiscoveryType() > 2) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Malformed query");
            }
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Got a " + dirname[dq.getDiscoveryType()] + " query #" + query.getQueryId() + " query :" + dq.getAttr() + " = " + dq.getValue()));
        }
        int thresh = Math.min(dq.getThreshold(), 50);
        if (dq.getDiscoveryType() == 0 && 0 == dq.getThreshold()) {
            results = new Vector();
            results.add(this.group.getPeerAdvertisement().toString());
            expirations.add(new Long(0x6DDD00L));
            this.respond(query, dq, results, expirations);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responding to query #" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
            }
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("start local search query" + dq.getAttr() + " " + dq.getValue()));
        }
        results = this.search(dq.getDiscoveryType(), dq.getAttr(), dq.getValue(), thresh, true, expirations);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("start local search pruned " + results.size()));
        }
        if (!results.isEmpty()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responding to " + dirname[dq.getDiscoveryType()] + " Query : " + dq.getAttr() + " = " + dq.getValue()));
            }
            this.respond(query, dq, results, expirations);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responded to query #" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
            }
            return 0;
        }
        if (!this.group.isRendezvous()) {
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Querying SrdiIndex query #" + query.getQueryId()));
        }
        if ((res = this.srdiIndex.query(dirname[dq.getDiscoveryType()], dq.getAttr(), dq.getValue(), thresh)).size() > 0) {
            this.srdi.forwardQuery(res, query, thresh);
            return 0;
        }
        if (query.getHopCount() == 0 && (destPeer = this.srdi.getReplicaPeer(dirname[dq.getDiscoveryType()] + dq.getAttr() + dq.getValue())) != null) {
            if (!destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, query);
                return 0;
            }
            query.incrementHopCount();
        }
        return -1;
    }

    private void respond(ResolverQueryMsg query, DiscoveryQuery dq, Vector results, Vector expirations) {
        if (this.localonly) {
            return;
        }
        DiscoveryResponse dresponse = new DiscoveryResponse();
        dresponse.setDiscoveryType(dq.getDiscoveryType());
        dresponse.setQueryAttr(dq.getAttr());
        dresponse.setQueryValue(dq.getValue());
        dresponse.setResponses(results);
        dresponse.setExpirations(expirations);
        ResolverResponseMsg response = query.makeResponse();
        response.setCredential(this.credentialDoc);
        response.setResponse(dresponse.toString());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Responding to " + query.getSrc()));
        }
        this.resolver.sendResponse(query.getSrc(), response);
    }

    public synchronized void addDiscoveryListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized boolean removeDiscoveryListener(DiscoveryListener listener) {
        Iterator e = this.listenerTable.keySet().iterator();
        while (e.hasNext()) {
            Object key = e.next();
            if (this.listenerTable.get(key) != listener) continue;
            e.remove();
        }
        return this.listeners.remove(listener);
    }

    public void remotePublish(String peerid, Advertisement adv, int type, long timeout) {
        if (this.localonly) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"localonly, no network operations performed");
            }
            return;
        }
        if (this.resolver == null) {
            return;
        }
        Vector<String> advert = new Vector<String>(1);
        Vector<Long> expirations = new Vector<Long>(1);
        advert.add(adv.toString());
        expirations.add(new Long(timeout));
        DiscoveryResponse dresponse = new DiscoveryResponse();
        dresponse.setDiscoveryType(type);
        dresponse.setResponses(advert);
        dresponse.setExpirations(expirations);
        ResolverResponse pushRes = new ResolverResponse(this.handlerName, this.credentialDoc, 0, dresponse.toString());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Remote publishing ");
        }
        this.resolver.sendResponse(peerid, pushRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Vector search(int type, String attr, String value, int threshold, boolean bytes, Vector expirations) {
        Vector results;
        if (type == 0) {
            this.checkUpdatePeerAdv();
        }
        if (threshold <= 0) {
            throw new IllegalArgumentException("threshold must be greater than zero");
        }
        if (expirations != null) {
            expirations.clear();
        }
        if (attr != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Searching for " + threshold + " entries of type : " + dirname[type]));
            }
            results = this.cm.search(dirname[type], attr, value, threshold, expirations);
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Getting " + threshold + " entries of type : " + dirname[type]));
            }
            results = this.cm.getRecords(dirname[type], threshold, null, expirations);
        }
        if (results.size() == 0 || bytes) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Returning " + results.size() + " results"));
            }
            return results;
        }
        Vector<Advertisement> advertisements = new Vector<Advertisement>();
        for (int i = 0; i < results.size(); ++i) {
            IOException ignored2222;
            Object var13_13;
            InputStream bis;
            block22: {
                bis = null;
                bis = (InputStream)results.elementAt(i);
                Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, bis);
                advertisements.addElement(adv);
                var13_13 = null;
                if (null == bis) break block22;
                try {
                    bis.close();
                }
                catch (IOException ignored2222) {
                    // empty catch block
                }
            }
            bis = null;
            {
                continue;
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Failed building advertisment", (Throwable)e);
                    }
                    var13_13 = null;
                    if (null != bis) {
                        try {
                            bis.close();
                        }
                        catch (IOException ignored2222) {
                            // empty catch block
                        }
                    }
                    bis = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                var13_13 = null;
                if (null != bis) {
                    try {
                        bis.close();
                    }
                    catch (IOException ignored2222) {
                        // empty catch block
                    }
                }
                bis = null;
                throw throwable;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Returning " + advertisements.size() + " advertisements"));
        }
        return advertisements;
    }

    public long getAdvExpirationTime(ID id, int type) {
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Getting expiration time of " + advName + " of type " + dirname[type]));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"invalid attempt to get advertisement expiration time of NullID");
            }
            return -1L;
        }
        return this.cm.getExpirationtime(dirname[type], advName);
    }

    public long getAdvLifeTime(ID id, int type) {
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Getting lifetime of " + advName + " of type " + dirname[type]));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"invalid attempt to get advertisement lifetime of a NullID");
            }
            return -1L;
        }
        return this.cm.getLifetime(dirname[type], advName);
    }

    public long getAdvExpirationTime(Advertisement adv) {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        String advName = null;
        ID id = adv.getID();
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("attempting to getAdvExpirationTime on " + advName + " of type " + dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to get document", (Throwable)everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getExpirationtime(dirname[type], advName);
    }

    public long getAdvLifeTime(Advertisement adv) {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("attempting to getAdvLifeTime " + advName + " of type " + dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to get document", (Throwable)everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getLifetime(dirname[type], advName);
    }

    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupID() + "] Received an SRDI messsage"));
        }
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed parsing srdi message", (Throwable)e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        Iterator eachEntry = srdiMsg.getEntries().iterator();
        while (eachEntry.hasNext()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)eachEntry.next();
            if (entry.expiration <= 0L) continue;
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), entry.key, entry.value, pid, entry.expiration);
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [" + entry.key + "] value [" + entry.value + "] exp [" + entry.expiration + "]"));
        }
        this.srdi.replicateEntries(srdiMsg);
        return true;
    }

    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        if (this.srdiIndex != null) {
            this.srdiIndex.remove(peerid);
        }
    }

    public void pushEntries(boolean all) {
        this.pushSrdi(null, 0, all);
        this.pushSrdi(null, 1, all);
        this.pushSrdi(null, 2, all);
    }

    protected void pushSrdi(ID peer, int type, boolean all) {
        Vector entries = all ? this.cm.getEntries(dirname[type], true) : this.cm.getDeltas(dirname[type]);
        if (!entries.isEmpty()) {
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, dirname[type], (List)entries);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Pushing " + entries.size() + (all ? " entries" : " deltas") + " of type " + dirname[type]));
                }
                this.srdi.pushSrdi(peer, srdiMsg);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception pushing SRDI Entries", (Throwable)e);
                }
            }
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("No" + (all ? " entries" : " deltas") + " of type " + dirname[type] + " to push"));
        }
    }

    public synchronized void rendezvousEvent(RendezvousEvent event) {
        int theEventType = event.getType();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + "] Processing " + event));
        }
        switch (theEventType) {
            case 0: 
            case 1: {
                this.cm.setTrackDeltas(true);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.cm.setTrackDeltas(false);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                this.beRendezvous();
                break;
            }
            case 9: {
                this.beEdge();
                break;
            }
            default: {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                LOG.warn((Object)("[" + this.group.getPeerGroupName() + "] Unexpected RDV event : " + event));
            }
        }
    }

    private static synchronized int nextQid() {
        return qid++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdatePeerAdv() {
        PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
        int newModCount = newPadv.getModCount();
        boolean updated = false;
        Object object = this.checkPeerAdvLock;
        synchronized (object) {
            block8: {
                if (this.lastPeerAdv != newPadv || this.lastModCount < newModCount) {
                    this.lastPeerAdv = newPadv;
                    this.lastModCount = newModCount;
                    updated = true;
                }
                if (updated) {
                    try {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"publishing local advertisement");
                        }
                        this.publish(newPadv, Long.MAX_VALUE, 0x6DDD00L);
                    }
                    catch (Exception ignoring) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block8;
                        LOG.warn((Object)"Could not publish local peer advertisement: ", (Throwable)ignoring);
                    }
                }
            }
        }
    }

    private synchronized void beRendezvous() {
        if (this.isRdv && (this.srdi != null || this.srdiIndex != null)) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Already a rendezvous -- No Switch is needed");
            }
            return;
        }
        this.isRdv = true;
        this.cm.setTrackDeltas(false);
        if (this.srdiIndex == null) {
            this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"srdiIndex created");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, this.srdiIndex, this.initialDelay, this.runInterval);
            this.resolver.registerSrdiHandler(this.handlerName, this);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"srdi created, and registered as an srdi handler ");
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Switched to Rendezvous peer role.");
        }
    }

    private synchronized void beEdge() {
        if (!this.isRdv && this.srdiThread != null) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Already an Edge peer -- No Switch is needed.");
            }
            return;
        }
        this.isRdv = false;
        if (this.rendezvous.getConnectedRendezVous().hasMoreElements()) {
            this.cm.setTrackDeltas(true);
        }
        if (this.srdiIndex != null) {
            this.srdiIndex.stop();
            this.srdiIndex = null;
            this.resolver.unregisterSrdiHandler(this.handlerName);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"stopped cache and unregistered from resolver");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, null, this.initialDelay, this.runInterval);
            this.srdiThread = new Thread(this.group.getHomeThreadGroup(), this.srdi, "Discovery Srdi Thread");
            this.srdiThread.setDaemon(true);
            this.srdiThread.start();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Started SRDIThread");
            }
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Switched to a Edge peer role.");
        }
    }
}

