/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.protocol.ResolverSrdiMsgImpl;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.JxtaHash;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Srdi
implements Runnable,
RendezvousListener {
    private static final Logger LOG = Logger.getLogger((String)Srdi.class.getName());
    private PeerGroup group = null;
    private String handlername = null;
    private SrdiInterface srdiService = null;
    private SrdiIndex srdiIndex;
    private long connectPollInterval = 0L;
    private long pushInterval = 0L;
    private volatile boolean stop = false;
    private volatile boolean republish = true;
    private ResolverService resolver;
    private MembershipService membership;
    private JxtaHash jxtaHash = new JxtaHash();
    private CredentialListener membershipCredListener = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private static Random random = new Random();
    public static final int RPV_REPLICATION_THRESHOLD = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Srdi(PeerGroup group, String handlername, SrdiInterface srdiService, SrdiIndex srdiIndex, long connectPollInterval, long pushInterval) {
        this.group = group;
        this.handlername = handlername;
        this.srdiService = srdiService;
        this.srdiIndex = srdiIndex;
        this.connectPollInterval = connectPollInterval;
        this.pushInterval = pushInterval;
        this.membership = group.getMembershipService();
        this.resolver = group.getResolverService();
        group.getRendezVousService().addListener(this);
        Srdi srdi = this;
        synchronized (srdi) {
            block5: {
                this.membershipCredListener = new CredentialListener();
                this.membership.addPropertyChangeListener("defaultCredential", this.membershipCredListener);
                try {
                    this.credential = this.membership.getDefaultCredential();
                    this.credentialDoc = null != this.credential ? this.credential.getDocument(MimeMediaType.XMLUTF8) : null;
                }
                catch (Exception all) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                    LOG.warn((Object)"could not get credential", (Throwable)all);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.group.getRendezVousService().removeListener(this);
        this.membership.removePropertyChangeListener("defaultCredential", this.membershipCredListener);
        this.membershipCredListener = null;
        this.notify();
    }

    public void replicateEntries(SrdiMessage srdiMsg) {
        PeerID destPeer;
        Vector rpv = this.getGlobalPeerView();
        if (srdiMsg.getTTL() < 1 || !this.group.isRendezvous() || rpv.size() < 3) {
            return;
        }
        Iterator allEntries = srdiMsg.getEntries().iterator();
        HashMap<PeerID, SrdiMessageImpl> bins = new HashMap<PeerID, SrdiMessageImpl>(rpv.size());
        while (allEntries.hasNext()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)allEntries.next();
            destPeer = this.getReplicaPeer(srdiMsg.getPrimaryKey() + entry.key + entry.value);
            if (destPeer == null || destPeer.equals(this.group.getPeerID())) continue;
            SrdiMessageImpl sm = (SrdiMessageImpl)bins.get(destPeer);
            if (sm == null) {
                sm = new SrdiMessageImpl();
                sm.setPrimaryKey(srdiMsg.getPrimaryKey());
                sm.setPeerID(srdiMsg.getPeerID());
                bins.put(destPeer, sm);
            }
            sm.addEntry(entry);
        }
        Iterator peers = bins.keySet().iterator();
        while (peers.hasNext()) {
            destPeer = (PeerID)peers.next();
            SrdiMessageImpl msg = (SrdiMessageImpl)bins.get(destPeer);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding replica Srdi to " + destPeer));
            }
            this.pushSrdi(destPeer, msg);
        }
    }

    public void pushSrdi(ID peer, SrdiMessage srdi) {
        block4: {
            try {
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.credential, srdi.toString());
                if (null == peer) {
                    this.resolver.sendSrdi(null, resSrdi);
                } else {
                    this.resolver.sendSrdi(peer.toString(), resSrdi);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)"Failed to send srdi message", (Throwable)e);
            }
        }
    }

    public void forwardQuery(Object peer, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("hopCount exceeded. Not forwarding query " + query.getHopCount()));
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding Query to " + peer));
        }
        this.resolver.sendQuery(peer.toString(), query);
    }

    public void forwardQuery(Vector peers, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("hopCount exceeded not forwarding query " + query.getHopCount()));
            }
            return;
        }
        for (int i = 0; i < peers.size(); ++i) {
            PeerID peer = (PeerID)peers.elementAt(i);
            String destPeer = peer.toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding Query to " + destPeer));
            }
            this.resolver.sendQuery(destPeer, query);
        }
    }

    public void forwardQuery(Vector peers, ResolverQueryMsg query, int threshold) {
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] hopCount exceeded (" + query.getHopCount() + ") not forwarding query."));
            }
            return;
        }
        if (peers.size() <= threshold) {
            this.forwardQuery(peers, query);
        } else {
            Vector newPeers = this.randomResult(peers, threshold);
            this.forwardQuery(newPeers, query);
        }
    }

    protected Vector randomResult(Vector result, int threshold) {
        if (threshold < result.size()) {
            Vector res = new Vector(threshold);
            for (int i = 0; i < threshold; ++i) {
                int rand = random.nextInt(result.size());
                res.addElement(result.elementAt(rand));
                result.removeElementAt(rand);
            }
            return res;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerID getReplicaPeer(String expression) {
        PeerID pid = null;
        Vector rpv = this.getGlobalPeerView();
        if (rpv.size() >= 3) {
            BigInteger digest = null;
            Srdi srdi = this;
            synchronized (srdi) {
                this.jxtaHash.update(expression);
                digest = this.jxtaHash.getDigestInteger().abs();
            }
            BigInteger sizeOfSpace = BigInteger.valueOf(rpv.size());
            BigInteger sizeOfHashSpace = BigInteger.ONE.shiftLeft(8 * digest.toByteArray().length);
            int pos = digest.multiply(sizeOfSpace).divide(sizeOfHashSpace).intValue();
            pid = (PeerID)rpv.elementAt(pos);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Found a direct peer " + pid));
            }
            return pid;
        }
        return null;
    }

    public void forwardSrdiMessage(PeerID peerid, PeerID srcPid, String primaryKey, String secondarykey, String value, long expiration) {
        block3: {
            try {
                SrdiMessageImpl srdi = new SrdiMessageImpl(srcPid, 0, primaryKey, secondarykey, value, expiration);
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.credential, srdi.toString());
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding a SRDI messsage of type " + primaryKey + " to " + peerid));
                }
                this.resolver.sendSrdi(peerid.toString(), resSrdi);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failed forwarding SRDI Message", (Throwable)e);
            }
        }
    }

    public synchronized void rendezvousEvent(RendezvousEvent event) {
        int theEventType = event.getType();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Processing " + event));
        }
        switch (theEventType) {
            case 0: {
                this.republish = true;
            }
            case 1: {
                this.notify();
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                this.republish = true;
                break;
            }
            case 6: 
            case 7: {
                if (!this.group.isRendezvous() || this.srdiIndex == null) break;
                this.srdiIndex.remove((PeerID)event.getPeerID());
                break;
            }
            default: {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                LOG.warn((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Unexpected RDV event " + event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block15: {
            try {
                while (!this.stop) {
                    boolean waitingForRdv = this.group.isRendezvous() || !this.group.getRendezVousService().isConnectedToRendezVous();
                    this.republish |= waitingForRdv;
                    Srdi srdi = this;
                    synchronized (srdi) {
                        if (waitingForRdv) {
                            try {
                                this.wait(this.connectPollInterval);
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                            }
                            continue;
                        }
                        if (!this.republish) {
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Sleeping for " + this.pushInterval + "ms before sending deltas."));
                            }
                            try {
                                this.wait(this.pushInterval);
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                continue;
                            }
                            if (this.stop) {
                                break;
                            }
                        }
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Pushing " + (this.republish ? "all entries" : "deltas")));
                    }
                    this.srdiService.pushEntries(this.republish);
                    this.republish = false;
                }
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block15;
                LOG.error((Object)("Uncaught Throwable in " + Thread.currentThread().getName() + "[" + this.group.getPeerGroupName() + " / " + this.handlername + "]"), all);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getGlobalPeerView() {
        Vector<PeerID> global = new Vector<PeerID>();
        TreeSet<String> set = new TreeSet<String>();
        try {
            Vector rpv = this.group.getRendezVousService().getLocalWalkView();
            Iterator eachPVE = rpv.iterator();
            while (eachPVE.hasNext()) {
                RdvAdvertisement padv = (RdvAdvertisement)eachPVE.next();
                set.add(padv.getPeerID().toString());
            }
            set.add(this.group.getPeerID().toString());
            Iterator eachPeerID = set.iterator();
            while (eachPeerID.hasNext()) {
                try {
                    PeerID id = (PeerID)IDFactory.fromURI(new URI((String)eachPeerID.next()));
                    global.add(id);
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("ID was not a peerID");
                    return global;
                }
            }
        }
        catch (Exception ex) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) return global;
            LOG.warn((Object)"Failure generating the global view", (Throwable)ex);
        }
        return global;
    }

    public static interface SrdiInterface {
        public void pushEntries(boolean var1);
    }

    private class CredentialListener
    implements PropertyChangeListener {
        private CredentialListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if ("defaultCredential".equals(evt.getPropertyName())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"New default credential event");
                }
                Srdi srdi = Srdi.this;
                synchronized (srdi) {
                    block8: {
                        Srdi.this.credential = (Credential)evt.getNewValue();
                        Srdi.this.credentialDoc = null;
                        if (null != Srdi.this.credential) {
                            try {
                                Srdi.this.credentialDoc = Srdi.this.credential.getDocument(MimeMediaType.XMLUTF8);
                            }
                            catch (Exception all) {
                                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block8;
                                LOG.warn((Object)"Could not generate credential document", (Throwable)all);
                            }
                        }
                    }
                }
            }
        }
    }
}

