/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.access.always;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.access.AccessService;
import net.jxta.credential.Credential;
import net.jxta.credential.PrivilegedOperation;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AlwaysAccessService
implements AccessService {
    private static final Logger LOG = Logger.getLogger((String)AlwaysAccessService.class.getName());
    PeerGroup group;
    ModuleImplAdvertisement implAdvertisement;
    static /* synthetic */ Class class$net$jxta$document$TextElement;

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        this.group = group;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Access Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.info((Object)configInfo);
        }
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public Service getInterface() {
        return this;
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    public AccessService.AccessResult doAccessCheck(PrivilegedOperation op, Credential cred) {
        if (null == op) {
            throw new IllegalArgumentException("operation must not be null");
        }
        if (null == cred) {
            throw new IllegalArgumentException("credential must not be null");
        }
        if (!cred.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (!op.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        return "DENY".equals(cred.getSubject()) || "DENY".equals(op.getSubject()) ? AccessService.AccessResult.DISALLOWED : AccessService.AccessResult.PERMITTED;
    }

    public PrivilegedOperation newPrivilegedOperation(Object subject, Credential offerer) {
        if (!(subject instanceof String)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports String subjects.");
        }
        if (!offerer.isValid()) {
            throw new IllegalArgumentException("offerer is not a valid credential");
        }
        return new AlwaysOperation(this, (String)subject, offerer);
    }

    public PrivilegedOperation newPrivilegedOperation(Element source) {
        return new AlwaysOperation(this, source);
    }

    private static class AlwaysOperation
    implements PrivilegedOperation {
        AlwaysAccessService source;
        String op;
        Credential offerer;

        protected AlwaysOperation(AlwaysAccessService source, String op, Credential offerer) {
            this.source = source;
            this.op = op;
            this.offerer = offerer;
        }

        protected AlwaysOperation(AlwaysAccessService source, Element root) {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public Object getSubject() {
            return this.op;
        }

        public Service getSourceService() {
            return this.source;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:AlwaysOp");
            }
            Element e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("Operation", this.op);
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, doc, this.offerer.getDocument(as), "Offerer");
            return doc;
        }

        public Credential getOfferer() {
            return this.offerer;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URL gID = IDFactory.jxtaURL(elem.getTextValue());
                    ID pgid = IDFactory.fromURL(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Operation")) {
                this.op = elem.getTextValue();
                return true;
            }
            if (elem.getName().equals("Offerer")) {
                try {
                    this.offerer = this.source.getPeerGroup().getMembershipService().makeCredential(elem);
                }
                catch (Throwable failed) {
                    throw new IllegalArgumentException("Offerer credential could not be constructed" + failed);
                }
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!(class$net$jxta$document$TextElement == null ? (class$net$jxta$document$TextElement = AlwaysAccessService.class$("net.jxta.document.TextElement")) : class$net$jxta$document$TextElement).isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!((doctype = doc.getName()).equals("jxta:AlwaysOp") || doctype.equals("jxta:Cred") && "jxta:AlwaysOp".equals(typedoctype))) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Unhandleded element '" + elem.getName() + "' in " + doc.getName()));
            }
            if (null == this.op) {
                throw new IllegalArgumentException("operation was never initialized.");
            }
            if (null == this.offerer) {
                throw new IllegalArgumentException("offerer was never initialized.");
            }
        }
    }
}

