/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.jxta.id.IDFactory;
import net.jxta.id.NullID;

public abstract class ID
implements Serializable {
    public static final String URIEncodingName = "urn";
    public static final String URNNamespace = "jxta";
    public static final ID nullID = new NullID();

    public static ID create(URI fromURI) {
        try {
            return IDFactory.fromURI(fromURI);
        }
        catch (URISyntaxException badid) {
            IllegalArgumentException failure = new IllegalArgumentException();
            failure.initCause(badid);
            throw failure;
        }
    }

    protected ID() {
    }

    public final Object clone() {
        return this;
    }

    public String toString() {
        return this.toURI().toString();
    }

    public abstract String getIDFormat();

    public abstract Object getUniqueValue();

    public abstract URL getURL();

    public URI toURI() {
        return URI.create(this.getURL().toString());
    }
}

