/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.util.WeakHashMap;
import net.jxta.endpoint.AbstractMessenger;
import net.jxta.endpoint.AsyncChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerState;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ThreadedMessenger
extends AbstractMessenger
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)ThreadedMessenger.class.getName());
    private static final ThreadGroup myThreadGroup = new ThreadGroup("Threaded Messengers");
    private volatile EndpointAddress logicalDestination = null;
    private volatile boolean inputClosed = false;
    private PeerGroupID homeGroupID = null;
    private static final long THREAD_IDLE_DEAD = 4000L;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_SEND = 1;
    private static final int ACTION_CONNECT = 2;
    private int deferredAction = 0;
    private Thread bgThread = null;
    private int channelQueueSize = 1;
    private UnbiasedQueue activeChannels = null;
    private WeakHashMap resolvingChannels = null;
    private ThreadedMessengerChannel defaultChannel = null;
    private ThreadedMessengerState stateMachine = new ThreadedMessengerState();

    public ThreadedMessenger(PeerGroupID homeGroupID, EndpointAddress destination, EndpointAddress logicalDestination, int channelQueueSize) {
        super(destination);
        this.homeGroupID = homeGroupID;
        this.setStateLock(this.stateMachine);
        this.logicalDestination = logicalDestination;
        this.channelQueueSize = channelQueueSize;
        this.activeChannels = new UnbiasedQueue(Integer.MAX_VALUE, false);
        this.resolvingChannels = new WeakHashMap(4);
    }

    public void run() {
        try {
            block7: while (true) {
                switch (this.nextAction()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.send();
                        continue block7;
                    }
                    case 2: {
                        this.connect();
                        continue block7;
                    }
                }
            }
        }
        catch (Throwable any) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"Uncaught throwable in background thread", any);
            }
            this.bgThread = null;
            return;
        }
    }

    private void deferAction(int action) {
        this.deferredAction = action;
        if (this.bgThread == null) {
            this.bgThread = new Thread(myThreadGroup, this, "ThreadedMessenger for " + this.getDestinationAddress());
            this.bgThread.setDaemon(true);
            this.bgThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextAction() {
        long quitAt = TimeUtils.toAbsoluteTimeMillis(4000L);
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            while (this.deferredAction == 0) {
                if (TimeUtils.toRelativeTimeMillis(quitAt) < 0L) {
                    this.bgThread = null;
                    return 0;
                }
                try {
                    this.stateMachine.wait(4000L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
            }
            int action = this.deferredAction;
            this.deferredAction = 0;
            return action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() {
        ThreadedMessengerChannel theChannel = null;
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            theChannel = (ThreadedMessengerChannel)this.activeChannels.peek();
            if (theChannel == null) {
                this.stateMachine.idleEvent();
                this.stateMachine.notifyAll();
                return;
            }
        }
        while (true) {
            AsyncChannelMessenger.PendingMessage theMsg;
            if ((theMsg = theChannel.peek()) == null) {
                ThreadedMessengerState threadedMessengerState2 = this.stateMachine;
                synchronized (threadedMessengerState2) {
                    this.activeChannels.pop();
                    theChannel = (ThreadedMessengerChannel)this.activeChannels.peek();
                    if (theChannel != null) {
                        continue;
                    }
                    this.stateMachine.idleEvent();
                    this.stateMachine.notifyAll();
                }
                this.notifyChange();
                return;
            }
            Message currentMsg = theMsg.msg;
            String currentService = theMsg.service;
            String currentParam = theMsg.param;
            try {
                this.sendMessageBImpl(currentMsg, currentService, currentParam);
            }
            catch (Throwable any) {
                ThreadedMessengerState threadedMessengerState3 = this.stateMachine;
                synchronized (threadedMessengerState3) {
                    if (theMsg.failure != null) {
                        theChannel.pop();
                        currentMsg.setMessageProperty(Messenger.class, theMsg.failure);
                    } else {
                        theMsg.failure = any;
                    }
                    this.stateMachine.downEvent();
                    this.stateMachine.notifyAll();
                }
                this.notifyChange();
                return;
            }
            ThreadedMessengerState threadedMessengerState4 = this.stateMachine;
            synchronized (threadedMessengerState4) {
                boolean empty;
                theChannel.pop();
                boolean bl = empty = theChannel.peek() == null;
                if (this.activeChannels.getCurrentInQueue() != 1 || empty) {
                    this.activeChannels.pop();
                    if (!empty) {
                        this.activeChannels.push(theChannel);
                    }
                    if ((theChannel = (ThreadedMessengerChannel)this.activeChannels.peek()) == null) {
                        this.stateMachine.idleEvent();
                        this.stateMachine.notifyAll();
                    }
                }
            }
            if (theChannel == null) break;
        }
        this.notifyChange();
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        boolean worked = this.connectImpl();
        ThreadedMessengerChannel[] channels = null;
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (worked) {
                EndpointAddress effectiveLogicalDest = this.getLogicalDestinationImpl();
                if (this.logicalDestination == null) {
                    this.logicalDestination = effectiveLogicalDest;
                    this.stateMachine.upEvent();
                    channels = this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
                    this.resolvingChannels.clear();
                } else if (this.logicalDestination.equals(effectiveLogicalDest)) {
                    this.stateMachine.upEvent();
                    channels = this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
                    this.resolvingChannels.clear();
                } else {
                    this.closeImpl();
                    this.stateMachine.downEvent();
                }
            } else {
                this.stateMachine.downEvent();
            }
            this.stateMachine.notifyAll();
        }
        if (channels != null) {
            int i = channels.length;
            while (i-- > 0) {
                channels[i].up();
            }
            channels = null;
        }
        this.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdown() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.shutdownEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return this.logicalDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.closeEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendMessageN(Message msg, String service, String serviceParam) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.defaultChannel == null) {
                this.defaultChannel = new ThreadedMessengerChannel(this.getDestinationAddress(), null, null, null, this.channelQueueSize, false);
            }
        }
        return this.defaultChannel.sendMessageN(msg, service, serviceParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessageB(Message msg, String service, String serviceParam) throws IOException {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.defaultChannel == null) {
                this.defaultChannel = new ThreadedMessengerChannel(this.getDestinationAddress(), null, null, null, this.channelQueueSize, false);
            }
        }
        this.defaultChannel.sendMessageB(msg, service, serviceParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addToActiveChannels(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.inputClosed) {
                return false;
            }
            this.activeChannels.push(channel);
            this.stateMachine.msgsEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void strongRefResolvingChannel(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if (this.resolvingChannels.containsKey(channel)) {
                this.resolvingChannels.put(channel, channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addToResolvingChannels(ThreadedMessengerChannel channel) {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            if ((this.stateMachine.getState() & 0x7DBCC) != 0) {
                return false;
            }
            this.resolvingChannels.put(channel, null);
            this.stateMachine.resolveEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolve() {
        ThreadedMessengerState threadedMessengerState = this.stateMachine;
        synchronized (threadedMessengerState) {
            this.stateMachine.resolveEvent();
            this.stateMachine.notifyAll();
        }
        this.notifyChange();
    }

    public final int getState() {
        return this.stateMachine.getState();
    }

    public Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return new ThreadedMessengerChannel(this.getDestinationAddress(), this.homeGroupID.equals(redirection) ? null : redirection, service, serviceParam, this.channelQueueSize, (this.stateMachine.getState() & 0x3CC) != 0);
    }

    protected abstract void closeImpl();

    protected abstract boolean connectImpl();

    protected abstract void sendMessageBImpl(Message var1, String var2, String var3) throws IOException;

    protected abstract EndpointAddress getLogicalDestinationImpl();

    private class ThreadedMessengerState
    extends MessengerState {
        protected ThreadedMessengerState() {
            super(false);
        }

        protected void connectAction() {
            ThreadedMessenger.this.deferAction(2);
        }

        protected void startAction() {
            ThreadedMessenger.this.deferAction(1);
        }

        protected void closeInputAction() {
            ThreadedMessenger.this.inputClosed = true;
            ThreadedMessengerChannel[] channels = ThreadedMessenger.this.resolvingChannels.keySet().toArray(new ThreadedMessengerChannel[0]);
            ThreadedMessenger.this.resolvingChannels.clear();
            int i = channels.length;
            while (i-- > 0) {
                channels[i].down();
            }
            channels = null;
        }

        protected void closeOutputAction() {
            ThreadedMessenger.this.closeImpl();
        }

        protected void failAllAction() {
            while (true) {
                ThreadedMessengerChannel theChannel = null;
                theChannel = (ThreadedMessengerChannel)ThreadedMessenger.this.activeChannels.pop();
                if (theChannel == null) break;
                theChannel.down();
            }
        }
    }

    private class ThreadedMessengerChannel
    extends AsyncChannelMessenger {
        public ThreadedMessengerChannel(EndpointAddress baseAddress, PeerGroupID redirection, String origService, String origServiceParam, int queueSize, boolean connected) {
            super(baseAddress, redirection, origService, origServiceParam, queueSize, connected);
        }

        public EndpointAddress getLogicalDestinationAddress() {
            if (ThreadedMessenger.this.logicalDestination == null) {
                return null;
            }
            return (EndpointAddress)ThreadedMessenger.this.logicalDestination.clone();
        }

        protected void startImpl() {
            if (!ThreadedMessenger.this.addToActiveChannels(this)) {
                this.down();
            }
        }

        protected void connectImpl() {
            if (!ThreadedMessenger.this.addToResolvingChannels(this)) {
                if ((ThreadedMessenger.this.getState() & 0x3FF) != 0) {
                    this.up();
                } else {
                    this.down();
                }
            }
        }

        protected void resolPendingImpl() {
            ThreadedMessenger.this.strongRefResolvingChannel(this);
        }
    }
}

