/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

public abstract class MessengerState {
    private static Action Connect = new Action(){

        public void doIt(MessengerState s) {
            s.connectAction();
        }
    };
    private static Action Closein = new Action(){

        public void doIt(MessengerState s) {
            s.closeInputAction();
        }
    };
    private static Action Start = new Action(){

        public void doIt(MessengerState s) {
            s.startAction();
        }
    };
    private static Action Closeout = new Action(){

        public void doIt(MessengerState s) {
            s.closeOutputAction();
        }
    };
    private static Action Failall = new Action(){

        public void doIt(MessengerState s) {
            s.failAllAction();
        }
    };
    private static Action Closeio = new Action(){

        public void doIt(MessengerState s) {
            s.closeInputAction();
            s.closeOutputAction();
        }
    };
    private static Action Closefail = new Action(){

        public void doIt(MessengerState s) {
            s.closeInputAction();
            s.failAllAction();
        }
    };
    private static Action Nop = new Action(){

        public void doIt(MessengerState s) {
        }
    };
    private volatile State state = null;

    protected MessengerState(boolean connected) {
        this.state = connected ? TransitionMap.Connected : TransitionMap.Unresolved;
    }

    public int getState() {
        return this.state.number;
    }

    public void resolveEvent() {
        Action a = this.state.acResolve;
        this.state = this.state.stResolve;
        a.doIt(this);
    }

    public void msgsEvent() {
        Action a = this.state.acMsgs;
        this.state = this.state.stMsgs;
        a.doIt(this);
    }

    public void saturatedEvent() {
        Action a = this.state.acSaturated;
        this.state = this.state.stSaturated;
        a.doIt(this);
    }

    public void closeEvent() {
        Action a = this.state.acClose;
        this.state = this.state.stClose;
        a.doIt(this);
    }

    public void shutdownEvent() {
        Action a = this.state.acShutdown;
        this.state = this.state.stShutdown;
        a.doIt(this);
    }

    public void upEvent() {
        Action a = this.state.acUp;
        this.state = this.state.stUp;
        a.doIt(this);
    }

    public void downEvent() {
        Action a = this.state.acDown;
        this.state = this.state.stDown;
        a.doIt(this);
    }

    public void idleEvent() {
        Action a = this.state.acIdle;
        this.state = this.state.stIdle;
        a.doIt(this);
    }

    protected abstract void connectAction();

    protected abstract void startAction();

    protected abstract void closeInputAction();

    protected abstract void failAllAction();

    protected abstract void closeOutputAction();

    static class TransitionMap {
        static State Unresolved = new State();
        static State ResPending = new State();
        static State Resolving = new State();
        static State ResolSat = new State();
        static State Connected = new State();
        static State Disconned = new State();
        static State Reconning = new State();
        static State ReconSat = new State();
        static State Sending = new State();
        static State SendingSat = new State();
        static State ResClosing = new State();
        static State ReconClosing = new State();
        static State Closing = new State();
        static State Disconning = new State();
        static State Unresable = new State();
        static State Closed = new State();
        static State Broken = new State();

        TransitionMap() {
        }

        static {
            Object[][] tmpMap = new Object[][]{{Resolving, Connect, ResPending, Connect, ResolSat, Connect, Closed, Closein, Broken, Closein, Connected, Nop, Unresolved, Nop, Unresolved, Nop}, {ResPending, Nop, ResPending, Nop, ResolSat, Nop, ResClosing, Closein, Broken, Closefail, Sending, Start, Unresable, Closefail, Resolving, Nop}, {Resolving, Nop, ResPending, Nop, ResolSat, Nop, Closed, Closein, Broken, Closein, Connected, Nop, Unresable, Closein, Resolving, Nop}, {ResolSat, Nop, ResPending, Nop, ResolSat, Nop, ResClosing, Closein, Broken, Closefail, SendingSat, Start, Unresable, Closefail, Resolving, Nop}, {Connected, Nop, Sending, Start, SendingSat, Start, Closed, Closeio, Broken, Closeio, Connected, Nop, Disconned, Nop, Connected, Nop}, {Disconned, Nop, Reconning, Connect, ReconSat, Connect, Closed, Closein, Broken, Closein, Connected, Nop, Disconned, Nop, Disconned, Nop}, {Reconning, Nop, Reconning, Nop, ReconSat, Nop, ReconClosing, Closein, Broken, Closefail, Sending, Start, Broken, Closefail, Disconned, Nop}, {ReconSat, Nop, Reconning, Nop, ReconSat, Nop, ReconClosing, Closein, Broken, Closefail, SendingSat, Start, Broken, Closefail, Disconned, Nop}, {Sending, Nop, Sending, Nop, SendingSat, Nop, Closing, Closein, Disconning, Closeio, Sending, Nop, Reconning, Connect, Connected, Nop}, {SendingSat, Nop, Sending, Nop, SendingSat, Nop, Closing, Closein, Disconning, Closeio, SendingSat, Nop, ReconSat, Connect, Connected, Nop}, {ResClosing, Nop, ResClosing, Nop, ResClosing, Nop, ResClosing, Nop, Broken, Failall, Closing, Start, Unresable, Failall, ResClosing, Nop}, {ReconClosing, Nop, ReconClosing, Nop, ReconClosing, Nop, ReconClosing, Nop, Broken, Failall, Closing, Start, Broken, Failall, ReconClosing, Nop}, {Closing, Nop, Closing, Nop, Closing, Nop, Closing, Nop, Disconning, Closeout, Closing, Nop, ReconClosing, Connect, Closed, Closeout}, {Disconning, Nop, Disconning, Nop, Disconning, Nop, Disconning, Nop, Disconning, Nop, Disconning, Nop, Broken, Failall, Broken, Nop}, {Unresable, Nop, Unresable, Nop, Unresable, Nop, Unresable, Nop, Unresable, Nop, Unresable, Closeout, Unresable, Nop, Unresable, Nop}, {Closed, Nop, Closed, Nop, Closed, Nop, Closed, Nop, Closed, Nop, Closed, Closeout, Closed, Nop, Closed, Nop}, {Broken, Nop, Broken, Nop, Broken, Nop, Broken, Nop, Broken, Nop, Broken, Closeout, Broken, Nop, Broken, Nop}};
            Unresolved.init(1, tmpMap[0]);
            ResPending.init(16, tmpMap[1]);
            Resolving.init(2, tmpMap[2]);
            ResolSat.init(32, tmpMap[3]);
            Connected.init(4, tmpMap[4]);
            Disconned.init(8, tmpMap[5]);
            Reconning.init(256, tmpMap[6]);
            ReconSat.init(512, tmpMap[7]);
            Sending.init(64, tmpMap[8]);
            SendingSat.init(128, tmpMap[9]);
            ResClosing.init(1024, tmpMap[10]);
            ReconClosing.init(4096, tmpMap[11]);
            Closing.init(2048, tmpMap[12]);
            Disconning.init(32768, tmpMap[13]);
            Unresable.init(65536, tmpMap[14]);
            Closed.init(262144, tmpMap[15]);
            Broken.init(131072, tmpMap[16]);
        }
    }

    private static class State {
        int number;
        State stResolve;
        Action acResolve;
        State stMsgs;
        Action acMsgs;
        State stSaturated;
        Action acSaturated;
        State stClose;
        Action acClose;
        State stShutdown;
        Action acShutdown;
        State stUp;
        Action acUp;
        State stDown;
        Action acDown;
        State stIdle;
        Action acIdle;

        private State() {
        }

        void init(int stateNum, Object[] data) {
            this.number = stateNum;
            this.stResolve = (State)data[0];
            this.acResolve = (Action)data[1];
            this.stMsgs = (State)data[2];
            this.acMsgs = (Action)data[3];
            this.stSaturated = (State)data[4];
            this.acSaturated = (Action)data[5];
            this.stClose = (State)data[6];
            this.acClose = (Action)data[7];
            this.stShutdown = (State)data[8];
            this.acShutdown = (Action)data[9];
            this.stUp = (State)data[10];
            this.acUp = (Action)data[11];
            this.stDown = (State)data[12];
            this.acDown = (Action)data[13];
            this.stIdle = (State)data[14];
            this.acIdle = (Action)data[15];
        }
    }

    private static interface Action {
        public void doIt(MessengerState var1);
    }
}

