/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.impl.id.UUID.UUIDFactory;
import net.jxta.util.CountingOutputStream;
import net.jxta.util.DevNullOutputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class MessageElement
implements Document {
    private static final transient Logger LOG = Logger.getLogger((String)MessageElement.class.getName());
    protected final String name;
    protected final MimeMediaType type;
    protected final MessageElement sig;
    protected Map properties = new HashMap();
    protected transient long cachedGetByteLength = -1L;
    protected transient SoftReference cachedGetBytes = null;
    protected transient SoftReference cachedToString = null;

    public static String getUniqueName() {
        return UUIDFactory.newUUID().toString();
    }

    public static String getSequentialName() {
        return UUIDFactory.newSeqUUID().toString();
    }

    protected MessageElement(String name, MimeMediaType type, MessageElement sig) {
        this.name = null != name ? name : "";
        MimeMediaType mimeMediaType = this.type = null != type ? type : MimeMediaType.AOS;
        if (null != sig && null != sig.sig) {
            throw new IllegalArgumentException("Invalid Signature Element. Signatures may not have signatures.");
        }
        this.sig = sig;
    }

    public final Object clone() {
        return this;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            MessageElement likeMe = (MessageElement)target;
            boolean sigequals = null != this.sig ? this.sig.equals(likeMe.sig) : null == likeMe.sig;
            return sigequals && this.name.equals(likeMe.name) && this.type.equals(likeMe.type);
        }
        return false;
    }

    public int hashCode() {
        int sigHash = null != this.getSignature() && this != this.getSignature() ? this.getSignature().hashCode() : 1;
        int result = sigHash * 2467 + this.getElementName().hashCode() * 3943 + this.getMimeType().hashCode();
        return 0 != result ? result : 1;
    }

    public synchronized String toString() {
        String result = null;
        if (null != this.cachedToString && null != (result = (String)this.cachedToString.get())) {
            return result;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating toString of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        String charset = this.type.getParameter("charset");
        StringBuffer theString = new StringBuffer();
        InputStreamReader asString = null;
        try {
            int res;
            if (null == charset) {
                asString = new InputStreamReader(this.getStream());
            } else {
                try {
                    asString = new InputStreamReader(this.getStream(), charset);
                }
                catch (UnsupportedEncodingException caught) {
                    throw new IllegalStateException("Unsupported charset : " + charset);
                }
            }
            char[] characters = new char[256];
            while ((res = asString.read(characters)) >= 0) {
                theString.append(characters, 0, res);
            }
            result = theString.toString();
            this.cachedToString = new SoftReference<String>(result);
            return result;
        }
        catch (IOException caught) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Could not generate string for element. ", (Throwable)caught);
            }
            throw new IllegalStateException("Could not generate string for element. " + caught);
        }
    }

    public String getElementName() {
        return this.name;
    }

    public MimeMediaType getMimeType() {
        return this.type;
    }

    public String getFileExtension() {
        return "???";
    }

    public synchronized long getByteLength() {
        if (this.cachedGetByteLength >= 0L) {
            return this.cachedGetByteLength;
        }
        CountingOutputStream countBytes = new CountingOutputStream(new DevNullOutputStream());
        try {
            this.sendToStream(countBytes);
            this.cachedGetByteLength = countBytes.getBytesWritten();
            return this.cachedGetByteLength;
        }
        catch (IOException caught) {
            throw new IllegalStateException("Could not get length of element : " + caught.toString());
        }
    }

    public synchronized byte[] getBytes(boolean copy) {
        long len;
        byte[] result = null;
        if (null != this.cachedGetBytes && null != (result = (byte[])this.cachedGetBytes.get())) {
            if (copy) {
                byte[] theCopy = new byte[result.length];
                System.arraycopy(theCopy, 0, result, 0, result.length);
            } else {
                return result;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating getBytes of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        if ((len = this.getByteLength()) > Integer.MAX_VALUE) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"MessageElement is too large to be stored in a byte array.");
            }
            throw new IllegalStateException("MessageElement is too large to be stored in a byte array.");
        }
        result = new byte[(int)len];
        try {
            DataInputStream di = new DataInputStream(this.getStream());
            di.readFully(result);
        }
        catch (IOException caught) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"ailed to get bytes of Message Element. ", (Throwable)caught);
            }
            throw new IllegalStateException("Failed to get bytes of Message Element. " + caught);
        }
        if (!copy) {
            this.cachedGetBytes = new SoftReference<byte[]>(result);
        }
        return result;
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        MessageElement.copyInputStreamToOutputStream(this.getStream(), sendTo);
    }

    public MessageElement getSignature() {
        return this.sig;
    }

    public synchronized Object setElementProperty(Object key, Object value) {
        return this.properties.put(key, value);
    }

    public Object getElementProperty(Object key) {
        return this.properties.get(key);
    }

    protected static void copyInputStreamToOutputStream(InputStream source, OutputStream sink) throws IOException {
        int c;
        byte[] buf = new byte[4096];
        while (-1 != (c = source.read(buf))) {
            sink.write(buf, 0, c);
        }
    }
}

