/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import net.jxta.endpoint.ChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerState;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Logger;

public abstract class AsyncChannelMessenger
extends ChannelMessenger {
    private static final Logger LOG = Logger.getLogger((String)AsyncChannelMessenger.class.getName());
    private boolean inputClosed = false;
    private boolean outputClosed = false;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_SEND = 1;
    private static final int ACTION_CONNECT = 2;
    private int deferredAction = 0;
    private UnbiasedQueue queue = null;
    private AsyncChannelMessengerState stateMachine = null;

    public AsyncChannelMessenger(EndpointAddress baseAddress, PeerGroupID redirection, String origService, String origServiceParam, int queueSize, boolean connected) {
        super(baseAddress, redirection, origService, origServiceParam);
        this.stateMachine = new AsyncChannelMessengerState(connected);
        this.queue = new UnbiasedQueue(queueSize, false);
        this.setStateLock(this.stateMachine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        int action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.closeEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sendMessageCommon(Message msg, String rService, String rServiceParam) throws IOException {
        String service = this.effectiveService(rService);
        String serviceParam = this.effectiveParam(rService, rServiceParam);
        boolean queued = true;
        boolean change = false;
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            int qsz;
            if (this.inputClosed) {
                throw new IOException("This messenger is closed. It cannot be used to send messages.");
            }
            int inq = this.queue.getCurrentInQueue();
            if (inq < (qsz = this.queue.getMaxQueueSize()) - 1) {
                this.queue.push(new PendingMessage(msg, service, serviceParam));
                if (inq == 0) {
                    change = true;
                    this.stateMachine.msgsEvent();
                    action = this.eventCalled();
                }
            } else if (inq == qsz - 1) {
                this.queue.push(new PendingMessage(msg, service, serviceParam));
                this.stateMachine.saturatedEvent();
                action = this.eventCalled();
                change = true;
            } else {
                this.stateMachine.saturatedEvent();
                action = this.eventCalled();
                queued = false;
            }
        }
        if (queued && change) {
            this.notifyChange();
        }
        this.performDeferredAction(action);
        if ((this.stateMachine.getState() & 0x30) != 0) {
            this.resolPendingImpl();
        }
        return queued;
    }

    public final boolean sendMessageN(Message msg, String rService, String rServiceParam) {
        try {
            if (this.sendMessageCommon(msg, rService, rServiceParam)) {
                return true;
            }
            msg.setMessageProperty(Messenger.class, OutgoingMessageEvent.OVERFLOW);
            return false;
        }
        catch (IOException oie) {
            msg.setMessageProperty(Messenger.class, new OutgoingMessageEvent(msg, oie));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sendMessageB(Message msg, String rService, String rServiceParam) throws IOException {
        try {
            while (true) {
                if (this.queue.getCurrentInQueue() == this.queue.getMaxQueueSize()) {
                    Thread.yield();
                }
                if (this.sendMessageCommon(msg, rService, rServiceParam)) {
                    return;
                }
                AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
                synchronized (asyncChannelMessengerState) {
                    this.stateMachine.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolve() {
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.resolveEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    public final int getState() {
        return this.stateMachine.getState();
    }

    public final Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return null;
    }

    private void performDeferredAction(int action) {
        switch (action) {
            case 1: {
                this.startImpl();
                break;
            }
            case 2: {
                this.connectImpl();
            }
        }
    }

    private int eventCalled() {
        int action = this.deferredAction;
        this.deferredAction = 0;
        this.stateMachine.notifyAll();
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void up() {
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.upEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void down() {
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.downEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PendingMessage peek() {
        PendingMessage theMsg = null;
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            theMsg = (PendingMessage)this.queue.peek();
            if (theMsg == null) {
                this.stateMachine.idleEvent();
                action = this.eventCalled();
                return null;
            }
            if (this.outputClosed) {
                this.stateMachine.downEvent();
                action = this.eventCalled();
                theMsg = null;
            }
        }
        this.notifyChange();
        this.performDeferredAction(action);
        return theMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean pop() {
        boolean result;
        int action = 0;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.queue.pop();
            if (this.queue.peek() == null) {
                this.stateMachine.idleEvent();
                action = this.eventCalled();
                result = false;
            } else {
                this.stateMachine.msgsEvent();
                action = this.eventCalled();
                result = true;
            }
        }
        this.notifyChange();
        this.performDeferredAction(action);
        return result;
    }

    protected abstract void startImpl();

    protected abstract void connectImpl();

    protected abstract void resolPendingImpl();

    protected static class PendingMessage {
        Message msg;
        String service;
        String param;
        Throwable failure;

        PendingMessage(Message msg, String service, String param) {
            this.msg = msg;
            this.service = service;
            this.param = param;
            this.failure = null;
        }
    }

    private class AsyncChannelMessengerState
    extends MessengerState {
        protected AsyncChannelMessengerState(boolean connected) {
            super(connected);
        }

        protected void connectAction() {
            AsyncChannelMessenger.this.deferredAction = 2;
        }

        protected void startAction() {
            AsyncChannelMessenger.this.deferredAction = 1;
        }

        protected void closeInputAction() {
            AsyncChannelMessenger.this.inputClosed = true;
        }

        protected void closeOutputAction() {
            AsyncChannelMessenger.this.outputClosed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void failAllAction() {
            while (true) {
                PendingMessage theMsg = null;
                AsyncChannelMessengerState asyncChannelMessengerState = AsyncChannelMessenger.this.stateMachine;
                synchronized (asyncChannelMessengerState) {
                    theMsg = (PendingMessage)AsyncChannelMessenger.this.queue.pop();
                }
                if (theMsg == null) {
                    return;
                }
                Message currentMsg = theMsg.msg;
                Throwable currentFailure = theMsg.failure;
                if (currentFailure == null) {
                    currentFailure = new IOException("Messenger unexpectedly closed");
                }
                OutgoingMessageEvent event = new OutgoingMessageEvent(currentMsg, currentFailure);
                currentMsg.setMessageProperty(class$net$jxta$endpoint$Messenger == null ? AsyncChannelMessenger.class$("net.jxta.endpoint.Messenger") : class$net$jxta$endpoint$Messenger, event);
            }
        }
    }
}

