/*
 * Decompiled with CFR 0.152.
 */
package madkit.scheme;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import javax.swing.JToolBar;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.OPanel;
import madkit.kernel.Utils;
import madkit.messages.ControlMessage;
import madkit.scheme.SchemeAgent;
import madkit.system.EditorAgent;
import madkit.utils.graphics.DefaultControlPanel;

class SchemeAgentGUI
extends DefaultControlPanel
implements ActionListener {
    OPanel outPanel;

    SchemeAgentGUI(SchemeAgent schemeAgent) {
        super((Agent)schemeAgent);
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.addSeparator();
        this.addButton(jToolBar, "notePad", "Edit script with NotePadAgent", "/images/agents/agentEditor24.gif");
        this.addButton(jToolBar, "jEdit", "Edit script with jEdit", "/images/toolbars/jedit24.gif");
        this.add(jToolBar, "North");
        this.outPanel = new OPanel();
        this.add((Component)this.outPanel, "Center");
    }

    OPanel getOutPanel() {
        return this.outPanel;
    }

    protected void jedit() {
        String string = ((SchemeAgent)this.ag).schemeSource;
        if (string == null) {
            File file = ((SchemeAgent)this.ag).schemeFile;
            if (file == null) {
                this.println("sorry no source file to edit");
            } else {
                string = file.getPath();
                AgentAddress agentAddress = this.ag.getAgentWithRole("system", "editor");
                if (agentAddress == null) {
                    try {
                        Class clazz = Utils.loadClass((String)"jsynedit.JSynEditAgent");
                        Constructor constructor = clazz.getConstructor(String.class);
                        Agent agent = (Agent)constructor.newInstance(string);
                        this.ag.launchAgent((AbstractAgent)agent, "JSynEdit", true);
                        agentAddress = this.ag.getAddress();
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to launch JSynEdit: check that you have the JSynEdit plugin");
                    }
                } else {
                    this.ag.sendMessage(agentAddress, (Message)new ControlMessage("edit", string));
                }
            }
        }
    }

    public void command(String string) {
        if (string.equals("evalBuffer")) {
            this.evalBuffer();
        } else if (string.equals("evalSelection")) {
            this.evalSelection();
        } else if (!(string.equals("run") || string.equals("halt") || string.equals("reinit"))) {
            if (string.equals("jEdit")) {
                this.jedit();
            } else if (string.equals("notePad")) {
                String string2 = ((SchemeAgent)this.ag).schemeSource;
                if (string2 == null) {
                    File file = ((SchemeAgent)this.ag).schemeFile;
                    if (file == null) {
                        this.println("sorry no source file to edit");
                    } else {
                        string2 = file.getPath();
                        this.println("editing : " + string2);
                        EditorAgent editorAgent = new EditorAgent(string2);
                        this.ag.launchAgent((AbstractAgent)editorAgent, "Edit : " + string2, true);
                    }
                } else {
                    this.println("editing : " + string2);
                    EditorAgent editorAgent = new EditorAgent(string2);
                    this.ag.launchAgent((AbstractAgent)editorAgent, "Edit : " + string2, true);
                }
            } else {
                super.command(string);
            }
        }
    }

    void evalBuffer() {
    }

    void evalSelection() {
    }

    public void println(String string) {
        this.ag.println(string);
    }
}

