/*
 * Decompiled with CFR 0.152.
 */
package warbot.kernel;

import java.awt.Color;
import java.io.Serializable;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AgentAddress;
import madkit.kernel.Message;
import madkit.kernel.ReferenceableAgent;
import madkit.messages.ControlMessage;
import warbot.kernel.BasicBody;
import warbot.kernel.Body;
import warbot.kernel.Food;
import warbot.kernel.Percept;
import warbot.kernel.Transportable;
import warbot.kernel.WarbotMessage;

public abstract class Brain
extends AbstractAgent
implements ReferenceableAgent,
Serializable {
    private Body myBody = null;
    private String myIcon = null;

    final void setBody(Body body) {
        this.myBody = body;
    }

    final Body getBody() {
        return this.myBody;
    }

    final void delete() {
        this.killAgent(this);
    }

    public void edit() {
        this.println("no editing method for a " + this.getClass().getName());
    }

    public void init() {
    }

    public final double towards(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 180.0 * Math.asin(d / Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0))) / Math.PI + 270.0;
        }
        return 180.0 * Math.acos(d / Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0))) / Math.PI;
    }

    public double distanceTo(Percept percept) {
        return percept.getDistance();
    }

    public int getCoveredDistance() {
        return (int)Math.round(this.myBody.getCoveredDistance());
    }

    public abstract void doIt();

    public void move() {
        this.myBody.move();
    }

    public void eat(Food food) {
        this.myBody.eat(food);
    }

    public void take(Transportable transportable) {
        this.myBody.take(transportable);
    }

    public String getTeam() {
        return this.myBody.getTeam();
    }

    public int getEnergyLevel() {
        return this.myBody.getEnergy();
    }

    public int getMaximumEnergy() {
        return this.myBody.getMaximumEnergy();
    }

    public boolean getShot() {
        return this.myBody.getShot();
    }

    protected final void receiveMessage(Message message) {
        if (!(message instanceof WarbotMessage)) {
            return;
        }
        WarbotMessage warbotMessage = (WarbotMessage)message;
        double d = warbotMessage.getFromX();
        double d2 = warbotMessage.getFromY();
        double d3 = ((BasicBody)this.getBody()).getX();
        double d4 = ((BasicBody)this.getBody()).getY();
        warbotMessage.setFromX(d - d3);
        warbotMessage.setFromY(d2 - d4);
        super.receiveMessage((Message)warbotMessage);
        ((BasicBody)this.getBody()).showLine(d3, d4, d, d2, Color.blue);
    }

    public boolean isBagEmpty() {
        return this.myBody.isMyBagEmpty();
    }

    public boolean isMyBagEmpty() {
        return this.isBagEmpty();
    }

    public boolean isBagFull() {
        return this.myBody.isMyBagFull();
    }

    public boolean isMyBagFull() {
        return this.isBagFull();
    }

    public int bagSize() {
        return this.myBody.nbOfObjectsInMyBag();
    }

    public int getBagCapacity() {
        return this.myBody.getBagCapacity();
    }

    public Percept[] getBagPercepts() {
        return this.myBody.inMyBag();
    }

    public void drop(int n) {
        this.myBody.drop(n);
    }

    public void dropAll() {
        this.myBody.dropAll();
    }

    public void createAgent(String string) {
        this.myBody.createAgent(string);
    }

    public void launchRocket(double d) {
        this.myBody.launchRocket(d);
    }

    public void buildRocket() {
        this.myBody.buildRocket();
    }

    public int getRocketNumber() {
        return this.myBody.getRocketNb();
    }

    public void setHeading(double d) {
        this.myBody.setHeading(d);
    }

    public double getHeading() {
        return this.myBody.getHeading();
    }

    public boolean isMoving() {
        return this.myBody.moving();
    }

    public Percept[] getPercepts() {
        return this.myBody.getPercepts();
    }

    public void randomHeading() {
        this.setHeading(Math.random() * 360.0);
    }

    public void showUserMessage(boolean bl) {
        this.myBody.setShowUserMessage(bl);
    }

    public void setUserMessage(String string) {
        this.myBody.setUserMessage(string);
    }

    public boolean isShowUserMessage() {
        return this.myBody.isShowUserMessage();
    }

    public int getResourceLevel() {
        return this.myBody.getResourceLevel();
    }

    public final WarbotMessage readMessage() {
        Message message = this.nextMessage();
        if (message instanceof WarbotMessage) {
            return (WarbotMessage)message;
        }
        return null;
    }

    private void installMsgCoordinates(WarbotMessage warbotMessage) {
        double d = ((BasicBody)this.getBody()).getX();
        double d2 = ((BasicBody)this.getBody()).getY();
        warbotMessage.setFromX(d);
        warbotMessage.setFromY(d2);
    }

    public final void sendMessage(String string, String string2, Message message) {
        if (message instanceof WarbotMessage) {
            this.installMsgCoordinates((WarbotMessage)message);
            super.sendMessage(string, string2, message);
        }
    }

    public final void sendMessage(AgentAddress agentAddress, Message message) {
        if (message instanceof WarbotMessage) {
            this.installMsgCoordinates((WarbotMessage)message);
            super.sendMessage(agentAddress, message);
        } else if (message instanceof ControlMessage) {
            super.sendMessage(agentAddress, message);
        }
    }

    public final void broadcastMessage(String string, String string2, Message message) {
        if (message instanceof WarbotMessage) {
            this.installMsgCoordinates((WarbotMessage)message);
            super.broadcastMessage(string, string2, message);
        }
    }

    public final void send(AgentAddress agentAddress, String string) {
        this.sendMessage(agentAddress, new WarbotMessage(string));
    }

    public final void send(AgentAddress agentAddress, String string, String string2) {
        this.sendMessage(agentAddress, new WarbotMessage(string, string2));
    }

    public final void send(AgentAddress agentAddress, String string, String string2, String string3) {
        this.sendMessage(agentAddress, new WarbotMessage(string, string2, string3));
    }

    public final void send(AgentAddress agentAddress, String string, String[] stringArray) {
        this.sendMessage(agentAddress, new WarbotMessage(string, stringArray));
    }

    public final void broadcast(String string, String string2, String string3) {
        this.broadcastMessage(string, string2, new WarbotMessage(string3));
    }

    public final void broadcast(String string, String string2, String string3, String string4) {
        this.broadcastMessage(string, string2, new WarbotMessage(string3, string4));
    }

    public final void broadcast(String string, String string2, String string3, String string4, String string5) {
        this.broadcastMessage(string, string2, new WarbotMessage(string3, string4, string5));
    }

    public final void broadcast(String string, String string2, String string3, String[] stringArray) {
        this.broadcastMessage(string, string2, new WarbotMessage(string3, stringArray));
    }
}

