/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.Viewer;
import turtlekit2.kernel.XMLAttributes;
import turtlekit2.tools.JButtonColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedViewer
extends Viewer
implements MouseListener,
MouseMotionListener,
ActionListener,
MouseWheelListener {
    XMLAttributes attrib = new XMLAttributes();
    int patchIndex = 0;
    static final int RED = 0;
    static final int GREEN = 1;
    static final int BLUE = 2;
    static final int DROP = 3;
    static final int BLACK = 4;
    int modifiedColor = 0;
    double redFactor = 255.0;
    double blueFactor = 255.0;
    double greenFactor = 255.0;
    double blackFactor = 255.0;
    double maxColoredRed = 1.0E8;
    double maxColoredGreen = 1.0E8;
    double maxColoredBlue = 1.0E8;
    double maxColoredBlack = 1.0E8;
    double quantityRed = 0.0;
    double quantityGreen = 0.0;
    double quantityBlue = 0.0;
    double quantityBlack = 0.0;
    double maxLocalColoredRed = -10000.0;
    double maxLocalColoredGreen = -10000.0;
    double maxLocalColoredBlue = -10000.0;
    double maxLocalColoredBlack = -10000.0;
    ArrayList<String> redColors = new ArrayList();
    ArrayList<String> greenColors = new ArrayList();
    ArrayList<String> blueColors = new ArrayList();
    ArrayList<String> blackColors = new ArrayList();
    String dropPher = "";
    JMenuBar menuBar;
    JMenu pheroMenu;
    JMenuItem menuItem;
    JButtonColor redb;
    JButtonColor greenb;
    JButtonColor blueb;
    JButtonColor blackb;
    JButtonColor drop;
    JButtonColor pheroButtons;
    JButtonColor turtleb;
    JFrame f = new JFrame("Custom Viewer COnfiguration");
    JLabel cord;
    JLabel factors;
    JLabel phero;
    boolean turtleDisplay = true;

    public void init() {
    }

    @Override
    public void initGUI() {
        super.initGUI();
        this.createFrame();
        this.getOnScreen().addMouseWheelListener(this);
        this.getOnScreen().addMouseListener(this);
        this.getOnScreen().addMouseMotionListener(this);
    }

    public void createFrame() {
        this.f.setSize(400, 250);
        Container container = this.f.getContentPane();
        container.setLayout(new FlowLayout());
        this.turtleb = new JButtonColor("Display Turtles");
        this.redb = new JButtonColor("Red");
        this.redb.setBackground(Color.red);
        this.redb.setBorderPainted(false);
        this.greenb = new JButtonColor("Green");
        this.greenb.setBackground(Color.green);
        this.greenb.setBorderPainted(false);
        this.blueb = new JButtonColor("Blue");
        this.blueb.setBackground(Color.blue);
        this.blueb.setBorderPainted(false);
        this.blackb = new JButtonColor("Black");
        this.blackb.setBackground(Color.black);
        this.blackb.setBorderPainted(false);
        this.drop = new JButtonColor("Drop");
        this.drop.setBackground(Color.white);
        this.drop.setBorderPainted(false);
        container.add(this.turtleb);
        container.add(this.redb);
        container.add(this.greenb);
        container.add(this.blueb);
        container.add(this.blackb);
        container.add(this.drop);
        this.cord = new JLabel("Coord X - Y", 0);
        this.factors = new JLabel("Factors", 0);
        this.phero = new JLabel("PheroQtty", 0);
        JPanel jPanel = new JPanel();
        this.f.getContentPane().add((Component)jPanel, "Center");
        jPanel.add(this.cord);
        jPanel.add(this.factors);
        jPanel.add(this.phero);
        this.turtleb.addActionListener(this);
        this.redb.addActionListener(this);
        this.greenb.addActionListener(this);
        this.blueb.addActionListener(this);
        this.blackb.addActionListener(this);
        this.drop.addActionListener(this);
        this.menuBar = new JMenuBar();
        this.pheroMenu = new JMenu("Pheromones");
        this.pheroMenu.setMnemonic(82);
        this.menuBar.add(this.pheroMenu);
        this.pheroMenu.addActionListener(this);
        this.menuItem = new JMenuItem("Null");
        this.pheroMenu.add(this.menuItem);
        this.menuItem.addActionListener(this);
        for (int i = 0; i < this.getFlavors().size(); ++i) {
            this.pheroButtons = new JButtonColor(this.getFlavorName(i));
            this.pheroMenu.add(this.menuItem);
            container.add(this.pheroButtons);
            this.menuItem.addActionListener(this);
            this.pheroButtons.addActionListener(this);
        }
        this.f.setJMenuBar(this.menuBar);
        this.f.setVisible(true);
    }

    @Override
    public void paintTurtle(Graphics graphics, Turtle turtle, int n, int n2, int n3) {
        if (this.turtleDisplay) {
            graphics.setColor(turtle.getColor());
            graphics.fillRect(n, n2, n3, n3);
        }
    }

    @Override
    public void paintPatch(Graphics graphics, Patch patch, int n, int n2, int n3) {
        this.quantityRed = 0.0;
        this.quantityGreen = 0.0;
        this.quantityBlue = 0.0;
        this.quantityBlack = 0.0;
        try {
            int n4;
            if (this.redColors.size() > 0) {
                for (n4 = 0; n4 < this.redColors.size(); ++n4) {
                    this.quantityRed += patch.getVariableValue(this.redColors.get(n4));
                }
                if (this.quantityRed > this.maxLocalColoredRed) {
                    this.maxLocalColoredRed = this.quantityRed;
                }
                this.quantityRed = this.quantityRed / (this.maxColoredRed + 1.0) * this.redFactor;
                if (this.quantityRed > 255.0) {
                    this.quantityRed = 255.0;
                }
                if (this.quantityRed < 0.0) {
                    this.quantityRed = 0.0;
                }
            } else {
                this.quantityRed = 0.0;
            }
            if (this.greenColors.size() > 0) {
                for (n4 = 0; n4 < this.greenColors.size(); ++n4) {
                    this.quantityGreen += patch.getVariableValue(this.greenColors.get(n4));
                }
                if (this.quantityGreen > this.maxLocalColoredGreen) {
                    this.maxLocalColoredGreen = this.quantityGreen;
                }
                this.quantityGreen = this.quantityGreen / (this.maxColoredGreen + 1.0) * this.greenFactor;
                if (this.quantityGreen > 255.0) {
                    this.quantityGreen = 255.0;
                }
                if (this.quantityGreen < 0.0) {
                    this.quantityGreen = 0.0;
                }
            } else {
                this.quantityGreen = 0.0;
            }
            if (this.blueColors.size() > 0) {
                for (n4 = 0; n4 < this.blueColors.size(); ++n4) {
                    this.quantityBlue += patch.getVariableValue(this.blueColors.get(n4));
                }
                if (this.quantityBlue > this.maxLocalColoredBlue) {
                    this.maxLocalColoredBlue = this.quantityBlue;
                }
                this.quantityBlue = this.quantityBlue / (this.maxColoredBlue + 1.0) * this.blueFactor;
                if (this.quantityBlue > 255.0) {
                    this.quantityBlue = 255.0;
                }
                if (this.quantityBlue < 0.0) {
                    this.quantityBlue = 0.0;
                }
            } else {
                this.quantityBlue = 0.0;
            }
            if (this.blackColors.size() > 0) {
                for (n4 = 0; n4 < this.blackColors.size(); ++n4) {
                    this.quantityBlack += patch.getVariableValue(this.blackColors.get(n4));
                }
                if (this.quantityBlack > this.maxLocalColoredBlack) {
                    this.maxLocalColoredBlack = this.quantityBlack;
                }
                this.quantityBlack = this.quantityBlack / (this.maxColoredBlack + 1.0) * this.blackFactor;
                if (this.quantityBlack > 255.0) {
                    this.quantityBlack = 255.0;
                }
                if (this.quantityBlack < 0.0) {
                    this.quantityBlack = 0.0;
                }
            } else {
                this.quantityBlack = 0.0;
            }
            this.quantityRed -= this.quantityBlack;
            this.quantityGreen -= this.quantityBlack;
            this.quantityBlue -= this.quantityBlack;
            if (this.quantityRed < 0.0) {
                this.quantityRed = 0.0;
            }
            if (this.quantityGreen < 0.0) {
                this.quantityGreen = 0.0;
            }
            if (this.quantityBlue < 0.0) {
                this.quantityBlue = 0.0;
            }
            graphics.setColor(new Color((int)this.quantityRed, (int)this.quantityGreen, (int)this.quantityBlue));
            graphics.fillRect(n, n2, n3, n3);
            if (n == 0 && n2 == 0) {
                this.maxColoredRed = this.maxLocalColoredRed;
                this.maxLocalColoredRed = -100000.0;
                this.maxColoredGreen = this.maxLocalColoredGreen;
                this.maxLocalColoredGreen = -100000.0;
                this.maxColoredBlue = this.maxLocalColoredBlue;
                this.maxLocalColoredBlue = -100000.0;
                this.maxColoredBlack = this.maxLocalColoredBlack;
                this.maxLocalColoredBlack = -100000.0;
            }
        }
        catch (Exception exception) {
            System.err.println("Error Viewer " + exception);
        }
    }

    public void updateColorList(ArrayList<String> arrayList, String string) {
        if (arrayList.contains(string)) {
            arrayList.remove(string);
        } else {
            arrayList.add(string);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.turtleb) {
            this.turtleDisplay = !this.turtleDisplay;
        } else if (object == this.redb) {
            this.modifiedColor = 0;
        } else if (object == this.greenb) {
            this.modifiedColor = 1;
        } else if (object == this.blueb) {
            this.modifiedColor = 2;
        } else if (object == this.blackb) {
            this.modifiedColor = 4;
        } else if (object == this.drop) {
            this.modifiedColor = 3;
        } else if (this.flavorsContains(actionEvent.getActionCommand())) {
            if (this.modifiedColor == 0) {
                this.updateColorList(this.redColors, actionEvent.getActionCommand());
                ((JButtonColor)object).switchColor(0);
            } else if (this.modifiedColor == 1) {
                this.updateColorList(this.greenColors, actionEvent.getActionCommand());
                ((JButtonColor)object).switchColor(1);
            } else if (this.modifiedColor == 2) {
                this.updateColorList(this.blueColors, actionEvent.getActionCommand());
                ((JButtonColor)object).switchColor(2);
            } else if (this.modifiedColor == 4) {
                this.updateColorList(this.blackColors, actionEvent.getActionCommand());
                ((JButtonColor)object).switchColor(4);
            } else if (this.modifiedColor == 3) {
                this.dropPher = actionEvent.getActionCommand();
                this.drop.setText("Actual Drop:" + this.dropPher);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.getCellSize();
        int n2 = mouseEvent.getY() / this.getCellSize();
        if (this.flavorsContains(this.dropPher)) {
            this.patchGrid[n][this.envHeight - n2].incrementPatchVariable(this.dropPher, 1000.0);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.cord.setText("X:" + mouseEvent.getX() / this.getCellSize() + " Y:" + mouseEvent.getY() / this.getCellSize());
        if (!this.dropPher.equals("") && !this.dropPher.equals(null)) {
            this.phero.setText(new Double(this.patchGrid[mouseEvent.getX() / this.getCellSize()][this.envHeight - mouseEvent.getY() / this.getCellSize()].getVariableValue(this.dropPher)).toString());
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (this.modifiedColor == 0) {
            this.redFactor += (double)(n * 20);
        } else if (this.modifiedColor == 1) {
            this.greenFactor += (double)(n * 20);
        } else if (this.modifiedColor == 2) {
            this.blueFactor += (double)(n * 20);
        } else if (this.modifiedColor == 4) {
            this.blackFactor += (double)(n * 20);
        }
        this.factors.setText("R:" + this.redFactor + " G:" + this.greenFactor + " B:" + this.blueFactor + " Bl:" + this.blackFactor);
    }
}

