/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.pheromone;

import turtlekit2.kernel.TurtleEnvironment;
import turtlekit2.pheromone.GridVariable;

public class Pheromone {
    int time = 0;
    int epicenterX;
    int epicenterY;
    double remainingPower;
    double radius = 0.0;
    boolean[][] marked;
    GridVariable myVariable;
    protected TurtleEnvironment env;

    public Pheromone(TurtleEnvironment turtleEnvironment, String string, int n, int n2, double d) {
        this.env = turtleEnvironment;
        this.epicenterX = n;
        this.epicenterY = n2;
        this.remainingPower = d;
        this.marked = new boolean[turtleEnvironment.x][turtleEnvironment.y];
        this.myVariable = turtleEnvironment.gridVariables.get(string);
        if (this.myVariable == null) {
            this.myVariable = new GridVariable(turtleEnvironment);
            turtleEnvironment.gridVariables.put(string, this.myVariable);
        }
        turtleEnvironment.pheromones.add(this);
        for (int i = 0; i < turtleEnvironment.x; ++i) {
            for (int j = 0; j < turtleEnvironment.y; ++j) {
                this.marked[i][j] = false;
            }
        }
    }

    public boolean diffusion() {
        this.radius += 1.0;
        double d = this.radius;
        this.remainingPower *= 0.5;
        if (this.remainingPower < 0.01) {
            return true;
        }
        for (double d2 = 0.0; d2 <= d; d2 += 1.0) {
            int n = this.normeX((int)d2 + this.epicenterX);
            int n2 = this.normeY((int)d + this.epicenterY);
            int n3 = this.normeX((int)(-d2) + this.epicenterX);
            int n4 = this.normeY((int)(-d) + this.epicenterY);
            this.putPheromone(n, n2);
            this.putPheromone(n, n4);
            this.putPheromone(n3, n2);
            this.putPheromone(n3, n4);
            n = this.normeX((int)d2 + this.epicenterY);
            n2 = this.normeY((int)d + this.epicenterX);
            n3 = this.normeX((int)(-d2) + this.epicenterY);
            n4 = this.normeY((int)(-d) + this.epicenterX);
            this.putPheromone(n2, n);
            this.putPheromone(n2, n3);
            this.putPheromone(n4, n);
            this.putPheromone(n4, n3);
            d = Math.sqrt(this.radius * this.radius - d2 * d2);
        }
        return false;
    }

    final void putPheromone(int n, int n2) {
        if (!this.marked[n][n2]) {
            this.myVariable.addValue(n, n2, this.remainingPower);
            this.marked[n][n2] = true;
            this.env.grid[n][n2].change = true;
        }
    }

    final double normeX(double d) {
        if (this.env.wrap) {
            if (d > (double)this.env.x) {
                return d % (double)this.env.x;
            }
            if (d < 0.0) {
                return d + (double)this.env.x;
            }
            return d;
        }
        if (d >= (double)this.env.x - 0.5) {
            return this.env.x - 1;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    final double normeY(double d) {
        if (this.env.wrap) {
            if (d > (double)this.env.y) {
                return d % (double)this.env.y;
            }
            if (d < 0.0) {
                return d + (double)this.env.y;
            }
            return d;
        }
        if (d >= (double)this.env.y - 0.5) {
            return this.env.y - 1;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    final int normeX(int n) {
        if (this.env.wrap) {
            if ((n %= this.env.x) < 0) {
                return n + this.env.x;
            }
            return n;
        }
        if (n >= this.env.x) {
            return this.env.x - 1;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    final int normeY(int n) {
        if (this.env.wrap) {
            if ((n %= this.env.y) < 0) {
                return n + this.env.y;
            }
            return n;
        }
        if (n >= this.env.y) {
            return this.env.y - 1;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }
}

