/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.pheromone;

import turtlekit2.kernel.Patch;
import turtlekit2.kernel.TurtleEnvironment;

public class GridVariable {
    double evaporationCoef = 0.0;
    double diffusionCoef = 0.0;
    public final double[][] gridValues;
    protected final TurtleEnvironment env;

    public GridVariable(TurtleEnvironment turtleEnvironment) {
        this.env = turtleEnvironment;
        this.gridValues = new double[turtleEnvironment.x][turtleEnvironment.y];
        this.setDefaultValue(0.0);
    }

    public void setEvapCoef(double d) {
        if (d < 0.0 || d > 1.0) {
            System.err.println("You should set correctly the evapCoef (0<=ec<=1)");
        }
        this.evaporationCoef = d;
    }

    public void setDiffuseCoef(double d) {
        if (d < 0.0 || d > 1.0) {
            System.err.println("You should set correctly the diffuseCoef (0<=ec<=1)");
        }
        this.diffusionCoef = d;
    }

    public final void setDefaultValue(double d) {
        for (int i = this.env.x - 1; i >= 0; --i) {
            for (int j = this.env.y - 1; j >= 0; --j) {
                this.gridValues[i][j] = d;
            }
        }
    }

    public double getValue(int n, int n2) {
        return this.gridValues[n][n2];
    }

    public void setValue(int n, int n2, double d) {
        this.gridValues[n][n2] = d;
    }

    public void addValue(int n, int n2, double d) {
        double[] dArray = this.gridValues[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public void diffusion() {
        block9: {
            int n;
            int n2;
            if (this.diffusionCoef == 0.0) break block9;
            if (this.env.wrap) {
                double d = this.diffusionCoef / 8.0;
                for (int i = this.env.x - 1; i >= 0; --i) {
                    n2 = this.env.y - 1;
                    while (n2 >= 0) {
                        double d2 = this.gridValues[i][n2];
                        this.env.grid[i][n2].diffusion = d2 * d;
                        double[] dArray = this.gridValues[i];
                        int n3 = n2--;
                        dArray[n3] = dArray[n3] - d2 * this.diffusionCoef;
                    }
                }
            } else {
                for (int i = this.env.x - 1; i >= 0; --i) {
                    for (n = this.env.y - 1; n >= 0; --n) {
                        this.env.grid[i][n].diffusion = this.gridValues[i][n] * (this.diffusionCoef / (double)this.env.grid[i][n].neighbors.length);
                        double[] dArray = this.gridValues[i];
                        int n4 = n;
                        dArray[n4] = dArray[n4] - this.gridValues[i][n] * this.diffusionCoef;
                    }
                }
            }
            for (int i = this.env.x - 1; i >= 0; --i) {
                for (n = this.env.y - 1; n >= 0; --n) {
                    Patch[] patchArray = this.env.grid[i][n].neighbors;
                    for (n2 = patchArray.length - 1; n2 >= 0; --n2) {
                        double[] dArray = this.gridValues[i];
                        int n5 = n;
                        dArray[n5] = dArray[n5] + patchArray[n2].diffusion;
                    }
                }
            }
        }
    }

    public double[][] getAllValues() {
        return this.gridValues;
    }

    public void evaporation() {
        for (int i = this.env.x - 1; i >= 0; --i) {
            for (int j = this.env.y - 1; j >= 0; --j) {
                double[] dArray = this.gridValues[i];
                int n = j;
                dArray[n] = dArray[n] - this.gridValues[i][j] * this.evaporationCoef;
            }
        }
    }
}

