/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import madkit.kernel.AbstractAgent;
import madkit.kernel.ReferenceableAgent;
import turtlekit2.kernel.Patch;
import turtlekit2.kernel.TurtleEnvironment;
import turtlekit2.kernel.XMLAttributes;
import turtlekit2.pheromone.Pheromone;

public class Turtle
extends AbstractAgent
implements ReferenceableAgent {
    public static final int East = 0;
    public static final int NorthEast = 45;
    public static final int North = 90;
    public static final int NorthWest = 135;
    public static final int West = 180;
    public static final int SouthWest = 225;
    public static final int South = 270;
    public static final int SouthEast = 315;
    private double angle;
    private double x;
    private double y;
    private double angleCos = 1.0;
    private double angleSin = 0.0;
    private int who;
    boolean hidden = false;
    private TurtleEnvironment world;
    private String initMethod;
    private List<String> rolePlayed;
    private XMLAttributes attrib;
    Method nextAction = null;
    Color color = Color.red;
    Patch position;

    public Turtle() {
        this.initMethod = "defaultAction";
        this.randomHeading();
    }

    public Turtle(String string) {
        this.initMethod = string;
    }

    final void setNextAction(Method method) {
        if (method == null) {
            this.die();
        } else {
            this.nextAction = method;
        }
    }

    public final String defaultAction() {
        return "defaultAction";
    }

    final void initialisation(int n, int n2, TurtleEnvironment turtleEnvironment, int n3, Patch patch) {
        this.world = turtleEnvironment;
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(this.initMethod, new Class[0]);
            this.setNextAction(method);
        }
        catch (Exception exception) {
            System.err.println("Can't find method: " + this.initMethod + "\n");
            exception.printStackTrace();
        }
        this.who = n3;
        this.position = patch;
        this.x = n;
        this.y = n2;
    }

    public void activate() {
        this.requestRole("Tkit", this.getSimulationGroup(), "turtle", null);
        this.setup();
    }

    public void end() {
        this.leaveGroup("Tkit", this.getSimulationGroup());
    }

    public void setup() {
    }

    public final void die() {
        this.world.removeTurtle(this);
    }

    public void setAttributes(XMLAttributes xMLAttributes) {
        this.attrib = xMLAttributes;
    }

    public XMLAttributes getAttributes() {
        return this.attrib;
    }

    final double normeX(double d) {
        if (this.world.wrap) {
            if (d > (double)this.world.x) {
                return d % (double)this.world.x;
            }
            if (d < 0.0) {
                return d + (double)this.world.x;
            }
            return d;
        }
        if (d >= (double)this.world.x - 0.5) {
            return this.world.x - 1;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    final double normeY(double d) {
        if (this.world.wrap) {
            if (d > (double)this.world.y) {
                return d % (double)this.world.y;
            }
            if (d < 0.0) {
                return d + (double)this.world.y;
            }
            return d;
        }
        if (d >= (double)this.world.y - 0.5) {
            return this.world.y - 1;
        }
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    final int normeX(int n) {
        if (this.world.wrap) {
            if ((n %= this.world.x) < 0) {
                return n + this.world.x;
            }
            return n;
        }
        if (n >= this.world.x) {
            return this.world.x - 1;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    final int normeY(int n) {
        if (this.world.wrap) {
            if ((n %= this.world.y) < 0) {
                return n + this.world.y;
            }
            return n;
        }
        if (n >= this.world.y) {
            return this.world.y - 1;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public String toString() {
        return "turtle " + this.who + " at " + this.xcor() + " " + this.ycor() + " : heading=" + this.angle + ",color=" + this.color;
    }

    public String getSimulationGroup() {
        return this.world.simulationGroup;
    }

    public final void playRole(String string) {
        if (this.rolePlayed == null) {
            this.rolePlayed = new ArrayList<String>();
        }
        this.rolePlayed.add(string);
        this.requestRole("Tkit", this.getSimulationGroup(), string, null);
    }

    public final boolean isPlayingRole(String string) {
        return this.rolePlayed != null && this.rolePlayed.contains(string);
    }

    public final void giveUpRole(String string) {
        this.leaveRole("Tkit", this.getSimulationGroup(), string);
        if (this.rolePlayed != null) {
            this.rolePlayed.remove(string);
        }
    }

    public final double getHeading() {
        return this.angle;
    }

    public final void setHeading(double d) {
        this.angle = d % 360.0;
        if (this.angle < 0.0) {
            this.angle += 360.0;
        }
        this.angleSin = Math.sin(Math.PI * this.angle / 180.0);
        this.angleCos = Math.cos(Math.PI * this.angle / 180.0);
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public final boolean getHidden() {
        return this.hidden;
    }

    public final void setPatchColor(Color color) {
        this.position.setColor(color);
    }

    public final Color getPatchColor() {
        return this.position.color;
    }

    public final Color getPatchColorAt(int n, int n2) {
        return this.world.getPatchColor(this.normeX(n + this.xcor()), this.normeY(n2 + this.ycor()));
    }

    public final void setPatchColorAt(Color color, int n, int n2) {
        this.world.setPatchColor(color, this.normeX(n + this.xcor()), this.normeY(n2 + this.ycor()));
    }

    public final void fd(int n) {
        this.moveTo(this.x + this.angleCos * (double)n, this.y + this.angleSin * (double)n);
    }

    public final void bk(int n) {
        this.moveTo(this.x - this.angleCos * (double)n, this.y - this.angleSin * (double)n);
    }

    public final void moveTo(double d, double d2) {
        this.x = this.normeX(d);
        this.y = this.normeY(d2);
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final void moveTo(int n, int n2) {
        this.x = this.normeX(n);
        this.y = this.normeY(n2);
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final void home() {
        this.x = this.world.x / 2;
        this.y = this.world.y / 2;
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final void setX(double d) {
        this.x = this.normeX(d);
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final void setY(double d) {
        this.y = this.normeY(d);
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final void setXY(double d, double d2) {
        this.x = this.normeX(d);
        this.y = this.normeY(d2);
        this.world.moveTurtle(this.x, this.y, this);
    }

    public final double distanceNowrap(double d, double d2) {
        d = this.normeX(d);
        d2 = this.normeY(d2);
        return Math.sqrt((d -= this.x) * d + (d2 -= this.y) * d2);
    }

    public final double distance(double d, double d2) {
        if (!this.world.wrap) {
            return this.distanceNowrap(d, d2);
        }
        d = this.normeX(d);
        d2 = this.normeY(d2);
        if (Math.abs(d - this.x) > (double)(this.world.x / 2)) {
            d = d < this.x ? (d += (double)this.world.x) : (d -= (double)this.world.x);
        }
        if (Math.abs(d2 - this.y) > (double)(this.world.y / 2)) {
            d2 = d2 < this.y ? (d2 += (double)this.world.y) : (d2 -= (double)this.world.y);
        }
        return Math.sqrt((d -= this.x) * d + (d2 -= this.y) * d2);
    }

    public final double towardsNowrap(double d, double d2) {
        d = this.normeX(d);
        d2 = this.normeY(d2);
        if ((d -= this.x) == 0.0 && (d2 -= this.y) == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 180.0 * Math.asin(d / Math.sqrt(d * d + d2 * d2)) / Math.PI + 270.0;
        }
        return 180.0 * Math.acos(d / Math.sqrt(d * d + d2 * d2)) / Math.PI;
    }

    public final double towards(double d, double d2) {
        if (!this.world.wrap) {
            return this.towardsNowrap(d, d2);
        }
        if (this.distance(d, d2) > this.distanceNowrap(d, d2)) {
            return this.towardsNowrap(d, d2);
        }
        d = this.normeX(d);
        d2 = this.normeY(d2);
        if (Math.abs(d - this.x) > (double)(this.world.x / 2)) {
            d = d < this.x ? (d += (double)this.world.x) : (d -= (double)this.world.x);
        }
        if (Math.abs(d2 - this.y) > (double)(this.world.y / 2)) {
            d2 = d2 < this.y ? (d2 += (double)this.world.y) : (d2 -= (double)this.world.y);
        }
        if ((d -= this.x) == 0.0 && (d2 -= this.y) == 0.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 180.0 * Math.asin(d / Math.sqrt(d * d + d2 * d2)) / Math.PI + 270.0;
        }
        return 180.0 * Math.acos(d / Math.sqrt(d * d + d2 * d2)) / Math.PI;
    }

    public final void randomHeading() {
        this.setHeading(Math.random() * 360.0);
    }

    public final int createTurtle(Turtle turtle) {
        return this.world.addAgent(turtle, this.xcor(), this.ycor());
    }

    public final int xcor() {
        return (int)Math.round(this.x);
    }

    public final int ycor() {
        return (int)Math.round(this.y);
    }

    public final double realX() {
        return this.x;
    }

    public final double realY() {
        return this.y;
    }

    public final Turtle getTurtleWithID(int n) {
        return this.world.getTurtleWithID(n);
    }

    public final int dx() {
        return (int)(Math.round(this.x + this.angleCos) - Math.round(this.x));
    }

    public final int dy() {
        return (int)(Math.round(this.y + this.angleSin) - Math.round(this.y));
    }

    public final void turnRight(double d) {
        this.angle -= d;
        this.setHeading(this.angle);
    }

    public final void turnLeft(double d) {
        this.angle += d;
        this.setHeading(this.angle);
    }

    public final Turtle[] turtlesHere() {
        return this.position.getOtherTurtles(this);
    }

    public final Turtle[] turtlesAt(int n, int n2) {
        return this.world.turtlesAt(this.normeX(n + this.xcor()), this.normeY(n2 + this.ycor()));
    }

    public final int countTurtlesHere() {
        return this.position.turtlesHere.size();
    }

    public final int countTurtlesAt(int n, int n2) {
        return this.world.turtlesCountAt(this.normeX(n + this.xcor()), this.normeY(n2 + this.ycor()));
    }

    public final int mySelf() {
        return this.who;
    }

    public final int getWorldWidth() {
        return this.world.x;
    }

    public final int getWorldHeight() {
        return this.world.y;
    }

    public final double getPatchVariable(String string) {
        return this.position.getVariableValue(string);
    }

    public final void setPatchVariable(String string, double d) {
        this.position.setPatchVariable(string, d);
    }

    public final double getPatchVariableAt(String string, int n, int n2) {
        return this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].getVariableValue(string);
    }

    public final void setPatchVariableAt(String string, double d, int n, int n2) {
        this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].setPatchVariable(string, d);
    }

    public final void incrementPatchVariable(String string, double d) {
        this.position.incrementPatchVariable(string, d);
    }

    public final void incrementPatchVariableAt(String string, double d, int n, int n2) {
        this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].incrementPatchVariable(string, d);
    }

    public final Object getMark(String string) {
        return this.position.getMark(string);
    }

    public final Object getMarkAt(String string, int n, int n2) {
        return this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].getMark(string);
    }

    public final void dropMark(String string, Object object) {
        this.position.dropMark(string, object);
    }

    public final void dropMarkAt(String string, Object object, int n, int n2) {
        this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].dropMark(string, object);
    }

    public final boolean isMarkPresent(String string) {
        return this.position.isMarkPresent(string);
    }

    public final boolean isMarkPresentAt(String string, int n, int n2) {
        return this.world.grid[this.normeX(n + this.xcor())][this.normeY(n2 + this.ycor())].isMarkPresent(string);
    }

    public void emitPheromone(String string, double d) {
        new Pheromone(this.world, string, this.xcor(), this.ycor(), d);
    }
}

