/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import turtlekit2.kernel.Launcher;
import turtlekit2.kernel.XMLAttributes;

public class TabbedLauncherPanel
extends JPanel
implements TreeSelectionListener {
    Document document;
    String configPath;
    boolean compress = true;
    File configFile;
    AdapterNode displayedNode;
    static final int windowHeight = 460;
    static final int leftWidth = 300;
    static final int rightWidth = 340;
    static final int windowWidth = 640;
    Launcher launcher;
    private JButton addButton;
    private JButton commitButton;
    private JPanel editButtonPanel;
    private JPanel editPanel;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JTree jTree1;
    private JButton launchButton;
    private JButton remButton;
    private JButton resetButton;
    private JPanel rightPanel;
    private JButton saveButton;
    private JPanel textBoxPanel;
    static final String[] typeName = new String[]{"none", "Element", "Attr", "Text", "CDATA", "EntityRef", "Entity", "ProcInstr", "Comment", "Document", "DocType", "DocFragment", "Notation"};
    static final int ELEMENT_TYPE = 1;
    static final int ATTR_TYPE = 2;
    static final int TEXT_TYPE = 3;
    static final int CDATA_TYPE = 4;
    static final int ENTITYREF_TYPE = 5;
    static final int ENTITY_TYPE = 6;
    static final int PROCINSTR_TYPE = 7;
    static final int COMMENT_TYPE = 8;
    static final int DOCUMENT_TYPE = 9;
    static final int DOCTYPE_TYPE = 10;
    static final int DOCFRAG_TYPE = 11;
    static final int NOTATION_TYPE = 12;
    static final String[] treeElementNames = new String[]{"Simulations", "Simulation", "Flavors", "RandomFlavors", "Flavor", "Pools", "Pool", "Gene", "Agents", "Agent", "Parameters", "Managers", "Manager", "Viewers", "Viewer", "Observers", "Observer"};

    public TabbedLauncherPanel(String string, Launcher launcher) {
        this.configPath = string;
        this.launcher = launcher;
        this.initComponents();
        this.initXmlParsing();
        this.jSplitPane1.setRightComponent(launcher.getOnScreen());
    }

    private void initXmlParsing() {
        Serializable serializable;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.configFile = new File(this.configPath);
            object = documentBuilderFactory.newDocumentBuilder();
            this.document = ((DocumentBuilder)object).parse(this.configFile);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            serializable = sAXParseException;
            if (sAXParseException.getException() != null) {
                serializable = sAXParseException.getException();
            }
            ((Throwable)serializable).printStackTrace();
        }
        catch (SAXException sAXException) {
            serializable = sAXException;
            if (sAXException.getException() != null) {
                serializable = sAXException.getException();
            }
            ((Throwable)serializable).printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.jTree1 = object = new JTree(new DomToTreeModelAdapter());
        serializable = new JScrollPane(this.jTree1);
        ((JComponent)serializable).setPreferredSize(new Dimension(300, 460));
        this.jSplitPane2.setLeftComponent(this.jTree1);
        this.jTree1.addTreeSelectionListener(this);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jTree1 = new JTree();
        this.editPanel = new JPanel();
        this.jSplitPane3 = new JSplitPane();
        this.editButtonPanel = new JPanel();
        this.saveButton = new JButton();
        this.remButton = new JButton();
        this.addButton = new JButton();
        this.launchButton = new JButton();
        this.resetButton = new JButton();
        this.commitButton = new JButton();
        this.textBoxPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setAutoscrolls(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(0, 0));
        this.jSplitPane2.setDividerSize(10);
        this.jSplitPane2.setAutoscrolls(true);
        this.jSplitPane2.setMinimumSize(new Dimension(492, 382));
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jTree1.setMaximumSize(new Dimension(200, 100));
        this.jTree1.setMinimumSize(new Dimension(50, 50));
        this.jTree1.setPreferredSize(new Dimension(354, 548));
        this.jTree1.setRootVisible(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TabbedLauncherPanel.this.jTree1MouseClicked(mouseEvent);
            }
        });
        this.jSplitPane2.setLeftComponent(this.jTree1);
        this.editPanel.setLayout(new BorderLayout());
        this.editPanel.setAlignmentX(0.0f);
        this.editPanel.setAlignmentY(0.0f);
        this.editPanel.setAutoscrolls(true);
        this.editPanel.setMaximumSize(new Dimension(0, 0));
        this.editPanel.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane3.setOrientation(0);
        this.editButtonPanel.setLayout(new GridLayout(1, 0));
        this.saveButton.setText("Save simulation config");
        this.saveButton.setAutoscrolls(true);
        this.saveButton.setMaximumSize(new Dimension(20, 35));
        this.saveButton.setMinimumSize(new Dimension(20, 35));
        this.saveButton.setPreferredSize(new Dimension(20, 30));
        this.saveButton.setRequestFocusEnabled(false);
        this.saveButton.setVerticalAlignment(1);
        this.saveButton.setVerticalTextPosition(1);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.saveButton);
        this.remButton.setText("removeNode");
        this.remButton.setVerticalAlignment(1);
        this.remButton.setVerticalTextPosition(1);
        this.remButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.remButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.remButton);
        this.addButton.setText("addNode");
        this.addButton.setVerticalAlignment(1);
        this.addButton.setVerticalTextPosition(1);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.addButton);
        this.addButton.getAccessibleContext().setAccessibleName("addButton");
        this.launchButton.setText("Launch");
        this.launchButton.setName("Launch");
        this.launchButton.setVerifyInputWhenFocusTarget(false);
        this.launchButton.setVerticalAlignment(1);
        this.launchButton.setVerticalTextPosition(1);
        this.launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.launchButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.launchButton);
        this.resetButton.setText("Reset config");
        this.resetButton.setAutoscrolls(true);
        this.resetButton.setPreferredSize(new Dimension(30, 35));
        this.resetButton.setVerticalAlignment(1);
        this.resetButton.setVerticalTextPosition(1);
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.resetButton);
        this.commitButton.setText("Commit");
        this.commitButton.setVerticalAlignment(1);
        this.commitButton.setVerticalTextPosition(1);
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabbedLauncherPanel.this.commitButtonActionPerformed(actionEvent);
            }
        });
        this.editButtonPanel.add(this.commitButton);
        this.jSplitPane3.setTopComponent(this.editButtonPanel);
        this.textBoxPanel.setLayout(new GridLayout(0, 2, 30, 10));
        this.jSplitPane3.setRightComponent(this.textBoxPanel);
        this.editPanel.add((Component)this.jSplitPane3, "Center");
        this.jSplitPane2.setRightComponent(this.editPanel);
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.jSplitPane1.setRightComponent(this.rightPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void commitButtonActionPerformed(ActionEvent actionEvent) {
        this.launcher.setSimulationNode(this.document.getDocumentElement());
    }

    private void launchButtonActionPerformed(ActionEvent actionEvent) {
        if (this.jTree1.getModel().isLeaf(this.displayedNode)) {
            Element element = (Element)this.displayedNode.getNode();
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            XMLAttributes xMLAttributes = new XMLAttributes();
            for (int i = 0; i < n; ++i) {
                xMLAttributes.put(namedNodeMap.item(i).getNodeName(), element.getAttribute(namedNodeMap.item(i).getNodeName()));
            }
            String string = this.displayedNode.getNode().getNodeName();
            if (string.equals("Observer")) {
                this.launcher.newObserver(xMLAttributes);
            } else if (string.equals("Viewer")) {
                this.launcher.newViewer(xMLAttributes);
            } else if (string.equals("Parameters")) {
                String string2 = new Integer(this.getIndex(this.displayedNode.getNode().getParentNode().getParentNode())).toString() + new Integer(this.getIndex(this.displayedNode.getNode().getParentNode())).toString();
                xMLAttributes.put("node", string2);
                xMLAttributes.put("groupNode", new Integer(this.getIndex(this.displayedNode.getNode().getParentNode().getParentNode())).toString());
                xMLAttributes.put("agentType", ((Element)this.displayedNode.getNode().getParentNode()).getAttribute("agentType"));
                System.out.println(string2);
                this.launcher.newAgents(xMLAttributes, 1);
            } else if (string.equals("Gene")) {
                System.out.println("Cannot be instancied dynamically yet.");
            }
        } else {
            String string = this.displayedNode.getNode().getNodeName();
            if (string.equals("Observers")) {
                NodeList nodeList = ((Element)this.displayedNode.getNode()).getElementsByTagName("Observer");
                this.launcher.initializeObservers(nodeList);
            } else if (string.equals("Viewers")) {
                NodeList nodeList = ((Element)this.displayedNode.getNode()).getElementsByTagName("Viewer");
                this.launcher.initializeViewers(nodeList);
            } else if (string.equals("Agents")) {
                NodeList nodeList = ((Element)this.displayedNode.getNode()).getElementsByTagName("Agent");
                this.launcher.createInitialPopulation(nodeList, this.getIndex(this.displayedNode.getNode()));
            } else if (string.equals("Agent")) {
                Element element = (Element)this.displayedNode.getNode();
                String string3 = element.getAttribute("agentType");
                int n = Integer.parseInt(element.getAttribute("nbAgents"));
                NodeList nodeList = element.getElementsByTagName("Parameters");
                Element element2 = (Element)nodeList.item(0);
                NamedNodeMap namedNodeMap = element2.getAttributes();
                int n2 = namedNodeMap.getLength();
                XMLAttributes xMLAttributes = new XMLAttributes();
                for (int i = 0; i < n2; ++i) {
                    xMLAttributes.put(namedNodeMap.item(i).getNodeName(), element2.getAttribute(namedNodeMap.item(i).getNodeName()));
                }
                String string4 = new Integer(this.getIndex(this.displayedNode.getNode().getParentNode())).toString() + new Integer(this.getIndex(this.displayedNode.getNode())).toString();
                xMLAttributes.put("node", string4);
                xMLAttributes.put("groupNode", new Integer(this.getIndex(this.displayedNode.getNode().getParentNode())).toString());
                xMLAttributes.put("agentType", string3);
                this.launcher.newAgents(xMLAttributes, n);
            } else if (string.equals("Pool")) {
                System.out.println("Cannot be instancied dynamically yet.");
            } else if (string.equals("Pools")) {
                System.out.println("Cannot be instancied dynamically yet.");
            }
        }
        this.launcher.launch(this.displayedNode.getNode());
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Node node = this.displayedNode.getNode().cloneNode(true);
        this.displayedNode.getNode().getParentNode().appendChild(node);
    }

    private void remButtonActionPerformed(ActionEvent actionEvent) {
        this.displayedNode.getNode().getParentNode().removeChild(this.displayedNode.getNode());
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        this.saveXml(this.configFile);
    }

    public void saveXml(File file) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(this.document), new StreamResult(byteArrayOutputStream));
            FileWriter fileWriter = new FileWriter(file, false);
            DOMSource dOMSource = new DOMSource(this.document);
            fileWriter.write(byteArrayOutputStream.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            System.err.println("A l'arrache: problemes d'ecritures" + exception);
        }
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.initXmlParsing();
        this.textBoxPanel.removeAll();
    }

    private void jTree1MouseClicked(MouseEvent mouseEvent) {
    }

    boolean treeElement(String string) {
        for (int i = 0; i < treeElementNames.length; ++i) {
            if (!string.equals(treeElementNames[i])) continue;
            return true;
        }
        return false;
    }

    public int getIndex(Node node) {
        Element element = (Element)node.getParentNode();
        NodeList nodeList = element.getElementsByTagName(node.getNodeName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 != node) continue;
            return i;
        }
        return 0;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath != null) {
            AdapterNode adapterNode = (AdapterNode)treePath.getLastPathComponent();
            adapterNode.content();
        }
    }

    public class DomToTreeModelAdapter
    implements TreeModel {
        private Vector listenerList = new Vector();

        public Object getRoot() {
            return new AdapterNode(TabbedLauncherPanel.this.document);
        }

        public boolean isLeaf(Object object) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.childCount() <= 0;
        }

        public int getChildCount(Object object) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.childCount();
        }

        public Object getChild(Object object, int n) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.child(n);
        }

        public int getIndexOfChild(Object object, Object object2) {
            AdapterNode adapterNode = (AdapterNode)object;
            return adapterNode.index((AdapterNode)object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null && !this.listenerList.contains(treeModelListener)) {
                this.listenerList.addElement(treeModelListener);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null) {
                this.listenerList.removeElement(treeModelListener);
            }
        }

        public void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }

    public class AdapterNode {
        Node domNode;
        XMLAttributes xmlTable;
        Hashtable key_value = new Hashtable();
        Hashtable value_key = new Hashtable();
        Hashtable stringValue_key = new Hashtable();
        Hashtable stringKey_value = new Hashtable();
        Hashtable keyRemove = new Hashtable();

        public AdapterNode(Node node) {
            this.domNode = node;
        }

        public String toString() {
            String string = "";
            String string2 = this.domNode.getNodeName();
            if (!string2.startsWith("#")) {
                string = string + " " + string2;
            }
            if (TabbedLauncherPanel.this.compress) {
                String string3 = this.domNode.toString().trim();
                int n = string3.indexOf("\n");
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                }
                string = string + " " + string3;
                return string;
            }
            return string;
        }

        public String content() {
            TabbedLauncherPanel.this.displayedNode = this;
            TabbedLauncherPanel.this.textBoxPanel.removeAll();
            TabbedLauncherPanel.this.textBoxPanel.repaint();
            String string = "";
            NamedNodeMap namedNodeMap = this.domNode.getAttributes();
            int n = namedNodeMap.getLength();
            this.xmlTable = new XMLAttributes();
            for (int i = 0; i < n; ++i) {
                this.xmlTable.put(namedNodeMap.item(i).getNodeName(), ((Element)this.domNode).getAttribute(namedNodeMap.item(i).getNodeName()));
                JTextField jTextField = new JTextField(namedNodeMap.item(i).getNodeName());
                JTextField jTextField2 = new JTextField(((Element)this.domNode).getAttribute(namedNodeMap.item(i).getNodeName()));
                this.key_value.put(jTextField, jTextField2);
                this.value_key.put(jTextField2, jTextField);
                this.stringValue_key.put(jTextField2.getText(), jTextField.getText());
                this.stringKey_value.put(jTextField.getText(), jTextField2.getText());
                jTextField.addCaretListener(new CaretListener(){

                    public void caretUpdate(CaretEvent caretEvent) {
                        JTextField jTextField = (JTextField)caretEvent.getSource();
                        JTextField jTextField2 = (JTextField)AdapterNode.this.key_value.get(jTextField);
                        String string = (String)AdapterNode.this.stringValue_key.get(jTextField2.getText());
                        ((Element)AdapterNode.this.domNode).removeAttribute(string);
                        ((Element)AdapterNode.this.domNode).setAttribute(jTextField.getText(), jTextField2.getText());
                        AdapterNode.this.stringValue_key.remove(AdapterNode.this.stringKey_value.get(string));
                        AdapterNode.this.stringKey_value.remove(string);
                        AdapterNode.this.stringValue_key.put(jTextField2.getText(), jTextField.getText());
                        AdapterNode.this.stringKey_value.put(jTextField.getText(), jTextField2.getText());
                        TabbedLauncherPanel.this.jTree1.repaint();
                    }
                });
                jTextField2.addCaretListener(new CaretListener(){

                    public void caretUpdate(CaretEvent caretEvent) {
                        JTextField jTextField = (JTextField)caretEvent.getSource();
                        JTextField jTextField2 = (JTextField)AdapterNode.this.value_key.get(jTextField);
                        String string = (String)AdapterNode.this.stringKey_value.get(jTextField2.getText());
                        ((Element)AdapterNode.this.domNode).setAttribute(jTextField2.getText(), jTextField.getText());
                        AdapterNode.this.stringKey_value.remove(AdapterNode.this.stringValue_key.get(string));
                        AdapterNode.this.stringValue_key.remove(string);
                        AdapterNode.this.stringValue_key.put(jTextField.getText(), jTextField2.getText());
                        AdapterNode.this.stringKey_value.put(jTextField2.getText(), jTextField.getText());
                        TabbedLauncherPanel.this.jTree1.repaint();
                    }
                });
                TabbedLauncherPanel.this.textBoxPanel.add(jTextField);
                TabbedLauncherPanel.this.textBoxPanel.add(jTextField2);
            }
            string = string + this.xmlTable.toString();
            return string;
        }

        public int index(AdapterNode adapterNode) {
            int n = this.childCount();
            for (int i = 0; i < n; ++i) {
                AdapterNode adapterNode2 = this.child(i);
                if (adapterNode.domNode != adapterNode2.domNode) continue;
                return i;
            }
            return -1;
        }

        public AdapterNode child(int n) {
            Node node = this.domNode.getChildNodes().item(n);
            if (TabbedLauncherPanel.this.compress) {
                int n2 = 0;
                for (int i = 0; !(i >= this.domNode.getChildNodes().getLength() || (node = this.domNode.getChildNodes().item(i)).getNodeType() == 1 && TabbedLauncherPanel.this.treeElement(node.getNodeName()) && n2++ == n); ++i) {
                }
            }
            return new AdapterNode(node);
        }

        public int childCount() {
            if (!TabbedLauncherPanel.this.compress) {
                return this.domNode.getChildNodes().getLength();
            }
            int n = 0;
            for (int i = 0; i < this.domNode.getChildNodes().getLength(); ++i) {
                Node node = this.domNode.getChildNodes().item(i);
                if (node.getNodeType() != 1 || !TabbedLauncherPanel.this.treeElement(node.getNodeName())) continue;
                ++n;
            }
            return n;
        }

        public Node getNode() {
            return this.domNode;
        }
    }
}

