/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import turtlekit2.kernel.Turtle;
import turtlekit2.kernel.TurtleEnvironment;

public final class Patch {
    TurtleEnvironment world;
    public double diffusion;
    double[] variableValue;
    Hashtable<String, Object> marks = null;
    public transient Patch[] neighbors;
    Collection<Turtle> turtlesHere = new HashSet<Turtle>();
    Color color;
    public boolean change = true;
    public int x;
    public int y;

    public Patch(TurtleEnvironment turtleEnvironment, int n, int n2) {
        this.world = turtleEnvironment;
        this.color = Color.black;
        this.x = n;
        this.y = n2;
    }

    final void setNeighborhood(Patch[] patchArray) {
        this.neighbors = patchArray;
    }

    final void update(int n) {
        for (int i = 0; i < this.neighbors.length; ++i) {
            int n2 = n;
            this.variableValue[n2] = this.variableValue[n2] + this.neighbors[i].diffusion;
        }
    }

    final void removeAgent(Turtle turtle) {
        this.change = true;
        this.turtlesHere.remove((Object)turtle);
    }

    final void addAgent(Turtle turtle) {
        this.turtlesHere.add(turtle);
        turtle.position = this;
    }

    public final void setPatchVariable(String string, double d) {
        this.change = true;
        this.world.gridVariables.get((Object)string).gridValues[this.x][this.y] = d;
    }

    public final void incrementPatchVariable(String string, double d) {
        this.change = true;
        double[] dArray = this.world.gridVariables.get((Object)string).gridValues[this.x];
        int n = this.y;
        dArray[n] = dArray[n] + d;
    }

    public final double getVariableValue(String string) {
        return this.world.gridVariables.get((Object)string).gridValues[this.x][this.y];
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
        this.change = true;
    }

    final synchronized Turtle[] getOtherTurtles(Turtle turtle) {
        HashSet<Turtle> hashSet = new HashSet<Turtle>(this.turtlesHere);
        hashSet.remove((Object)turtle);
        return hashSet.toArray(new Turtle[0]);
    }

    final synchronized int size() {
        return this.turtlesHere.size();
    }

    public final void dropMark(String string, Object object) {
        this.change = true;
        if (this.marks == null) {
            this.marks = new Hashtable(1);
        }
        this.marks.put(string, object);
    }

    public final Object getMark(String string) {
        if (this.marks == null) {
            return null;
        }
        Object object = this.marks.get(string);
        if (object != null) {
            this.change = true;
            this.marks.remove(string);
            return object;
        }
        return null;
    }

    public final boolean isMarkPresent(String string) {
        if (this.marks != null) {
            return this.marks.containsKey(string);
        }
        return false;
    }

    public final Turtle[] getTurtles() {
        return this.turtlesHere.toArray(new Turtle[this.turtlesHere.size()]);
    }

    public final Patch[] getNeighbors() {
        return this.neighbors;
    }

    public final String toString() {
        String string = "";
        for (String string2 : this.world.variables.keySet()) {
            double d = this.getVariableValue(string2);
            string = string + "" + string2 + "=" + d + ",";
        }
        return string + "; ";
    }
}

