/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import madkit.kernel.AbstractAgent;
import turtlekit2.kernel.Launcher;
import turtlekit2.kernel.MetaLauncher;
import turtlekit2.kernel.SimuFilter;
import turtlekit2.kernel.TabbedLauncherPanel;

public class MetaLauncherGui
extends JFrame {
    Hashtable tabTree = new Hashtable();
    int nbPanel = 0;
    MetaLauncher m;
    private JMenuItem jAboutItem;
    private JMenuItem jCloseItem;
    private JMenuItem jContentsItem;
    private JMenu jEditMenu;
    private JMenu jFileMenu;
    private JMenu jHelpMenu;
    private JTabbedPane jInstanceTabPanel;
    private JMenuItem jLoadItem;
    private JMenuBar jMenuBar;
    private JMenuItem jQuitItem;
    private JMenuItem jSaveItem;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JMenu jToolsMenu;

    public MetaLauncherGui(MetaLauncher metaLauncher) {
        this.m = metaLauncher;
        this.initComponents();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MetaLauncherGui metaLauncherGui = new MetaLauncherGui(null);
                metaLauncherGui.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.setTitle("TurtleKit 2.0.1");
        this.jInstanceTabPanel = new JTabbedPane();
        this.jMenuBar = new JMenuBar();
        this.jFileMenu = new JMenu();
        this.jLoadItem = new JMenuItem();
        this.jSaveItem = new JMenuItem();
        this.jCloseItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jQuitItem = new JMenuItem();
        this.jEditMenu = new JMenu();
        this.jToolsMenu = new JMenu();
        this.jHelpMenu = new JMenu();
        this.jContentsItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jAboutItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jInstanceTabPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MetaLauncherGui.this.jInstanceTabPanelComponentShown(componentEvent);
            }
        });
        this.getContentPane().add((Component)this.jInstanceTabPanel, "Center");
        this.jFileMenu.setText("File");
        this.jFileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaLauncherGui.this.jFileMenuActionPerformed(actionEvent);
            }
        });
        this.jLoadItem.setText("Open Simulation");
        this.jLoadItem.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.jLoadItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaLauncherGui.this.jLoadItemActionPerformed(actionEvent);
            }
        });
        this.jFileMenu.add(this.jLoadItem);
        this.jSaveItem.setText("Save Simulation");
        this.jSaveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetaLauncherGui.this.jSaveItemActionPerformed(actionEvent);
            }
        });
        this.jFileMenu.add(this.jSaveItem);
        this.jCloseItem.setText("Close");
        this.jFileMenu.add(this.jCloseItem);
        this.jFileMenu.add(this.jSeparator1);
        this.jQuitItem.setText("Quit");
        this.jFileMenu.add(this.jQuitItem);
        this.jMenuBar.add(this.jFileMenu);
        this.jEditMenu.setText("Edit");
        this.jMenuBar.add(this.jEditMenu);
        this.jToolsMenu.setText("Tools");
        this.jMenuBar.add(this.jToolsMenu);
        this.jHelpMenu.setText("Help");
        this.jContentsItem.setText("Help Contents");
        this.jHelpMenu.add(this.jContentsItem);
        this.jHelpMenu.add(this.jSeparator2);
        this.jAboutItem.setText("About");
        this.jHelpMenu.add(this.jAboutItem);
        this.jMenuBar.add(this.jHelpMenu);
        this.setJMenuBar(this.jMenuBar);
        this.setBounds(0, 0, 1500, 900);
    }

    private void jInstanceTabPanelComponentShown(ComponentEvent componentEvent) {
    }

    private void jSaveItemActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir") + File.separator + "plugins");
        SimuFilter simuFilter = new SimuFilter();
        jFileChooser.setFileFilter(simuFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            System.out.println("You chose to open this file: " + jFileChooser.getSelectedFile().getName());
            System.out.println("You chose to open this file: " + jFileChooser.getSelectedFile().getAbsolutePath());
            ((TabbedLauncherPanel)this.tabTree.get(new Integer(this.jInstanceTabPanel.getSelectedIndex()))).saveXml(jFileChooser.getSelectedFile());
        }
    }

    private void jLoadItemActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        SimuFilter simuFilter = new SimuFilter();
        jFileChooser.setFileFilter(simuFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            System.out.println("You chose to open this file: " + jFileChooser.getSelectedFile().getAbsolutePath());
            this.loadSimulationFile(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void loadSimulationFile(String string) {
        System.out.println("launching");
        Launcher launcher = new Launcher(string);
        this.m.launchAgent((AbstractAgent)launcher, string, true);
        launcher.disposeMyGUI();
        TabbedLauncherPanel tabbedLauncherPanel = new TabbedLauncherPanel(string, launcher);
        this.jInstanceTabPanel.add(string, tabbedLauncherPanel);
        this.tabTree.put(new Integer(this.nbPanel), tabbedLauncherPanel);
        ++this.nbPanel;
    }

    private void jFileMenuActionPerformed(ActionEvent actionEvent) {
    }
}

