/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.kernel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import madkit.kernel.AbstractAgent;
import madkit.kernel.OPanel;
import madkit.system.property.PropertyAgent;
import madkit.utils.graphics.GraphicUtils;
import turtlekit2.guis.TkActionsFactory;
import turtlekit2.kernel.Launcher;

class LauncherGui
extends JPanel
implements ActionListener {
    JTextField p;
    JTextField dD;
    JTextField pause;
    JTextField displayDelay;
    JButton startStop;
    JButton wrapOnOff;
    JButton addViewer;
    JButton reset;
    JButton step;
    JButton python;
    Launcher ll;
    JPanel buttons;
    JPanel allbuttons;
    JPanel cycle;
    OPanel textDisplay;
    JButton bProp;
    PropertyAgent prop;
    ImageIcon iStart;
    ImageIcon iStep;
    ImageIcon iReset;
    ImageIcon iStop;
    ImageIcon iPythonEd;
    ImageIcon iView;
    ImageIcon iProps;

    public LauncherGui(Launcher launcher) {
        this.ll = launcher;
        this.setSize(220, 210);
        this.iStart = this.makeIcon("/toolbarButtonGraphics/media/Play24.gif");
        this.iStop = this.makeIcon("/toolbarButtonGraphics/media/Pause24.gif");
        this.iStep = this.makeIcon("/toolbarButtonGraphics/media/StepForward24.gif");
        this.iReset = this.makeIcon("/toolbarButtonGraphics/general/Refresh24.gif");
        this.iPythonEd = this.makeIcon("/images/agents/agenteditorPython32.gif");
        this.iView = this.makeIcon("/images/toolbars/watch.gif");
        this.iProps = this.makeIcon("/toolbarButtonGraphics/general/loupe.gif");
    }

    private void makebutton(JButton jButton, JPanel jPanel) {
        jPanel.add(jButton);
        jButton.addActionListener(this);
    }

    JButton createButton(JPanel jPanel, String string, String string2, ImageIcon imageIcon) {
        JButton jButton = imageIcon != null ? new JButton(imageIcon) : new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        if (jPanel != null) {
            jPanel.add(jButton);
        }
        return jButton;
    }

    ImageIcon makeIcon(String string) {
        if (string != null) {
            ImageIcon imageIcon = null;
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            if (imageIcon != null && imageIcon.getImage() != null) {
                return imageIcon;
            }
        }
        return null;
    }

    void setButtonState(JButton jButton, String string, ImageIcon imageIcon) {
        jButton.setActionCommand(string);
        if (imageIcon != null) {
            jButton.setIcon(imageIcon);
        }
    }

    void initialisation() {
        this.setLayout(new BorderLayout());
        this.wrapOnOff = this.ll.wrap ? new JButton("Wrap On") : new JButton("Wrap Off");
        this.addViewer = new JButton("Add Viewer");
        this.allbuttons = new JPanel(new GridLayout(2, 3));
        this.startStop = this.createButton(this.allbuttons, "start", "Run and stop the simulation", this.iStart);
        this.step = this.createButton(this.allbuttons, "Step", "Step the simulation", this.iStep);
        this.reset = this.createButton(this.allbuttons, "Reset", "Reset the simulation", this.iReset);
        this.makebutton(this.wrapOnOff, this.allbuttons);
        this.addViewer = this.createButton(this.allbuttons, "Add Viewer", "Add a viewer", this.iView);
        this.python = this.createButton(this.allbuttons, "Python", "Launch a python editor", this.iPythonEd);
        JLabel jLabel = new JLabel("Simulation speed", 0);
        jLabel.setAlignmentX(0.5f);
        JSlider jSlider = new JSlider(0, 0, 500, 490);
        jSlider.addChangeListener(new SliderListener());
        jSlider.setMajorTickSpacing(250);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(false);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)jSlider, "Center");
        this.bProp = this.createButton(null, "Properties", "Shows the simulation parameters", this.iProps);
        jPanel.add((Component)this.bProp, "East");
        this.textDisplay = new OPanel();
        this.textDisplay.jscrollpane.setHorizontalScrollBarPolicy(31);
        this.textDisplay.jscrollpane.setVerticalScrollBarPolicy(20);
        this.ll.setOutputWriter(this.textDisplay.getOut());
        JToolBar jToolBar = TkActionsFactory.createSimulationToolbar(this.ll, "24");
        jPanel.add((Component)jToolBar, "First");
        this.add("North", this.allbuttons);
        this.add("South", jPanel);
        this.add("Center", (Component)this.textDisplay);
        this.doLayout();
        this.allbuttons.doLayout();
        this.textDisplay.doLayout();
        jPanel.doLayout();
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.startStop) {
            if (this.startStop.getActionCommand().equalsIgnoreCase("Start")) {
                this.startStop.setBackground(Color.green);
                this.setButtonState(this.startStop, "Stop", this.iStop);
                this.ll.start = true;
                return;
            }
            if (this.ll.run && this.ll.start) {
                this.startStop.setBackground(Color.red);
                this.setButtonState(this.startStop, "Run", this.iStart);
                this.ll.setStop();
                return;
            }
            if (this.ll.start) {
                this.startStop.setBackground(Color.green);
                this.setButtonState(this.startStop, "Stop", this.iStop);
                this.ll.setStop();
            }
        } else if (object == this.addViewer && this.ll.start) {
            this.ll.addViewer();
        } else if (object == this.reset && this.ll.start) {
            this.textDisplay.clearOutput();
            this.ll.setReset();
            this.ll.run = true;
            this.startStop.setBackground(Color.green);
            this.setButtonState(this.startStop, "Stop", this.iStop);
        } else if (object == this.wrapOnOff) {
            if (this.wrapOnOff.getText().equalsIgnoreCase("Wrap On")) {
                this.ll.setWrapModeOn(false);
                this.wrapOnOff.setText("Wrap Off");
            } else {
                this.ll.setWrapModeOn(true);
                this.wrapOnOff.setText("Wrap On");
            }
        } else if (object == this.step) {
            if (this.ll.start && this.ll.run) {
                this.startStop.setBackground(Color.red);
                this.setButtonState(this.startStop, "Run", this.iStart);
                this.ll.setStop();
                this.ll.stepByStep();
                return;
            }
            if (this.ll.start) {
                this.ll.stepByStep();
                return;
            }
        } else if (object == this.bProp) {
            if (this.prop == null) {
                this.prop = new PropertyAgent((AbstractAgent)this.ll);
                this.ll.launchAgent((AbstractAgent)this.prop, "Properties of " + this.ll.simulationName, true);
            } else {
                GraphicUtils.getFrameParent((Container)((JComponent)this.prop.getGUIObject())).setVisible(true);
            }
        } else if (object == this.python) {
            try {
                this.ll.println("launching python. Please wait...");
                this.ll.launchPython();
                if (this.ll.run) {
                    this.startStop.setBackground(Color.red);
                    this.setButtonState(this.startStop, "Run", this.iStart);
                    this.ll.setStop();
                    this.ll.stepByStep();
                    return;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.ll.println("can't launch python in applet mode");
            }
            catch (Exception exception) {
                this.ll.println("can't launch python in applet mode");
            }
        }
    }

    void removePropertyWindows() {
        if (this.prop != null) {
            this.ll.killAgent((AbstractAgent)this.prop);
        }
    }

    class SliderListener
    implements ChangeListener {
        SliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                LauncherGui.this.ll.setCyclePause(500 - jSlider.getValue());
            }
        }
    }
}

