/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import turtlekit2.genetic.BitGene;
import turtlekit2.genetic.BitGeneList;
import turtlekit2.genetic.ExtendedJButton;
import turtlekit2.genetic.ExtendedJPopupMenu;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.GeneticFileManager;
import turtlekit2.genetic.Genome;

public class GenomeGUI
extends JPanel {
    ExtendedJPopupMenu genePopupMenu;
    Genome myGenome;

    public GenomeGUI(Genome genome) {
        this.myGenome = genome;
        this.refresh();
    }

    public void createPopupMenu() {
        this.genePopupMenu = new ExtendedJPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save");
        JMenuItem jMenuItem2 = new JMenuItem("Replace");
        JMenuItem jMenuItem3 = new JMenuItem("Reset");
        JMenuItem jMenuItem4 = new JMenuItem("Set \"Fixed\"");
        JMenuItem jMenuItem5 = new JMenuItem("Set \"UNFixed\"");
        JMenuItem jMenuItem6 = new JMenuItem("Remove");
        JMenuItem jMenuItem7 = new JMenuItem("Change Name");
        JMenuItem jMenuItem8 = new JMenuItem("Edit BitGene");
        JMenuItem jMenuItem9 = new JMenuItem("Edit Codon");
        JMenuItem jMenuItem10 = new JMenuItem("Edit Codons");
        this.genePopupMenu.add(jMenuItem);
        this.genePopupMenu.add(jMenuItem2);
        this.genePopupMenu.add(jMenuItem3);
        this.genePopupMenu.add(jMenuItem4);
        this.genePopupMenu.add(jMenuItem5);
        this.genePopupMenu.add(jMenuItem6);
        this.genePopupMenu.add(jMenuItem7);
        this.genePopupMenu.add(jMenuItem8);
        this.genePopupMenu.add(jMenuItem9);
        this.genePopupMenu.add(jMenuItem10);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.saveGeneEvent(actionEvent);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.replaceGeneEvent(actionEvent);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.resetGeneEvent(actionEvent);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.setFixedEvent(actionEvent);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.setUnFixedEvent(actionEvent);
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.removeGeneEvent(actionEvent);
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.editGeneEvent(actionEvent);
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.editGeneEvent2(actionEvent);
            }
        });
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.editGeneEvent3(actionEvent);
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenomeGUI.this.setNameEvent(actionEvent);
            }
        });
    }

    public void createPanelContent() {
        this.setLayout(new GridLayout(this.myGenome.getSize(), 4, 45, 5));
        for (int i = 0; i < this.myGenome.getSize(); ++i) {
            ExtendedJButton extendedJButton = new ExtendedJButton("Gene " + new Integer(i).toString(), this.myGenome.getGene(i), i);
            extendedJButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        GenomeGUI.this.genePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), ((ExtendedJButton)mouseEvent.getSource()).getGene());
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        GenomeGUI.this.genePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), ((ExtendedJButton)mouseEvent.getSource()).getGene());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            JLabel jLabel = new JLabel(this.myGenome.getGene(i).toString());
            JLabel jLabel2 = new JLabel(this.myGenome.getGene(i).getName());
            JLabel jLabel3 = new JLabel(new Boolean(this.myGenome.getGene(i).isFixed()).toString());
            this.add(extendedJButton);
            this.add(jLabel2);
            this.add(jLabel3);
            this.add(jLabel);
        }
    }

    public void refresh() {
        this.removeAll();
        this.createPanelContent();
        this.createPopupMenu();
    }

    public Gene getSelectedGene(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        ExtendedJPopupMenu extendedJPopupMenu = (ExtendedJPopupMenu)jMenuItem.getParent();
        return (Gene)extendedJPopupMenu.getObject();
    }

    public void saveGeneEvent(ActionEvent actionEvent) {
        GeneticFileManager.saveGene(this, this.getSelectedGene(actionEvent));
    }

    public void replaceGeneEvent(ActionEvent actionEvent) {
        Gene gene = GeneticFileManager.loadGene(this);
        if (gene != null) {
            int n = this.myGenome.indexOf(this.getSelectedGene(actionEvent));
            this.myGenome.remove(this.getSelectedGene(actionEvent));
            this.myGenome.add(n, gene);
            this.refresh();
        }
    }

    public void resetGeneEvent(ActionEvent actionEvent) {
        this.getSelectedGene(actionEvent).init();
        this.refresh();
    }

    public void setFixedEvent(ActionEvent actionEvent) {
        this.getSelectedGene(actionEvent).setFixed(true);
        this.refresh();
    }

    public void setUnFixedEvent(ActionEvent actionEvent) {
        this.getSelectedGene(actionEvent).setFixed(false);
        this.refresh();
    }

    public void removeGeneEvent(ActionEvent actionEvent) {
        this.myGenome.remove(this.getSelectedGene(actionEvent));
        this.refresh();
    }

    public void setNameEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input the new Gene Name");
        this.getSelectedGene(actionEvent).setName(string);
        this.refresh();
    }

    public void editGeneEvent(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input the new Gene Value");
        for (int i = 0; i < ((BitGene)((BitGeneList)this.getSelectedGene(actionEvent)).get(1)).getSize(); ++i) {
            if (string.charAt(i) == '1') {
                ((BitGene)((BitGeneList)this.getSelectedGene(actionEvent)).get(1)).set(i);
                continue;
            }
            ((BitGene)((BitGeneList)this.getSelectedGene(actionEvent)).get(1)).set(i, false);
        }
        this.refresh();
    }

    public void editGeneEvent2(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog("Please input the codon size (in bits)");
        String string2 = JOptionPane.showInputDialog("Please input the codon number (in integer)");
        String string3 = JOptionPane.showInputDialog("Please input the codon value (in integer)");
        ((BitGene)this.getSelectedGene(actionEvent)).setCodonValue(Integer.parseInt(string), Integer.parseInt(string2), Integer.parseInt(string3));
        this.refresh();
    }

    public void editGeneEvent3(ActionEvent actionEvent) {
        int n = 0;
        String string = JOptionPane.showInputDialog("Please input the codons size (in bits)");
        String string2 = JOptionPane.showInputDialog("Please input the codon value (in integer)");
        ((BitGene)this.getSelectedGene(actionEvent)).setCodonValue(Integer.parseInt(string), n, Integer.parseInt(string2));
        while (Integer.parseInt(string2) != -1) {
            string2 = JOptionPane.showInputDialog("Please input the codon value for the " + ++n + "th codon");
            ((BitGene)this.getSelectedGene(actionEvent)).setCodonValue(Integer.parseInt(string), n, Integer.parseInt(string2));
        }
        this.refresh();
    }
}

