/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFileChooser;
import turtlekit2.genetic.GenFilter;
import turtlekit2.genetic.Gene;
import turtlekit2.genetic.Genome;
import turtlekit2.genetic.Pool;

public class GeneticFileManager {
    public static final String pool = "pool";
    public static final String gnom = "gnom";
    public static final String gene = "gene";

    public static void savePool(Component component, Pool pool) {
        GeneticFileManager.save(component, pool, (Object)pool);
    }

    public static void saveGenome(Component component, Genome genome) {
        GeneticFileManager.save(component, gnom, (Object)genome);
    }

    public static void saveGene(Component component, Gene gene) {
        GeneticFileManager.save(component, gene, (Object)gene);
    }

    public static void savePool(String string, Pool pool) {
        GeneticFileManager.save(string, pool, (Object)pool);
    }

    public static void saveGenome(String string, Genome genome) {
        GeneticFileManager.save(string, gnom, (Object)genome);
    }

    public static void saveGene(String string, Gene gene) {
        GeneticFileManager.save(string, gene, (Object)gene);
    }

    public static void save(Component component, String string, Object object) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        GenFilter genFilter = new GenFilter(string);
        jFileChooser.setFileFilter(genFilter);
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            System.out.println("You chose to save this file: " + jFileChooser.getSelectedFile().getAbsolutePath());
            GeneticFileManager.save(jFileChooser.getSelectedFile().getAbsolutePath(), string, object);
        }
    }

    public static void save(String string, String string2, Object object) {
        String string3 = string + "." + string2;
        try {
            File file = new File(string3);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(string2 + " File Write Error !\n" + string3 + "\n" + iOException);
        }
    }

    public static Pool loadPool(Component component) {
        return (Pool)GeneticFileManager.load(component, pool);
    }

    public static Genome loadGenome(Component component) {
        return (Genome)GeneticFileManager.load(component, gnom);
    }

    public static Gene loadGene(Component component) {
        return (Gene)GeneticFileManager.load(component, gene);
    }

    public static Object load(Component component, String string) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        GenFilter genFilter = new GenFilter(string);
        jFileChooser.setFileFilter(genFilter);
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            System.out.println("You chose to open this file: " + jFileChooser.getSelectedFile().getAbsolutePath());
            return GeneticFileManager.load(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        return null;
    }

    public static Object load(String string) {
        String string2 = string;
        try {
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            System.err.println("File Load Error !\n" + string2 + "\n" + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Object ClassNotFoundError Read Error !\n" + string2 + "\n" + classNotFoundException);
        }
        return null;
    }
}

