/*
 * Decompiled with CFR 0.152.
 */
package turtlekit2.genetic;

import java.util.BitSet;
import java.util.Random;
import turtlekit2.genetic.Gene;
import turtlekit2.kernel.XMLAttributes;

public class BitGene
extends BitSet
implements Gene {
    static final int ONE_POINT_CROSSING = 1;
    static final int TWO_POINT_CROSSING = 2;
    String name;
    boolean fixed = false;
    XMLAttributes attrib = new XMLAttributes();
    Random randomizer = new Random();
    int size;

    public BitGene() {
    }

    public BitGene(String string) {
        this.name = string;
    }

    public void createFrame() {
    }

    public void init() {
        double d = 50.0;
        this.size = this.attrib.containsKey("Size") ? this.attrib.getInt("Size") : 5;
        this.name = this.attrib.containsKey("Name") ? this.attrib.getString("Name") : "BitGene";
        d = this.attrib.containsKey("Filling") ? (double)this.attrib.getInt("Filling") : 50.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(Math.random() * 100.0 > d)) continue;
            this.set(i);
        }
    }

    public void copy(Gene gene) {
        this.name = gene.getName();
        this.attrib = gene.getAttrib();
        this.size = ((BitGene)gene).getSize();
        this.clear();
        this.or((BitGene)gene);
    }

    public void copyBitSet(BitSet bitSet) {
        this.clear();
        this.or(bitSet);
    }

    public boolean isEqual(Gene gene) {
        if (((BitGene)gene).length() != this.length()) {
            return false;
        }
        for (int i = 0; i < ((BitGene)gene).length(); ++i) {
            if (this.get(i) == ((BitGene)gene).get(i)) continue;
            return false;
        }
        return true;
    }

    public void cross(Gene gene, Gene gene2) {
        BitSet bitSet;
        int n;
        int n2 = 2;
        if (this.attrib.containsKey("CrossMethod")) {
            n2 = this.attrib.getInt("crossMethod");
        }
        if (n2 == 1) {
            n = this.randomizer.nextInt(this.size);
            BitSet bitSet2 = new BitSet(this.size);
            bitSet = new BitSet(this.size);
            bitSet2.set(0, n);
            bitSet.set(n, this.size);
            if (this.randomizer.nextBoolean()) {
                bitSet2.and((BitSet)((Object)gene2));
                bitSet.and((BitSet)((Object)gene));
                bitSet2.or(bitSet);
                this.copyBitSet(bitSet2);
            } else {
                bitSet2.and((BitSet)((Object)gene));
                bitSet.and((BitSet)((Object)gene2));
                bitSet2.or(bitSet);
                this.copyBitSet(bitSet2);
            }
        }
        if (n2 == 2) {
            n = this.randomizer.nextInt(this.size / 2);
            int n3 = this.size - this.randomizer.nextInt(this.size / 2);
            bitSet = new BitSet(this.size);
            BitSet bitSet3 = new BitSet(this.size);
            bitSet.set(0, n);
            bitSet3.set(n, n3);
            bitSet.set(n3, this.size);
            if (this.randomizer.nextBoolean()) {
                bitSet.and((BitSet)((Object)gene2));
                bitSet3.and((BitSet)((Object)gene));
                bitSet.or(bitSet3);
                this.copyBitSet(bitSet);
            } else {
                bitSet.and((BitSet)((Object)gene));
                bitSet3.and((BitSet)((Object)gene2));
                bitSet.or(bitSet3);
                this.copyBitSet(bitSet);
            }
        }
    }

    public void mutate() {
        double d = 9900.0;
        if (this.attrib.containsKey("MutationRate")) {
            d = this.attrib.getDouble("MutationRate");
        }
        for (int i = 0; i < this.size; ++i) {
            if (!((double)this.randomizer.nextInt(10000) > d)) continue;
            this.flip(i);
        }
    }

    public String toString() {
        String string = this.name + ":";
        for (int i = 0; i < this.getSize(); ++i) {
            string = string + this.intValue(i);
        }
        string = string + "  ";
        return string;
    }

    public int intValue(int n) {
        if (this.get(n)) {
            return 1;
        }
        return 0;
    }

    public int intValue(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = (int)((double)n3 + (double)this.intValue(i) * Math.pow(2.0, n2 - n - (i - n + 1)));
        }
        return n3;
    }

    public int intValue() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            n = (int)((double)n + (double)this.intValue(i) * Math.pow(2.0, this.size - (i + 1)));
        }
        return n;
    }

    public void setIntValue(int n) {
        System.out.println("ok");
        char[] cArray = Integer.toBinaryString(n).toCharArray();
        this.clear();
        if (cArray.length > this.size) {
            this.set(0, this.size);
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '1') continue;
                this.set(this.size - cArray.length + i);
            }
        }
    }

    public void setCodonValue(int n, int n2, int n3) {
        char[] cArray = Integer.toBinaryString(n3).toCharArray();
        int n4 = n2 * n;
        int n5 = n2 * n + n;
        this.clear(n4, n5);
        if (cArray.length > n) {
            this.set(n4, n5);
        } else {
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '1') continue;
                this.set(n5 - cArray.length + i);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public XMLAttributes getAttrib() {
        return this.attrib;
    }

    public void setAttrib(XMLAttributes xMLAttributes) {
        this.attrib = xMLAttributes;
    }

    public String cardinalityString() {
        String string = new Integer(this.cardinality()).toString();
        return string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int size() {
        return this.getSize();
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }
}

