/*
 * Decompiled with CFR 0.152.
 */
package madkit.backgroundProperty;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import madkit.backgroundProperty.PropertyPane;

class PropertyEdit
extends JPanel
implements ActionListener,
ChangeListener {
    PropertyPane propertyPane;
    JCheckBox useWallpaper;
    JTextField wallpaperPath;
    JComboBox wallpaperPos;
    JButton browse;
    JButton selectColor;
    JPanel pColor;

    public PropertyEdit(PropertyPane propertyPane) {
        super(new GridLayout(0, 1));
        this.propertyPane = propertyPane;
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.useWallpaper = propertyPane.getWallpaperPath() != null && !propertyPane.getWallpaperPath().equals("") ? new JCheckBox("Use wallpaper", true) : new JCheckBox("Use wallpaper", false);
        this.useWallpaper.addChangeListener(this);
        jPanel2.add(this.useWallpaper);
        String[] stringArray = new String[]{"Center", "Stretch"};
        this.wallpaperPos = new JComboBox<String>(stringArray);
        this.wallpaperPos.setSelectedItem(propertyPane.getWallpaperPos());
        this.wallpaperPos.addActionListener(this);
        jPanel2.add(this.wallpaperPos);
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel();
        this.wallpaperPath = new JTextField(20);
        if (propertyPane.getWallpaperPath() != null) {
            this.wallpaperPath.setText(propertyPane.getWallpaperPath());
        }
        this.wallpaperPath.setEditable(false);
        jPanel2.add(this.wallpaperPath);
        this.browse = new JButton("Browse");
        this.browse.addActionListener(this);
        jPanel2.add(this.browse);
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Backgroud Color :"));
        this.pColor = new JPanel();
        this.pColor.setBackground(propertyPane.getBackgroundColor());
        this.pColor.setPreferredSize(new Dimension(20, 20));
        this.pColor.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel2.add(this.pColor);
        this.selectColor = new JButton("Select color");
        this.selectColor.addActionListener(this);
        jPanel2.add(this.selectColor);
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
    }

    public void setColor(Color color) {
        this.pColor.setBackground(color);
    }

    public void setPos(String string) {
        this.wallpaperPos.setSelectedItem(string);
    }

    public void setWallpaper(String string) {
        this.wallpaperPath.setText(string);
    }

    public Color getColor() {
        return this.pColor.getBackground();
    }

    public String getPos() {
        return this.wallpaperPos.getSelectedItem().toString();
    }

    public String getPath() {
        if (this.useWallpaper.isSelected()) {
            return this.wallpaperPath.getText();
        }
        return "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object = actionEvent.getSource();
        if (object == this.selectColor) {
            serializable = new JColorChooser();
            Color color = JColorChooser.showDialog(this, "Please choose the background color", this.pColor.getBackground());
            if (color != null) {
                this.propertyPane.setColor(color);
            }
        }
        if (object == this.browse && (serializable = this.openFile(false, "png,jpg", "Supported image files (*.png;*.jpg)")) != null) {
            this.propertyPane.setWallpaper((File)serializable);
        }
        if (object == this.wallpaperPos) {
            this.propertyPane.setWallpaperPos(this.wallpaperPos.getSelectedItem().toString());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.useWallpaper) {
            this.propertyPane.setUseWallpaper(this.useWallpaper.isSelected());
        }
    }

    protected File openFile(boolean bl, String string, final String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        final Object[] objectArray = vector.toArray();
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
        if (string != null) {
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    if (file.isDirectory()) {
                        return true;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!string.endsWith("." + (String)objectArray[i])) continue;
                        return true;
                    }
                    return false;
                }

                public String getDescription() {
                    return string2;
                }
            });
        }
        File file = null;
        if (jFileChooser.showOpenDialog(this) == 0) {
            file = jFileChooser.getSelectedFile();
            return file;
        }
        return null;
    }
}

