/*
 * Decompiled with CFR 0.152.
 */
package madkit.backgroundProperty;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class PreviewScreen
extends JPanel {
    ImageIcon screen = new ImageIcon(this.getClass().getResource("/images/icones/screen.png"));
    ImageIcon wallpaperPath;
    Color backgroundColor;
    int screenWidth;
    int screenHeight;
    boolean useWallpaper;
    String wallpaperPos;

    public PreviewScreen(Color color, String string, String string2, int n, int n2, boolean bl) {
        this.backgroundColor = color;
        this.screenWidth = n;
        this.screenHeight = n2;
        this.useWallpaper = bl;
        this.wallpaperPos = string2;
        this.setWallpaper(string);
    }

    public void setColor(Color color) {
        this.backgroundColor = color;
        this.repaint();
    }

    public void setUseWallpaper(boolean bl) {
        this.useWallpaper = bl;
        this.repaint();
    }

    public void setWallpaper(String string) {
        this.wallpaperPath = string == null || string.equals("") ? null : new ImageIcon(string);
        this.repaint();
    }

    public void setWallpaperPos(String string) {
        this.wallpaperPos = string;
        this.repaint();
    }

    public void setScreenSize(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = (int)((this.getSize().getWidth() - (double)this.screen.getIconWidth()) / 2.0);
        int n2 = (int)((this.getSize().getHeight() - (double)this.screen.getIconHeight()) / 2.0);
        graphics2D.drawImage(this.screen.getImage(), n, n2, null);
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fill(new Rectangle(12 + n, 16 + n2, 152, 112));
        if (this.wallpaperPath != null && this.useWallpaper) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (this.wallpaperPos.equalsIgnoreCase("Center")) {
                int n7 = (this.screenWidth - this.wallpaperPath.getIconWidth()) / 2;
                int n8 = (this.screenHeight - this.wallpaperPath.getIconWidth()) / 2;
                n6 = 12 + n + 152 * n7 / this.screenWidth;
                n5 = 16 + n2 + 112 * n8 / this.screenHeight;
                n4 = 152 * this.wallpaperPath.getIconWidth() / this.screenWidth;
                n3 = 112 * this.wallpaperPath.getIconWidth() / this.screenHeight;
            } else {
                n6 = 12 + n;
                n5 = 16 + n2;
                n4 = 152;
                n3 = 112;
            }
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.clipRect(12 + n, 16 + n2, 152, 112);
            graphics2D.drawImage(this.wallpaperPath.getImage(), n6, n5, n4, n3, null);
            if (rectangle != null) {
                graphics2D.setClip(rectangle);
            } else {
                graphics2D.setClip(null);
            }
        }
    }
}

