/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.http;

import java.io.IOException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.ext.http.Dispatch;
import net.jxta.ext.http.DispatchTimerTask;
import net.jxta.ext.http.Dispatchable;
import net.jxta.ext.http.HttpGet;
import net.jxta.ext.http.HttpPost;
import net.jxta.ext.http.Message;

public class Dispatcher {
    private static final int SLEEP = 50;
    private static final long MAX_WAIT = 20000L;
    private Dispatchable dispatchable = null;
    private long maxWait = 20000L;

    public static Dispatchable getDispatchable(URL u, Message msg) {
        HttpGet d = null;
        d = msg != null && msg.getBody() != null ? new HttpPost(u, msg) : new HttpGet(u, msg);
        return d;
    }

    public Dispatcher(URL u) {
        this(u, null);
    }

    public Dispatcher(URL u, long maxWait) {
        this(u, null, maxWait);
    }

    public Dispatcher(URL u, Message msg) {
        this(u, msg, 20000L);
    }

    public Dispatcher(URL u, Message msg, long maxWait) {
        this.dispatchable = Dispatcher.getDispatchable(u, msg);
        this.maxWait = maxWait;
    }

    public Dispatchable getDispatchable() {
        return this.dispatchable;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public Message dispatch() throws IOException {
        Dispatch dispatch = new Dispatch(this.dispatchable);
        Thread t = new Thread((Runnable)dispatch, Dispatcher.class.getName());
        t.setDaemon(true);
        t.start();
        Timer timer = null;
        if (this.getMaxWait() > 0L) {
            timer = new Timer();
            timer.schedule((TimerTask)new DispatchTimerTask(dispatch), this.getMaxWait());
        }
        while (!dispatch.isDone()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {}
        }
        Message response = dispatch.getResponse();
        this.dispatchable.disconnect();
        if (timer != null) {
            timer.cancel();
        }
        return response;
    }
}

