/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.ProxyAddress;
import net.jxta.ext.config.PublicAddress;

public abstract class Transport {
    private String scheme = "tcp";
    private boolean isEnabled = true;
    private boolean isIncoming = false;
    private boolean isOutgoing = false;
    private List addresses = null;
    private List publicAddresses = null;
    private boolean isProxyEnabled = false;
    private ProxyAddress proxy = null;

    public Transport(String scheme) {
        this.setScheme(scheme);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        if (!Scheme.isValid(scheme)) {
            throw new IllegalArgumentException("invalid scheme: " + scheme);
        }
        this.scheme = scheme;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isIncoming() {
        return this.isIncoming;
    }

    public void setIncoming(boolean isIncoming) {
        this.isIncoming = isIncoming;
    }

    public boolean isOutgoing() {
        return this.isOutgoing;
    }

    public void setOutgoing(boolean isOutgoing) {
        this.isOutgoing = isOutgoing;
    }

    public List getAddresses() {
        return this.addresses != null ? this.addresses : Collections.EMPTY_LIST;
    }

    public void setAddress(Address address) {
        this.setAddresses(Collections.singletonList(address));
    }

    public void setAddresses(List addresses) {
        this.clearAddresses();
        this.addAddresses(addresses);
    }

    public void addAddress(Address address) {
        this.addAddresses(Collections.singletonList(address));
    }

    public void addAddresses(List addresses) {
        if (addresses == null) {
            addresses = Collections.EMPTY_LIST;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            Address a = (Address)i.next();
            if (a == null || this.addresses.contains(a)) continue;
            this.addresses.add(a);
        }
    }

    public Address removeAddress(Address address) {
        int i;
        Address a = null;
        if (this.addresses != null && (i = this.addresses.indexOf(address)) > -1) {
            a = (Address)this.addresses.remove(i);
            if (this.addresses.size() == 0) {
                this.addresses = null;
            }
        }
        return a;
    }

    public void clearAddresses() {
        if (this.addresses != null) {
            this.addresses.clear();
            this.addresses = null;
        }
    }

    public List getPublicAddresses() {
        return this.publicAddresses != null ? this.publicAddresses : Collections.EMPTY_LIST;
    }

    public void addPublicAddress(PublicAddress address) {
        this.addPublicAddresses(Collections.singletonList(address));
    }

    public void addPublicAddresses(List addresses) {
        if (addresses == null) {
            addresses = Collections.EMPTY_LIST;
        }
        if (this.publicAddresses == null) {
            this.publicAddresses = new ArrayList();
        }
        Iterator i = addresses.iterator();
        while (i.hasNext()) {
            PublicAddress pa = (PublicAddress)i.next();
            if (pa == null || this.publicAddresses.contains(pa)) continue;
            this.publicAddresses.add(pa);
        }
    }

    public void setPublicAddress(PublicAddress address) {
        this.setPublicAddresses(Collections.singletonList(address));
    }

    public void setPublicAddresses(List addresses) {
        this.clearPublicAddresses();
        this.addPublicAddresses(addresses);
    }

    public Address removePublicAddress(PublicAddress address) {
        Address a = null;
        if (this.publicAddresses != null) {
            int i = this.publicAddresses.indexOf(address);
            if (i > -1) {
                a = (Address)this.publicAddresses.remove(i);
            }
            if (this.publicAddresses.size() == 0) {
                this.publicAddresses = null;
            }
        }
        return a;
    }

    public void clearPublicAddresses() {
        if (this.publicAddresses != null) {
            this.publicAddresses.clear();
            this.publicAddresses = null;
        }
    }

    public boolean isProxy() {
        return this.isProxyEnabled;
    }

    public void setProxy(boolean isProxyEnabled) {
        this.isProxyEnabled = isProxyEnabled;
    }

    public ProxyAddress getProxyAddress() {
        return this.proxy;
    }

    public void setProxyAddress(ProxyAddress proxy) {
        this.proxy = proxy;
    }

    public static class Scheme {
        public static final String TCP = "tcp";
        public static final String HTTP = "http";
        private static List schemes = null;

        public static List getSchemes() {
            return schemes;
        }

        public static boolean isValid(String t) {
            return Scheme.getSchemes().contains(t);
        }

        private Scheme() {
        }

        static {
            schemes = new ArrayList();
            schemes.add(TCP);
            schemes.add(HTTP);
        }
    }
}

