/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.jxta.ext.config.Configurator;
import net.jxta.ext.config.Conversion;
import net.jxta.ext.config.ConversionException;
import net.jxta.ext.config.Env;
import net.jxta.ext.config.Trace;
import net.jxta.ext.config.Util;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class Default {
    private static final int MILLISECONDS_PER_SECOND = 1000;
    public static URI HOME_ADDRESS;
    public static final String HOME = "file://${user.home}/.jxta";
    public static final String PEER_DESCRIPTOR = "unspecified";
    public static final String PEER_NAME;
    public static final String ANONYMOUS = "Anonymous";
    public static final boolean SECURITY_IS_ENABLED = true;
    public static final String PRINCIPAL;
    public static final String PASSWORD;
    public static final String PEER_DESCRIPTION;
    public static final Trace TRACE;
    public static final String ROOT_CERTIFICATE;
    public static URI RENDEZVOUS_BOOTSTRAP_ADDRESS;
    public static boolean RENDEZVOUS_DISCOVERY_IS_ENABLED;
    public static URI RELAYS_BOOTSTRAP_ADDRESS;
    public static boolean RELAYS_DISCOVERY_IS_ENABLED;
    public static URI REFLECTION_BOOTSTRAP_ADDRESS;
    public static URI ANY_ADDRESS;
    public static URI ANY_TCP_ADDRESS;
    public static URI ANY_HTTP_ADDRESS;
    public static URI ANY_UDP_ADDRESS;
    public static List BOOTSTRAP_ADDRESSES;
    public static final boolean RENDEZVOUS_SERVICE_IS_ENABLED = false;
    public static final boolean RENDEZVOUS_SERVICE_AUTO_START_IS_ENABLED = false;
    public static final long RENDEZVOUS_SERVICE_AUTO_START = 30000L;
    public static final boolean RELAY_SERVICE_IS_ENABLED = false;
    public static final int RELAY_SERVICE_QUEUE_SIZE = 20;
    public static final boolean RELAY_SERVICE_INCOMING_IS_ENABLED = false;
    public static final boolean RELAY_SERVICE_OUTGOING_IS_ENABLED = true;
    public static final int INCOMING_MAXIMUM = 100;
    public static final int OUTGOING_MAXIMUM = 1;
    public static final long INCOMING_LEASE = 0x6DDD00L;
    public static final long OUTGOING_LEASE = 0x6DDD00L;
    public static final int QUEUE_SIZE = 100;
    public static final boolean TCP_IS_ENABLED = true;
    public static final boolean TCP_INCOMING_IS_ENABLED = true;
    public static final boolean TCP_OUTGOING_IS_ENABLED = true;
    public static final int TCP_PORT = 9701;
    public static URI TCP_ADDRESS;
    public static final boolean TCP_PUBLIC_ADDRESS_EXCLUSIVE_IS_ENABLED = false;
    public static final boolean TCP_PROXY_IS_ENABLED = false;
    public static final int TCP_PROXY_PORT = 8081;
    public static final int PORT_RANGE = 100;
    public static final boolean MULTICAST_IS_ENABLED = true;
    public static URI MULTICAST_ADDRESS;
    public static final String MULTICAST_IP = "224.0.1.85";
    public static final int MULTICAST_PORT = 1234;
    public static final int MULTICAST_SIZE = 16384;
    public static final boolean HTTP_IS_ENABLED = true;
    public static final boolean HTTP_INCOMING_IS_ENABLED = false;
    public static final boolean HTTP_OUTGOING_IS_ENABLED = true;
    public static final int HTTP_PORT = 9700;
    public static URI HTTP_ADDRESS;
    public static final boolean HTTP_PUBLIC_ADDRESS_EXCLUSIVE_IS_ENABLED = false;
    public static final boolean HTTP_PROXY_IS_ENABLED = false;
    public static final int ENDPOINT_SERVICE_QUEUE_SIZE = 20;
    public static final boolean PROXY_SERVICE_IS_ENABLED = false;
    public static final int MINIMUM_PORT = 1;
    public static final int MINIMUM_DYNAMIC_PORT = 0;
    public static final int MAXIMUM_PORT = 65535;
    public static final int INVALID_PORT = -1;
    public static final int MAXIMUM_MULTICAST_SIZE = 1048575;
    public static final int MINIMUM_MULTICAST_SIZE = 0;
    public static final String CONFIG_MODE = "auto";
    public static final int HTTP_PROXY_PORT = 8080;
    private static final String RDV_BOOTSTRAP = "http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2";
    private static final String RLY_BOOTSTRAP = "http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2";
    private static final String REFLECTION_BOOTSTRAP = "http://rdv.jxtahosts.net/cgi-bin/reflection.cgi";
    private static final String COLON = ":";
    private static final String MULTICAST = "udp://224.0.1.85:1234";
    private static final Logger LOG;

    private static URI toURI(String s) {
        URI u;
        block2: {
            u = null;
            try {
                u = new URI(s);
            }
            catch (URISyntaxException use) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid uri", (Throwable)use);
            }
        }
        return u;
    }

    private Default() {
    }

    static {
        block2: {
            PEER_NAME = null;
            PRINCIPAL = null;
            PASSWORD = null;
            PEER_DESCRIPTION = "Created by: " + Configurator.class.getName();
            TRACE = Trace.DEFAULT;
            ROOT_CERTIFICATE = null;
            RENDEZVOUS_DISCOVERY_IS_ENABLED = true;
            RELAYS_DISCOVERY_IS_ENABLED = true;
            LOG = Logger.getLogger((String)Default.class.getName());
            try {
                HOME_ADDRESS = Conversion.toURI(Util.expand(HOME));
            }
            catch (ConversionException ce) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid encoding", (Throwable)ce);
            }
        }
        RENDEZVOUS_BOOTSTRAP_ADDRESS = Default.toURI(RDV_BOOTSTRAP);
        RELAYS_BOOTSTRAP_ADDRESS = Default.toURI(RLY_BOOTSTRAP);
        REFLECTION_BOOTSTRAP_ADDRESS = Default.toURI(REFLECTION_BOOTSTRAP);
        ANY_ADDRESS = Default.toURI("//:");
        ANY_TCP_ADDRESS = Default.toURI("tcp://:");
        ANY_HTTP_ADDRESS = Default.toURI("http://:");
        ANY_UDP_ADDRESS = Default.toURI("udp://:");
        TCP_ADDRESS = Default.toURI("tcp://" + Env.ALL_ADDRESSES.getHostAddress() + COLON + 9701);
        HTTP_ADDRESS = Default.toURI("http://" + Env.ALL_ADDRESSES.getHostAddress() + COLON + 9700);
        MULTICAST_ADDRESS = Default.toURI(MULTICAST);
        BOOTSTRAP_ADDRESSES = new ArrayList();
        BOOTSTRAP_ADDRESSES.add(ANY_ADDRESS);
        BOOTSTRAP_ADDRESSES.add(ANY_TCP_ADDRESS);
        BOOTSTRAP_ADDRESSES.add(ANY_HTTP_ADDRESS);
    }
}

