/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jxta.ext.config.ConversionException;

public class Conversion {
    private static final String BOGUS = "bogus";
    private static final char SLASH = '/';
    private static final char PERCENT = '%';
    private static final char COLON = ':';
    private static final char[] ESCAPE = new char[]{'/', ':', '?', '#', '@', '%'};
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String URI_FILE = "file:/";

    public static char toChar(String s) throws ConversionException {
        char c = '\u0000';
        try {
            c = s != null && s.length() >= 1 ? s.charAt(0) : BOGUS.charAt(0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new ConversionException(ioobe);
        }
        return c;
    }

    public static int toInt(String s) throws ConversionException {
        int i = -1;
        try {
            i = Integer.parseInt(s != null ? s : BOGUS);
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(nfe);
        }
        return i;
    }

    public static long toLong(String s) throws ConversionException {
        long i = -1L;
        try {
            i = Long.parseLong(s != null ? s : BOGUS);
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(nfe);
        }
        return i;
    }

    public static float toFloat(String s) throws ConversionException {
        float f = -1.0f;
        try {
            f = Float.parseFloat(s != null ? s : BOGUS);
        }
        catch (NumberFormatException nfe) {
            throw new ConversionException(nfe);
        }
        return f;
    }

    public static boolean toBoolean(String s) {
        return Boolean.valueOf(s);
    }

    public static URL toURL(String s) throws ConversionException {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException mue) {
            throw new ConversionException(mue);
        }
        return u;
    }

    public static URL toURL(File f) throws ConversionException {
        String protocol = "file";
        String delimiter = ":";
        String prefix = "./";
        String filePrefix = System.getProperty("file.separator", "/");
        String s = f.toString();
        if (s.startsWith(filePrefix)) {
            s = prefix + s;
        }
        URL u = null;
        try {
            u = new URL(protocol + delimiter + s);
        }
        catch (MalformedURLException mue) {
            throw new ConversionException(mue);
        }
        return u;
    }

    public static List toURLs(List l) throws ConversionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                urls.add(new URL((String)i.next()));
            }
        }
        catch (MalformedURLException mue) {
            throw new ConversionException(mue);
        }
        return urls;
    }

    public static URI toURI(String s) throws ConversionException {
        s = s != null ? s.trim() : s;
        URI u = null;
        if (s != null && s.length() > 0) {
            s = s.replace(File.separatorChar, '/');
            try {
                s = URLEncoder.encode(s, ENCODING_UTF8);
            }
            catch (UnsupportedEncodingException usee) {
                // empty catch block
            }
            for (int i = 0; i < ESCAPE.length; ++i) {
                s = s.replaceAll('%' + Integer.toString(ESCAPE[i], 16).toUpperCase(), String.valueOf(ESCAPE[i]));
            }
            if (s.toLowerCase().startsWith(URI_FILE) && s.length() > URI_FILE.length() + 1) {
                char c = s.charAt(URI_FILE.length());
                char d = s.charAt(URI_FILE.length() + 1);
                if (c == '/' && d != '/') {
                    s = s.replaceFirst(URI_FILE, "file://");
                }
            }
            try {
                u = new URI(s);
            }
            catch (URISyntaxException use) {
                throw new ConversionException(use);
            }
        }
        return u;
    }

    public static List toURIs(List l) throws ConversionException {
        ArrayList<URI> uris = new ArrayList<URI>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            uris.add(Conversion.toURI((String)i.next()));
        }
        return uris;
    }

    public static File toFile(URI u) throws ConversionException {
        String s;
        File f = null;
        if (u != null) {
            s = u.getPath();
            try {
                s = URLDecoder.decode(s, ENCODING_UTF8);
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        } else {
            throw new ConversionException("invalid file");
        }
        f = new File(s);
        return f;
    }

    public static Color toColor(String s) throws ConversionException {
        String octalPrefix = "0";
        String hex1Prefix = "0x";
        String hex2Prefix = "#";
        int decimalRadix = 10;
        int octalRadix = 8;
        int hexRadix = 16;
        int radix = decimalRadix;
        int i = -1;
        NumberFormatException e = null;
        if (s != null) {
            String t = s.toLowerCase();
            if (t.startsWith(hex1Prefix)) {
                s = s.substring(hex1Prefix.length());
                radix = hexRadix;
            } else if (t.startsWith(hex2Prefix)) {
                s = s.substring(hex2Prefix.length());
                radix = hexRadix;
            } else if (t.startsWith(octalPrefix)) {
                s = s.substring(octalPrefix.length());
                radix = octalRadix;
            } else {
                radix = decimalRadix;
            }
            try {
                i = Integer.parseInt(s, radix);
            }
            catch (NumberFormatException nfe) {
                e = nfe;
            }
        }
        if (i == -1 || e != null) {
            throw new ConversionException(e);
        }
        return new Color(i);
    }

    public static Class toClass(String s) throws ConversionException {
        Class<?> c = null;
        try {
            c = Class.forName(s);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConversionException(cnfe);
        }
        return c;
    }

    public static List toClasses(List l) throws ConversionException {
        ArrayList classes = new ArrayList();
        try {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                classes.add(Class.forName((String)i.next()));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConversionException(cnfe);
        }
        return classes;
    }
}

