/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.net.URI;
import net.jxta.ext.config.Util;

public class Address {
    private URI address = null;
    private int range = 1;

    public Address() {
        this(null);
    }

    public Address(Address a) {
        this.setAddress(a != null ? a.getAddress() : null);
        this.setPortRange(a != null ? a.getPortRange() : 0);
    }

    public URI getAddress() {
        return this.address;
    }

    public void setAddress(URI address) {
        if (address != null) {
            URI u;
            if (address.getPort() == -1 && (u = Util.toURI(address.getScheme(), address.getHost(), 0)) != null) {
                address = u;
            }
            if (Util.validateAddress(address, false).trim().length() > 0) {
                throw new IllegalArgumentException("invalid adress: " + address);
            }
        }
        this.address = address;
    }

    public int getPortRange() {
        return this.range;
    }

    public void setPortRange(int range) {
        if (range > -1 && range <= 65535) {
            this.range = range;
        }
    }

    public boolean equals(Object o) {
        return o instanceof Address && (o != null && ((Address)o).getAddress() != null && ((Address)o).getAddress().equals(this.getAddress()) || ((Address)o).getAddress() == null && this.getAddress() == null) && ((Address)o).getPortRange() == this.getPortRange();
    }

    public int hashCode() {
        int hash = this.range;
        if (this.address != null) {
            hash ^= this.address.hashCode();
        }
        return hash;
    }
}

