/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;

public class AbstractWebBrowser
extends JRootPane
implements HyperlinkListener,
ActionListener {
    Agent agent;
    JEditorPane textPane;
    JLabel msgbox;
    JTextField urlField;
    JFileChooser fileChooser;
    List<URL> listURL = new ArrayList<URL>(20);
    int currentLocation = -1;
    String homeAddress = "file:" + System.getProperty("madkit.dir", null) + File.separator + "docs" + File.separator + "index.html";

    public void setHomeAddress(String string) {
        this.homeAddress = string;
    }

    public String getHomeAddress() {
        return this.homeAddress;
    }

    public AbstractWebBrowser() {
        this.init();
    }

    public AbstractWebBrowser(Agent agent) {
        this.agent = agent;
        this.init();
    }

    public AbstractWebBrowser(Agent agent, String string) {
        this.agent = agent;
        this.setHomeAddress(string);
        this.init();
    }

    protected void init() {
        this.textPane = new JEditorPane();
        this.textPane.setEditable(false);
        this.textPane.addHyperlinkListener(this);
        this.textPane.setPreferredSize(new Dimension(500, 400));
        this.getContentPane().add((Component)new JScrollPane(this.textPane), "Center");
        this.msgbox = new JLabel(" ");
        this.getContentPane().add((Component)this.msgbox, "South");
        this.urlField = new JTextField();
        this.urlField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractWebBrowser.this.displayURL(AbstractWebBrowser.this.urlField.getText());
            }
        });
    }

    boolean goToLocation(URL uRL) {
        try {
            String string = uRL.toString();
            this.urlField.setText(string);
            this.printMsgBox("Loading page...");
            this.textPane.setPage(uRL);
            return true;
        }
        catch (IOException iOException) {
            this.printMsgBox("Cannot load the page: " + iOException.getMessage());
            return false;
        }
    }

    public void printMsgBox(String string) {
        this.msgbox.setText(string);
    }

    public void displayHomeURL() {
        this.displayURL(this.getHomeAddress());
    }

    public void displayURL(URL uRL) {
        if (this.goToLocation(uRL)) {
            ++this.currentLocation;
            if (this.currentLocation >= this.listURL.size()) {
                this.listURL.add(uRL);
            } else {
                this.listURL.set(this.currentLocation, uRL);
            }
        }
    }

    public void displayURL(String string) {
        try {
            this.displayURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            this.printMsgBox("Malformed URL: " + string);
        }
    }

    public void openPage() {
        this.fileChooser = new JFileChooser(System.getProperty("madkit.dir", null));
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string = file.getName();
                return file.isDirectory() || string.endsWith(".html") || string.endsWith(".htm");
            }

            public String getDescription() {
                return "HTML Files";
            }
        };
        this.fileChooser.setFileFilter(fileFilter);
        this.fileChooser.addChoosableFileFilter(fileFilter);
        int n = this.fileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            String string = "file:" + file.getPath();
            this.displayURL(string);
        }
    }

    public void back() {
        if (this.currentLocation > 0) {
            --this.currentLocation;
            this.goToLocation(this.listURL.get(this.currentLocation));
        }
    }

    public void forward() {
        if (this.currentLocation < this.listURL.size() - 1) {
            ++this.currentLocation;
            this.goToLocation(this.listURL.get(this.currentLocation));
        }
    }

    public void reload() {
        if (this.currentLocation != -1) {
            this.goToLocation(this.listURL.get(this.currentLocation));
        }
    }

    public void close() {
        this.setVisible(false);
        if (this.agent != null) {
            this.agent.killAgent((AbstractAgent)this.agent);
        }
    }

    public void quit(boolean bl) {
        if (this.agent != null) {
            this.agent.killAgent((AbstractAgent)this.agent);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            this.displayURL(hyperlinkEvent.getURL());
        } else if (eventType == HyperlinkEvent.EventType.ENTERED) {
            this.printMsgBox(hyperlinkEvent.getURL().toString());
        } else if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.printMsgBox(" ");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.printMsgBox("");
        this.command(actionEvent.getActionCommand());
    }

    protected void command(String string) {
        if (string.equals("Open")) {
            this.openPage();
        } else if (string.equals("Backward")) {
            this.back();
        } else if (string.equals("Forward")) {
            this.forward();
        } else if (string.equals("Reload")) {
            this.reload();
        } else if (string.equals("Close")) {
            this.close();
        } else if (string.equals("Exit")) {
            this.quit(true);
        }
    }

    void addMenuItem(JMenu jMenu, String string, String string2, int n) {
        this.addMenuItem(jMenu, string, string, string2, true, n, this);
    }

    void addMenuItem(JMenu jMenu, String string, String string2, String string3, boolean bl, int n, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.setToolTipText(string3);
        jMenuItem.addActionListener(actionListener);
        if (!bl) {
            jMenuItem.setEnabled(false);
        }
        if (n > 0) {
            if (n != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 0, false));
            }
        }
    }

    void addButton(JComponent jComponent, String string, String string2, String string3) {
        this.addButton(jComponent, string, string2, string3, this);
    }

    void addButton(JComponent jComponent, String string, String string2, String string3, ActionListener actionListener) {
        JButton jButton;
        if (string3 == null || string3.equals("")) {
            jButton = (JButton)jComponent.add(new JButton(string));
        } else {
            URL uRL = this.getClass().getResource(string3);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                jButton = (JButton)jComponent.add(new JButton(imageIcon));
            } else {
                jButton = (JButton)jComponent.add(new JButton(string));
            }
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string2);
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(actionListener);
    }
}

