/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.FactIDValue;
import jess.JessException;
import jess.Token;
import jess.Value;
import jess.ValueVector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BindingValue
extends Value
implements Serializable {
    private String case;
    private int goto;
    private int byte;
    private int char;
    private int else;

    public void resetFactNumber() {
        this.goto = 0;
    }

    public String getName() {
        return this.case;
    }

    public int getFactNumber() {
        return this.goto;
    }

    public int getSlotIndex() {
        return this.byte;
    }

    public int getSubIndex() {
        return this.char;
    }

    public int getType() {
        return this.else;
    }

    public Value resolveValue(Context context) throws JessException {
        if (context == null) {
            throw new JessException("BindingValue.resolveValue", "Null context ", "");
        }
        Token token = context.getToken();
        Fact fact = token == null || this.goto == token.size() ? context.getFact() : token.fact(this.goto);
        if (this.byte == -1) {
            return new FactIDValue(fact);
        }
        Value value = fact.get(this.byte);
        if (this.char == -1) {
            return value;
        }
        ValueVector valueVector = value.listValue(null);
        return valueVector.get(this.char);
    }

    public final Object externalAddressValue(Context context) throws JessException {
        return this.resolveValue(context).externalAddressValue(context);
    }

    public final Fact factValue(Context context) throws JessException {
        return this.resolveValue(context).factValue(context);
    }

    public final ValueVector listValue(Context context) throws JessException {
        return this.resolveValue(context).listValue(context);
    }

    public final int intValue(Context context) throws JessException {
        return this.resolveValue(context).intValue(context);
    }

    public final double floatValue(Context context) throws JessException {
        return this.resolveValue(context).floatValue(context);
    }

    public final double numericValue(Context context) throws JessException {
        return this.resolveValue(context).numericValue(context);
    }

    public final String atomValue(Context context) throws JessException {
        return this.resolveValue(context).atomValue(context);
    }

    public final String variableValue(Context context) throws JessException {
        return super.stringValue(context);
    }

    public final String stringValue(Context context) throws JessException {
        return this.resolveValue(context).stringValue(context);
    }

    public String toString() {
        return "?" + this.case;
    }

    public int hashCode() {
        return this.goto + 512 * this.byte + 262144 * this.char;
    }

    public boolean equals(Value value) {
        if (!(value instanceof BindingValue)) {
            return false;
        }
        BindingValue bindingValue = (BindingValue)value;
        return this.goto == bindingValue.goto && this.byte == bindingValue.byte && this.char == bindingValue.char;
    }

    BindingValue(String string, int n2, int n3, int n4, int n5) throws JessException {
        this.case = string;
        this.goto = n2;
        this.byte = n3;
        this.char = n4;
        this.else = n5;
    }

    BindingValue(BindingValue bindingValue) {
        super(bindingValue);
        this.case = bindingValue.case;
        this.goto = bindingValue.goto;
        this.byte = bindingValue.byte;
        this.char = bindingValue.char;
        this.else = bindingValue.else;
    }
}

