/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.swixml.SwingEngine;

public class AutoLoaderListener
implements ActionListener {
    private SwingEngine ldr;
    private SwingEngine cfg;
    private JDialog dlg;
    private JTextField httpProxyAddr;
    private JTextField httpProxyPort;
    private JTextField rdvBootstrap;
    private JTextField rlyBootstrap;
    private JList tcprdvlist;
    private JList httprdvlist;
    private JList tcprlylist;
    private JList httprlylist;

    public AutoLoaderListener(SwingEngine ldr, SwingEngine cfg) {
        this.ldr = ldr;
        this.cfg = cfg;
        this.dlg = (JDialog)ldr.getRootComponent();
        this.rdvBootstrap = (JTextField)ldr.find("id_rdvbootstrap");
        this.rlyBootstrap = (JTextField)ldr.find("id_rlybootstrap");
        this.httpProxyAddr = (JTextField)ldr.find("id_httpproxyaddress");
        this.httpProxyPort = (JTextField)ldr.find("id_httpproxyport");
        this.tcprdvlist = (JList)cfg.find("id_cfgtcprdvlist");
        this.httprdvlist = (JList)cfg.find("id_cfghttprdvlist");
        this.tcprlylist = (JList)cfg.find("id_cfgtcprlylist");
        this.httprlylist = (JList)cfg.find("id_cfghttprlylist");
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("AC_OK".equals(command)) {
            if (this.loadlist(this.rdvBootstrap.getText(), true) && this.loadlist(this.rlyBootstrap.getText(), false)) {
                this.dlg.setVisible(false);
                this.dlg.dispose();
                JOptionPane.showMessageDialog(this.ldr.getRootComponent(), "Successfully downloaded Rendezvous and Relay lists!");
            }
        } else if ("AC_CANCEL".equals(command)) {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        } else if ("enableHTTPProxy".equals(command)) {
            if (!this.httpProxyAddr.isEnabled()) {
                System.setProperty("http.proxyHost", this.httpProxyAddr.getText());
                System.setProperty("http.proxyPort", this.httpProxyPort.getText());
                this.enable(this.httpProxyAddr);
                this.enable(this.httpProxyPort);
            } else {
                System.setProperty("http.proxyHost", "");
                System.setProperty("http.proxyPort", "");
                this.disable(this.httpProxyAddr);
                this.disable(this.httpProxyPort);
            }
        }
    }

    private boolean loadlist(String urlString, boolean rdv) {
        DefaultListModel httpListModel;
        DefaultListModel tcpListModel;
        if (urlString.equals("")) {
            return true;
        }
        if (rdv) {
            tcpListModel = (DefaultListModel)this.tcprdvlist.getModel();
            httpListModel = (DefaultListModel)this.httprdvlist.getModel();
        } else {
            tcpListModel = (DefaultListModel)this.tcprlylist.getModel();
            httpListModel = (DefaultListModel)this.httprlylist.getModel();
        }
        InputStream inp = null;
        try {
            String s;
            inp = new URL(urlString).openStream();
            BufferedReader l = new BufferedReader(new InputStreamReader(inp));
            int valid = 0;
            while ((s = l.readLine()) != null) {
                if ((s = s.toLowerCase()).startsWith("tcp://")) {
                    tcpListModel.addElement(s.substring(6));
                    ++valid;
                    continue;
                }
                if (!s.startsWith("http://")) continue;
                httpListModel.addElement(s.substring(7));
                ++valid;
            }
            if (valid == 0) {
                JOptionPane.showMessageDialog(this.ldr.getRootComponent(), "Retrieved lists were invalid. Please try again.", "Download Error", 0);
                return false;
            }
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this.ldr.getRootComponent(), "You have entered an invalid URL.", "Download Error", 0);
            return false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.ldr.getRootComponent(), "Could not download lists." + (this.httpProxyAddr.isEnabled() ? "" : " You might need a proxy."), "Download Error", 0);
            return false;
        }
        try {
            inp.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    private void requestFocus(Component component) {
        component.requestFocus();
    }

    private void disable(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            this.disable(components[i]);
        }
    }

    private void disable(Component component) {
        component.setEnabled(false);
    }

    private void enable(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            this.enable(components[i]);
        }
    }

    private void enable(Component component) {
        component.setEnabled(true);
    }
}

