/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config.probes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jxta.ext.config.Address;
import net.jxta.ext.config.Env;
import net.jxta.ext.config.PublicAddress;
import net.jxta.ext.config.Transport;
import net.jxta.ext.config.Util;
import net.jxta.ext.config.probes.PingPong;
import net.jxta.ext.http.Dispatcher;
import net.jxta.ext.http.Message;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RelayProbe {
    private static final long MAX_WAIT = 7000L;
    private static final String ORIGINATOR = "originator";
    private static final String DELIMITER = ":";
    private static final Logger LOG = Logger.getLogger((String)RelayProbe.class.getName());
    private List transports = null;
    private List reflection = null;
    private String datagram = null;

    public RelayProbe(List reflection, List transports) {
        if (reflection != null) {
            Collections.shuffle(reflection);
        }
        this.reflection = reflection;
        this.transports = transports;
    }

    public boolean probe() {
        boolean reachible = false;
        if (this.reflection == null || this.reflection.size() == 0 || this.transports == null || this.transports.size() == 0) {
            return reachible;
        }
        List inbound = this.getIncoming();
        if (inbound == null || inbound.size() == 0) {
            return reachible;
        }
        List sockets = new ArrayList();
        Iterator r = this.reflection.iterator();
        while (!reachible && r.hasNext()) {
            URL reflection = null;
            try {
                reflection = ((URI)r.next()).toURL();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
            if (reflection == null) continue;
            sockets = this.bindSockets(inbound);
            if (sockets != null && sockets.size() > 0 && this.datagram != null && this.datagram.length() > 0) {
                Iterator s = sockets.iterator();
                while (s.hasNext()) {
                    ((Thread)s.next()).start();
                }
                String response = this.dispatch(reflection, this.datagram, 7000L * (long)sockets.size());
                Iterator s2 = sockets.iterator();
                while (s2.hasNext()) {
                    ((Thread)s2.next()).interrupt();
                }
                reachible = this.isReachible(response);
            }
            sockets.clear();
        }
        return reachible;
    }

    private List getIncoming() {
        ArrayList<Address> inbound = new ArrayList<Address>();
        Iterator ti = this.transports.iterator();
        while (ti.hasNext()) {
            Transport t = (Transport)ti.next();
            if (!t.isIncoming()) continue;
            boolean publicOnly = false;
            Iterator pi = t.getPublicAddresses().iterator();
            while (pi.hasNext()) {
                PublicAddress pa = (PublicAddress)pi.next();
                publicOnly |= pa.isExclusive();
                if (Util.isMulticast(pa.getAddress()) || Env.ALL_ADDRESSES.getHostAddress().equals(pa.getAddress().getHost())) continue;
                inbound.add(pa);
            }
            if (publicOnly) continue;
            Iterator ai = t.getAddresses().iterator();
            while (ai.hasNext()) {
                Address a = (Address)ai.next();
                if (a.getAddress() == null || Util.isMulticast(a.getAddress()) || Env.ALL_ADDRESSES.getHostAddress().equals(a.getAddress().getHost())) continue;
                inbound.add(a);
            }
        }
        return inbound;
    }

    private List bindSockets(List inbound) {
        ArrayList<PingPong> pings = new ArrayList<PingPong>();
        StringBuffer sb = new StringBuffer();
        Iterator i = inbound.iterator();
        while (i.hasNext()) {
            ServerSocket ss;
            InetAddress ia;
            int port;
            URI u;
            block3: {
                Address a = (Address)i.next();
                u = a != null ? a.getAddress() : null;
                String h = u != null ? u.getHost() : null;
                int n = port = u != null ? u.getPort() : -1;
                if (h == null || port <= -1) continue;
                ia = null;
                try {
                    ia = InetAddress.getByAddress(h, Util.inetAddressToBytes(h));
                }
                catch (UnknownHostException uhe) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block3;
                    LOG.error((Object)"invalid address", (Throwable)uhe);
                }
            }
            if (ia == null || (ss = Util.getServerSocket(ia, port)) == null) continue;
            pings.add(new PingPong(ss));
            sb.append(u + (i.hasNext() ? "\n" : ""));
        }
        this.datagram = sb.toString().trim();
        return pings;
    }

    private String dispatch(URL reflection, String msg, long wait) {
        Message r = null;
        try {
            r = new Dispatcher(reflection, new Message(msg.toString().trim()), wait).dispatch();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return r != null && r.getBody() != null ? r.getBody().trim() : null;
    }

    private boolean isReachible(String response) {
        boolean reachible = false;
        if (response != null && response.length() > 0) {
            BufferedReader br = new BufferedReader(new StringReader(response));
            String ln = null;
            int i = -1;
            try {
                while ((ln = br.readLine()) != null && !reachible) {
                    if (ln.toLowerCase().startsWith(ORIGINATOR) || (i = ln.lastIndexOf(DELIMITER)) <= -1 || i + DELIMITER.length() >= ln.length()) continue;
                    reachible = Boolean.valueOf(ln.substring(i + DELIMITER.length()));
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return reachible;
    }
}

