/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config.probes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

class PingPong
extends Thread {
    private static final String PING = "ping";
    private static final String PONG = "pong";
    private static final int MAX = 25;
    private ServerSocket server = null;

    public PingPong(ServerSocket server) {
        this.server = server;
        this.setDaemon(true);
        this.setName(this.getClass().getName());
    }

    public void run() {
        try {
            this.server.setSoTimeout(50);
        }
        catch (SocketException se) {
            // empty catch block
        }
        while (!this.isInterrupted()) {
            try {
                this.handle(this.server.accept());
            }
            catch (IOException ioe) {}
        }
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.server = null;
        }
    }

    private void handle(Socket s) throws IOException {
        InputStream is = s.getInputStream();
        StringBuffer sb = new StringBuffer();
        int c = -1;
        while ((c = is.read()) != -1) {
            sb.append((char)c);
            if (sb.toString().toLowerCase().indexOf(PING) > -1) {
                OutputStream os = s.getOutputStream();
                os.write(PONG.getBytes());
                os.flush();
                os.close();
                break;
            }
            if (sb.length() <= 25) continue;
            break;
        }
    }
}

