/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config.optimizers;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jxta.ext.config.Configurator;
import net.jxta.ext.config.optimizers.BaseOptimizer;
import net.jxta.ext.config.probes.RelayProbe;
import net.jxta.ext.http.Dispatcher;
import net.jxta.ext.http.Message;

public class RelayOptimizer
extends BaseOptimizer {
    public static final String REFLECTION_SERVICE_BOOTSTRAP_KEY = "reflection.service.bootstrap";
    public static final String REFLECTION_SERVICE_MAX_WAIT_KEY = "reflection.service.max_wait";
    private static final int MAX_WAIT = 7000;
    private URI bootstrap = null;
    private int max_wait = 7000;

    public RelayOptimizer() {
        this.configure();
    }

    public void optimize(Configurator configurator) {
        List reflection;
        List list = reflection = this.bootstrap != null ? this.getReflectionServices(configurator, this.bootstrap) : null;
        if (reflection != null && reflection.size() > 0) {
            RelayProbe rp = new RelayProbe(reflection, configurator.getTransports());
            configurator.setRelayOutgoing(!rp.probe());
        }
    }

    private void configure() {
        List l = this.getProperty(REFLECTION_SERVICE_BOOTSTRAP_KEY);
        if (l != null && l.size() > 0) {
            try {
                this.bootstrap = new URI((String)l.get(0));
            }
            catch (URISyntaxException use) {
                // empty catch block
            }
        }
        if ((l = this.getProperty(REFLECTION_SERVICE_MAX_WAIT_KEY)) != null && l.size() > 0) {
            try {
                this.max_wait = Integer.parseInt((String)l.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private List getReflectionServices(Configurator configurator, URI bootstrap) {
        URL u = null;
        try {
            u = bootstrap != null ? bootstrap.toURL() : null;
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        ArrayList<URI> l = null;
        if (u != null) {
            String s;
            Message results = null;
            try {
                results = new Dispatcher(u, this.max_wait).dispatch();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            String string = s = results != null ? results.getBody() : null;
            if (s != null) {
                StreamTokenizer st = new StreamTokenizer(new StringReader(s));
                l = new ArrayList<URI>();
                st.wordChars(32, 126);
                st.eolIsSignificant(true);
                try {
                    block11: while (st.nextToken() != -1) {
                        switch (st.ttype) {
                            case -3: {
                                try {
                                    l.add(new URI(st.sval.trim()));
                                }
                                catch (URISyntaxException use) {}
                                continue block11;
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
        return l != null ? l : Collections.EMPTY_LIST;
    }
}

