/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jxta.ext.config.Conversion;
import net.jxta.ext.config.ConversionException;
import net.jxta.ext.config.ResourceNotFoundException;
import net.jxta.ext.config.Util;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Resource {
    private static final String ROOT = "ROOT";
    private static final String PATH_DELIMITER = "/";
    private static final String FILE_SEPERATOR = System.getProperty("file.separator", "/");
    private static final String EXCEPTION_PREFIX = "unable to find resource: ";
    private static final Object lock = new Object();
    private static final boolean VERBOSE = false;
    private List resources = new ArrayList();
    private Element root = new Element("ROOT");

    public static URL toURL(String s) throws ConversionException {
        return Conversion.toURL(s);
    }

    public static URL toURL(File f) throws ConversionException {
        return Conversion.toURL(f);
    }

    public void load(URL resource) throws ResourceNotFoundException {
        this.process(resource);
    }

    public void load(String resource) throws ResourceNotFoundException {
        block6: {
            Exception e = null;
            try {
                this.load(Resource.toURL(resource));
            }
            catch (ConversionException ce) {
                e = ce;
            }
            catch (ResourceNotFoundException rnfe) {
                e = rnfe;
            }
            if (e != null) {
                e = null;
                try {
                    this.process(resource);
                }
                catch (ResourceNotFoundException rnfe) {
                    if (resource.startsWith(FILE_SEPERATOR)) break block6;
                    this.process(FILE_SEPERATOR + resource);
                }
            }
        }
    }

    public void load(File resource) throws ResourceNotFoundException, MalformedURLException {
        this.load(resource.toURL());
    }

    public void load(String resource, Class clazz) throws ResourceNotFoundException {
        this.process(resource, clazz);
    }

    public void load(InputStream is) throws ResourceNotFoundException {
        this.process(is);
    }

    public InputStream getResourceAsStream(String resource) {
        return this.getResourceAsStream(resource, null);
    }

    public InputStream getResourceAsStream(String resource, Class clazz) {
        if (clazz == null) {
            clazz = Resource.class;
        }
        return clazz.getResourceAsStream(resource);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String d) {
        return this.getValue(key, d);
    }

    public int getInt(String key) throws ConversionException {
        return this.getInt(key, null);
    }

    public int getInt(String key, int d) {
        int i = 0;
        try {
            i = this.getInt(key, new Integer(d));
        }
        catch (ConversionException ce) {
            // empty catch block
        }
        return i;
    }

    public int getInt(String key, Integer d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toInt(s);
    }

    public long getLong(String key) throws ConversionException {
        return this.getLong(key, null);
    }

    public long getLong(String key, long d) {
        long i = 0L;
        try {
            i = this.getLong(key, new Long(d));
        }
        catch (ConversionException ce) {
            // empty catch block
        }
        return i;
    }

    public long getLong(String key, Long d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toLong(s);
    }

    public float getFloat(String key) throws ConversionException {
        return this.getFloat(key, null);
    }

    public float getFloat(String key, Float d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toFloat(s);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public boolean getBoolean(String key, boolean d) {
        return this.getBoolean(key, (Boolean)d);
    }

    public boolean getBoolean(String key, Boolean d) {
        String s = this.get(key, d != null ? d.toString() : null);
        return Boolean.valueOf(s);
    }

    public char getChar(String key) throws ConversionException {
        return this.getChar(key, new Character('\u0000'));
    }

    public char getChar(String key, Character d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toChar(s);
    }

    public URL getURL(String key) throws ConversionException {
        return this.getURL(key, null);
    }

    public URL getURL(String key, URL d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toURL(s);
    }

    public List getURLs(String key) throws ConversionException {
        return this.getURLs(key, null);
    }

    public List getURLs(String key, URL d) throws ConversionException {
        List values = this.getAll(key, d != null ? d.toString() : null);
        return Conversion.toURLs(values);
    }

    public URI getURI(String key) throws ConversionException {
        return this.getURI(key, null);
    }

    public URI getURI(String key, URI d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toURI(s);
    }

    public List getURIs(String key) throws ConversionException {
        return this.getURIs(key, null);
    }

    public List getURIs(String key, URI d) throws ConversionException {
        List values = this.getAll(key, d != null ? d.toString() : null);
        return Conversion.toURIs(values);
    }

    public Color getColor(String key) throws ConversionException {
        return this.getColor(key, null);
    }

    public Color getColor(String key, Color d) throws ConversionException {
        String s = this.get(key, d != null ? d.toString() : null);
        return Conversion.toColor(s);
    }

    public Resource getResource(String key) {
        List r = this.getResources(key);
        return r != null ? (Resource)r.get(0) : null;
    }

    public List getResources(String key) {
        ArrayList<Resource> r = new ArrayList<Resource>();
        Iterator v = this.getValues(key).iterator();
        while (v.hasNext()) {
            Object o = v.next();
            if (!(o instanceof Element)) continue;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                new XMLOutputter().output(new Document((Element)o), (OutputStream)buf);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            Resource cr = new Resource();
            try {
                cr.load(new ByteArrayInputStream(buf.toByteArray()));
            }
            catch (ResourceNotFoundException rnfe) {
                rnfe.printStackTrace();
            }
            r.add(cr);
        }
        return r;
    }

    public Class getClass(String key) throws ConversionException {
        return this.getClass(key, null);
    }

    public Class getClass(String key, Class d) throws ConversionException {
        String s = this.get(key, d != null ? d.getName() : null);
        return Conversion.toClass(s);
    }

    public List getClasses(String key) throws ConversionException {
        return this.getClasses(key, null);
    }

    public List getClasses(String key, URL d) throws ConversionException {
        List values = this.getAll(key, d != null ? d.toString() : null);
        return Conversion.toClasses(values);
    }

    public void set(String key) {
        this.set(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) {
        Element element = this.root;
        synchronized (element) {
            Object o = this.getValue(key, false);
            if (o != null) {
                if (o instanceof Attribute) {
                    Attribute a = (Attribute)o;
                    if (value != null) {
                        a.setValue(value);
                    } else {
                        a.getParent().removeAttribute(a);
                    }
                } else if (o instanceof Element) {
                    Element e = (Element)o;
                    if (value != null) {
                        ArrayList<Text> l = new ArrayList<Text>();
                        l.add(new Text(value));
                        e.setContent(l);
                    } else {
                        e.getParent().removeContent((Content)e);
                    }
                }
            }
        }
    }

    public List getAll(String key) {
        return this.getAll(key, null);
    }

    public List getAll(String key, String d) {
        return this.getValues(key, d);
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public String toString() {
        String s = null;
        if (this.root != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                new XMLOutputter(Format.getPrettyFormat()).output(new Document(this.root), (OutputStream)buf);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            s = buf.toString();
        }
        return s != null ? s : "null";
    }

    private void process(Object resource) throws ResourceNotFoundException {
        this.process(resource, null);
    }

    private void process(Object resource, Class clazz) throws ResourceNotFoundException {
        if (!this.resources.contains(resource)) {
            Element el = null;
            Throwable ex = null;
            if (resource instanceof URL) {
                try {
                    el = this.getRootElement((URL)resource);
                }
                catch (JDOMException jde) {
                    ex = jde;
                }
                catch (IOException ioe) {
                    ex = ioe;
                }
            } else if (resource instanceof String) {
                if (clazz == null) {
                    clazz = Resource.class;
                }
                try {
                    el = this.getElement(clazz.getResourceAsStream((String)resource));
                }
                catch (JDOMException jde) {
                    jde.printStackTrace();
                    ex = jde;
                }
                catch (IOException ioe) {
                    ex = ioe;
                }
            } else if (resource instanceof InputStream) {
                try {
                    el = this.getElement((InputStream)resource);
                }
                catch (JDOMException jde) {
                    ex = jde;
                }
                catch (IOException ioe) {
                    ex = ioe;
                }
                resource = new String("InputStream." + System.currentTimeMillis());
            }
            if (el != null && ex == null) {
                this.load(resource, el);
            } else {
                throw new ResourceNotFoundException("unable to find resource: : " + resource.toString(), ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element getElement(InputStream is) throws JDOMException, IOException {
        Element element = null;
        try {
            try {
                element = this.getRootElement(is);
            }
            catch (JDOMException jde) {
                throw jde;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            Object var5_3 = null;
            if (is == null) return element;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        is.close();
        return element;
    }

    private Element getRootElement(URL resource) throws JDOMException, IOException {
        return new SAXBuilder().build(resource).getRootElement();
    }

    private Element getRootElement(InputStream is) throws JDOMException, IOException {
        return new SAXBuilder().build(is).getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Object resource, Element element) {
        if (this.resources != null && element != null) {
            Object object = lock;
            synchronized (object) {
                this.resources.add(resource);
                this.root.addContent((Content)element.clone());
            }
        }
    }

    private String getValue(String key, String d) {
        String v = null;
        Object o = this.getValue(key);
        if (o != null) {
            if (o instanceof Attribute) {
                v = ((Attribute)o).getValue();
            } else if (o instanceof Element) {
                v = ((Element)o).getTextTrim();
            }
        }
        return Util.expand(v != null ? v : d);
    }

    private Object getValue(String key) {
        return this.getValue(key, true);
    }

    private Object getValue(String key, boolean isClone) {
        Object o = null;
        XPath xp = this.getXP(key);
        if (xp != null) {
            try {
                o = xp.selectSingleNode((Object)this.getRootDocument(isClone));
            }
            catch (JaxenException je) {
                // empty catch block
            }
        }
        return o;
    }

    private List getValues(String key, String d) {
        ArrayList<String> v = new ArrayList<String>();
        Object o = null;
        Iterator n = this.getValues(key).iterator();
        while (n.hasNext()) {
            o = n.next();
            if (o == null) continue;
            if (o instanceof Attribute) {
                v.add(((Attribute)o).getValue());
                continue;
            }
            if (!(o instanceof Element)) continue;
            v.add(((Element)o).getTextTrim());
        }
        if (v.size() == 0 && d != null) {
            v.add(d);
        }
        return v;
    }

    private List getValues(String key) {
        ArrayList v = new ArrayList();
        XPath xp = this.getXP(key);
        if (xp != null) {
            try {
                Iterator n = xp.selectNodes((Object)this.getRootDocument()).iterator();
                while (n.hasNext()) {
                    v.add(n.next());
                }
            }
            catch (JaxenException je) {
                // empty catch block
            }
        }
        return v;
    }

    private XPath getXP(String key) {
        JDOMXPath xp = null;
        try {
            xp = new JDOMXPath("/ROOT/" + key);
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return xp;
    }

    private Document getRootDocument() {
        return this.getRootDocument(true);
    }

    private Document getRootDocument(boolean isClone) {
        Document d = null;
        if (isClone) {
            d = new Document((Element)this.root.clone());
        } else {
            d = this.root.getDocument();
            if (d == null) {
                d = new Document(this.root);
            }
        }
        return d;
    }
}

