/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.ext.config;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import net.jxta.ext.config.Resource;
import net.jxta.ext.config.ResourceNotFoundException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Profile {
    public static final Profile EDGE = new Profile("edge.xml");
    public static final Profile EDGE_TCP = new Profile("edgeTcp.xml");
    public static final Profile EDGE_HTTP = new Profile("edgeHttp.xml");
    public static final Profile SUPER = new Profile("super.xml");
    public static final Profile SUPER_TCP = new Profile("superTcp.xml");
    public static final Profile SUPER_HTTP = new Profile("superHttp.xml");
    public static final Profile RENDEZVOUS = new Profile("rendezVous.xml");
    public static final Profile RENDEZVOUS_TCP = new Profile("rendezVousTcp.xml");
    public static final Profile RENDEZVOUS_HTTP = new Profile("rendezVousHttp.xml");
    public static final Profile RELAY = new Profile("relay.xml");
    public static final Profile RELAY_TCP = new Profile("relayTcp.xml");
    public static final Profile RELAY_HTTP = new Profile("relayHttp.xml");
    public static final Profile LOCAL = new Profile("local.xml");
    public static final Profile DEFAULT = EDGE;
    protected static final Profile SEED = new Profile("seed.xml");
    private static final String RESOURCE_BASE = "resources/";
    private static final Logger LOG = Logger.getLogger((String)Profile.class.getName());
    private Resource profile;
    private static HashMap profiles = new HashMap();

    public static Profile get(String profile) {
        profile = profile != null ? profile.trim() : profile;
        Profile p = (Profile)profiles.get(profile);
        return p != null ? p : DEFAULT;
    }

    public static Iterator getProfiles() {
        return profiles.keySet().iterator();
    }

    public static void add(String name, Profile profile) {
        if (null != name && null != profile) {
            profiles.put(name, profile);
        }
    }

    public Profile(URL profile) {
        block2: {
            this.profile = new Resource();
            try {
                this.profile.load(profile);
            }
            catch (ResourceNotFoundException rnfe) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid resource location", (Throwable)rnfe);
            }
        }
    }

    public Profile(InputStream is) {
        block2: {
            this.profile = new Resource();
            try {
                this.profile.load(is);
            }
            catch (ResourceNotFoundException rnfe) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid resource format", (Throwable)rnfe);
            }
        }
    }

    protected Resource getProfile() {
        return this.profile;
    }

    private Profile(String profile) {
        block2: {
            this.profile = new Resource();
            try {
                this.profile.load(RESOURCE_BASE + profile, Profile.class);
            }
            catch (ResourceNotFoundException rnfe) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"invalid resource location", (Throwable)rnfe);
            }
        }
    }

    static {
        profiles.put("Default", DEFAULT);
        profiles.put("Edge", EDGE);
        profiles.put("Edge (Tcp)", EDGE_TCP);
        profiles.put("Edge (Http)", EDGE_HTTP);
        profiles.put("Super", SUPER);
        profiles.put("Super (Tcp)", SUPER_TCP);
        profiles.put("Super (Http)", SUPER_HTTP);
        profiles.put("Rendezvous", RENDEZVOUS);
        profiles.put("Rendezvous (Tcp)", RENDEZVOUS_TCP);
        profiles.put("Rendezvous (Http)", RENDEZVOUS_HTTP);
        profiles.put("Relay", RELAY);
        profiles.put("Relay (Tcp)", RELAY_TCP);
        profiles.put("Relay (Http)", RELAY_HTTP);
        profiles.put("Local", LOCAL);
    }

    public static class Key {
        public static final String JXTA = "/jxta";
        public static final String PEER = "/jxta/peer";
        public static final String PEER_NAME = "/jxta/peer/@name";
        public static final String PEER_ID = "/jxta/peer/@id";
        public static final String PEER_DESCRIPTOR = "/jxta/peer/@descriptor";
        public static final String HOME_ADDRESS = "/jxta/peer/@home";
        public static final String SECURITY = "/jxta/peer/security";
        public static final String SECURITY_IS_ENABLED = "/jxta/peer/security/@enabled";
        public static final String PRINCIPAL = "/jxta/peer/security/@principal";
        public static final String ROOT_CERTIFICATE = "/jxta/peer/rootCert";
        public static final String ROOT_CERTIFICATE_ADDRESS = "/jxta/peer/rootCert/@address";
        public static final String TRACE = "/jxta/peer/@trace";
        public static final String PEER_DESCRIPTION = "/jxta/peer/description";
        public static final String PEER_PROXY_ADDRESS = "/jxta/peer/proxy";
        public static final String NETWORK = "/jxta/network";
        public static final String RENDEZVOUS = "/jxta/network/rendezVous";
        public static final String RENDEZVOUS_BOOTSTRAP_ADDRESS = "/jxta/network/rendezVous/@bootstrap";
        public static final String RENDEZVOUS_DISCOVERY_IS_ENABLED = "/jxta/network/rendezVous/@discovery";
        public static final String RENDEZVOUS_ADDRESS = "/jxta/network/rendezVous/address";
        public static final String RELAYS = "/jxta/network/relays";
        public static final String RELAYS_BOOTSTRAP_ADDRESS = "/jxta/network/relays/@bootstrap";
        public static final String RELAYS_DISCOVERY_IS_ENABLED = "/jxta/network/relays/@discovery";
        public static final String RELAYS_ADDRESS = "/jxta/network/relays/address";
        public static final String REFLECTION = "/jxta/network/reflection";
        public static final String REFLECTION_BOOTSTRAP_ADDRESS = "/jxta/network/reflection/@bootstrap";
        public static final String TRANSPORT = "/jxta/transport";
        public static final String TCP = "/jxta/transport/tcp";
        public static final String TCP_IS_ENABLED = "/jxta/transport/tcp/@enabled";
        public static final String TCP_INCOMING = "/jxta/transport/tcp/incoming";
        public static final String TCP_INCOMING_IS_ENABLED = "/jxta/transport/tcp/incoming/@enabled";
        public static final String TCP_OUTGOING = "/jxta/transport/tcp/outgoing";
        public static final String TCP_OUTGOING_IS_ENABLED = "/jxta/transport/tcp/@enabled";
        public static final String TCP_ADDRESS = "/jxta/transport/tcp/address";
        public static final String TCP_PORT_RANGE = "/jxta/transport/tcp/address/@range";
        public static final String TCP_PUBLIC_ADDRESS = "/jxta/transport/tcp/publicAddress";
        public static final String TCP_PUBLIC_ADDRESS_EXCLUSIVE_IS_ENABLED = "/jxta/transport/tcp/publicAddress/@exclusive";
        public static final String TCP_PROXY_ADDRESS = "/jxta/transport/tcp/proxy";
        public static final String TCP_PROXY_IS_ENABLED = "/jxta/transport/tcp/proxy/@enabled";
        public static final String MULTICAST = "/jxta/transport/tcp/address/multicast";
        public static final String MULTICAST_IS_ENABLED = "/jxta/transport/tcp/address/multicast/@enabled";
        public static final String MULTICAST_SIZE = "/jxta/transport/tcp/address/multicast/@size";
        public static final String HTTP = "/jxta/transport/http";
        public static final String HTTP_IS_ENABLED = "/jxta/transport/http/@enabled";
        public static final String HTTP_INCOMING = "/jxta/transport/http/incoming";
        public static final String HTTP_INCOMING_IS_ENABLED = "/jxta/transport/http/incoming/@enabled";
        public static final String HTTP_OUTGOING = "/jxta/transport/http/outgoing";
        public static final String HTTP_OUTGOING_IS_ENABLED = "/jxta/transport/http/outgoing/@enabled";
        public static final String HTTP_ADDRESS = "/jxta/transport/http/address";
        public static final String HTTP_PORT_RANGE = "/jxta/transport/http/address/@range";
        public static final String HTTP_PUBLIC_ADDRESS = "/jxta/transport/http/publicAddress";
        public static final String HTTP_PUBLIC_ADDRESS_EXCLUSIVE_IS_ENABLED = "/jxta/transport/http/publicAddress/@exclusive";
        public static final String HTTP_PROXY_ADDRESS = "/jxta/transport/http/proxy";
        public static final String HTTP_PROXY_IS_ENABLED = "/jxta/transport/http/proxy/@enabled";
        public static final String SERVICE = "/jxta/service";
        public static final String RENDEZVOUS_SERVICE = "/jxta/service/rendezVous";
        public static final String RENDEZVOUS_SERVICE_IS_ENABLED = "/jxta/service/rendezVous/@enabled";
        public static final String RENDEZVOUS_SERVICE_AUTO_START = "/jxta/service/rendezVous/autoStart";
        public static final String RENDEZVOUS_SERVICE_AUTO_START_IS_ENABLED = "/jxta/service/rendezVous/@enabled";
        public static final String RELAY_SERVICE = "/jxta/service/relay";
        public static final String RELAY_SERVICE_IS_ENABLED = "/jxta/service/relay/@enabled";
        public static final String RELAY_SERVICE_QUEUE_SIZE = "/jxta/service/relay/@queueSize";
        public static final String RELAY_SERVICE_INCOMING = "/jxta/service/relay/incoming";
        public static final String RELAY_SERVICE_INCOMING_IS_ENABLED = "/jxta/service/relay/incoming/@enabled";
        public static final String RELAY_SERVICE_INCOMING_MAXIMUM = "/jxta/service/relay/incoming/@maximum";
        public static final String RELAY_SERVICE_INCOMING_LEASE = "/jxta/service/relay/incoming/@lease";
        public static final String RELAY_SERVICE_OUTGOING = "/jxta/service/relay/outgoing";
        public static final String RELAY_SERVICE_OUTGOING_IS_ENABLED = "/jxta/service/relay/outgoing/@enabled";
        public static final String RELAY_SERVICE_OUTGOING_MAXIMUM = "/jxta/service/relay/outgoing/@maximum";
        public static final String RELAY_SERVICE_OUTGOING_LEASE = "/jxta/service/relay/outgoing/@lease";
        public static final String ENDPOINT_SERVICE = "/jxta/service/endpoint";
        public static final String ENDPOINT_SERVICE_QUEUE_SIZE = "/jxta/service/endpoint/@queueSize";
        public static final String PROXY_SERVICE = "/jxta/service/proxy";
        public static final String PROXY_SERVICE_IS_ENABLED = "/jxta/service/proxy/@enabled";
        public static final String CONFIGURATION = "/jxta/configuration";
        public static final String CONFIGURATION_OPTIMIZER = "/jxta/configuration/optimizer";
        public static final String CONFIGURATION_OPTIMIZER_CLASS = "/jxta/configuration/optimizer/@class";
        public static final String OPTIMIZER_PROPERTY_NAME = "/jxta/configuration/optimizer[@class=''{0}'']/property/@name";
        public static final String OPTIMIZER_PROPERTY_VALUE = "/jxta/configuration/optimizer[@class=''{0}'']/property[@name=''{1}'']";

        private Key() {
        }
    }
}

